/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.zip;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.xmind.core.Core;
import org.xmind.core.io.IInputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipFileInputSource
implements IInputSource {
    private ZipFile zipFile;

    public ZipFileInputSource(ZipFile zipFile) {
        this.zipFile = zipFile;
    }

    @Override
    public Iterator<String> getEntries() {
        return new EntryIterAdapter(this.zipFile.entries());
    }

    @Override
    public boolean hasEntry(String entryName) {
        return this.zipFile.getEntry(entryName) != null;
    }

    @Override
    public InputStream getEntryStream(String entryName) {
        ZipEntry entry = this.zipFile.getEntry(entryName);
        if (entry == null) {
            return null;
        }
        try {
            return this.zipFile.getInputStream(entry);
        }
        catch (IOException e) {
            Core.getLogger().log(e);
            return null;
        }
    }

    public void closeZipFile() {
        try {
            this.zipFile.close();
        }
        catch (IOException e) {
            Core.getLogger().log(e);
        }
    }

    @Override
    public long getEntrySize(String entryName) {
        ZipEntry entry;
        if (this.zipFile != null && (entry = this.zipFile.getEntry(entryName)) != null) {
            return entry.getSize();
        }
        return -1L;
    }

    @Override
    public long getEntryTime(String entryName) {
        ZipEntry entry;
        if (this.zipFile != null && (entry = this.zipFile.getEntry(entryName)) != null) {
            return entry.getTime();
        }
        return -1L;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EntryIterAdapter
    implements Iterator<String> {
        private Enumeration<? extends ZipEntry> entries;

        public EntryIterAdapter(Enumeration<? extends ZipEntry> entries) {
            this.entries = entries;
        }

        @Override
        public boolean hasNext() {
            return this.entries.hasMoreElements();
        }

        @Override
        public String next() {
            ZipEntry entry = this.entries.nextElement();
            if (entry == null) {
                return null;
            }
            return entry.getName();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

