/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xmind.core.Core;
import org.xmind.core.IAdaptable;
import org.xmind.core.ICloneData;
import org.xmind.core.IFileEntry;
import org.xmind.core.IImage;
import org.xmind.core.IManifest;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.IWorkbookComponent;
import org.xmind.core.internal.CloneData;
import org.xmind.core.internal.ICloneDataListener;
import org.xmind.core.internal.dom.InternalHyperlinkUtils;
import org.xmind.core.internal.dom.MarkerGroupImpl;
import org.xmind.core.internal.dom.MarkerImpl;
import org.xmind.core.internal.dom.MarkerSheetImpl;
import org.xmind.core.internal.dom.StyleImpl;
import org.xmind.core.internal.dom.StyleSheetImpl;
import org.xmind.core.internal.dom.WorkbookImpl;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerGroup;
import org.xmind.core.marker.IMarkerResource;
import org.xmind.core.marker.IMarkerSheet;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyled;
import org.xmind.core.util.DOMUtils;
import org.xmind.core.util.FileUtils;
import org.xmind.core.util.HyperlinkUtils;
import org.xmind.core.util.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkbookUtilsImpl {
    private WorkbookUtilsImpl() {
    }

    public static ICloneData clone(IWorkbook targetWorkbook, Collection<? extends Object> sources, ICloneData prevResult) {
        CloneData result = new CloneData(sources, prevResult);
        for (Object object : sources) {
            Object cloned;
            if (result.get(object) != null) continue;
            if (object instanceof IImage) {
                cloned = WorkbookUtilsImpl.doClone((WorkbookImpl)targetWorkbook, ((IImage)object).getParent(), result);
                if (cloned instanceof ITopic) {
                    cloned = ((ITopic)cloned).getImage();
                }
            } else {
                cloned = WorkbookUtilsImpl.doClone((WorkbookImpl)targetWorkbook, object, result);
            }
            if (cloned == null) continue;
            result.put(object, cloned);
        }
        return result;
    }

    private static Object doClone(WorkbookImpl targetWorkbook, Object source, CloneData data) {
        if (source instanceof IAdaptable) {
            if (source instanceof IWorkbookComponent) {
                Node sourceNode = (Node)((IAdaptable)source).getAdapter(Node.class);
                if (sourceNode != null) {
                    return WorkbookUtilsImpl.cloneWorkbookComponent(targetWorkbook, sourceNode, (IWorkbookComponent)source, data);
                }
            } else if (source instanceof IMarker) {
                IMarker sourceMarker = (IMarker)source;
                return WorkbookUtilsImpl.cloneMarker(targetWorkbook, (MarkerSheetImpl)targetWorkbook.getMarkerSheet(), sourceMarker.getId(), sourceMarker, sourceMarker.getOwnedSheet(), data);
            }
        }
        return null;
    }

    private static Object cloneWorkbookComponent(WorkbookImpl targetWorkbook, Node sourceEle, IWorkbookComponent source, CloneData data) {
        Document doc = targetWorkbook.getImplementation();
        Node clonedEle = WorkbookUtilsImpl.clone(doc, sourceEle);
        if (clonedEle instanceof Element) {
            WorkbookUtilsImpl.replaceAttributes(targetWorkbook, (Element)clonedEle, source.getOwnedWorkbook(), data);
        }
        return targetWorkbook.getAdaptable(clonedEle);
    }

    private static Node clone(Document doc, Node source) {
        if (source.getOwnerDocument() == doc) {
            return source.cloneNode(true);
        }
        return doc.importNode(source, true);
    }

    private static void replaceAttributes(WorkbookImpl targetWorkbook, Element ele, IWorkbook sourceWorkbook, CloneData data) {
        if (ele.hasAttribute("id")) {
            WorkbookUtilsImpl.replaceId(ele, data);
        }
        Iterator<Element> it = DOMUtils.childElementIter(ele);
        while (it.hasNext()) {
            WorkbookUtilsImpl.replaceAttributes(targetWorkbook, it.next(), sourceWorkbook, data);
        }
        String tag = ele.getTagName();
        if ("summary".equals(tag)) {
            WorkbookUtilsImpl.replaceTopicRef(ele, "topic-id", data);
        } else if ("relationship".equals(tag)) {
            WorkbookUtilsImpl.replaceTopicRef(ele, "end1", data);
            WorkbookUtilsImpl.replaceTopicRef(ele, "end2", data);
        } else if ("topic".equals(tag)) {
            WorkbookUtilsImpl.replaceTopicHyperlink(targetWorkbook, ele, sourceWorkbook, data);
        } else if ("marker-ref".equals(tag)) {
            WorkbookUtilsImpl.replaceMarkerRef(targetWorkbook, ele, sourceWorkbook, data);
        } else if ("xhtml:img".equals(tag)) {
            WorkbookUtilsImpl.replaceImageUrl(targetWorkbook, ele, sourceWorkbook, data);
        } else if ("resource-ref".equals(tag)) {
            WorkbookUtilsImpl.replaceResourceId(targetWorkbook, ele, sourceWorkbook, data);
        }
        if (ele.hasAttribute("style-id")) {
            WorkbookUtilsImpl.replaceStyle(targetWorkbook, ele, "style-id", sourceWorkbook, data);
        }
        if (ele.hasAttribute("theme")) {
            WorkbookUtilsImpl.replaceStyle(targetWorkbook, ele, "theme", sourceWorkbook, data);
        }
    }

    private static void replaceResourceId(WorkbookImpl targetWorkbook, Element ele, IWorkbook sourceWorkbook, CloneData data) {
        String sourceEntryPath;
        String type = DOMUtils.getAttribute(ele, "type");
        if ("file-entry".equals(type) && (sourceEntryPath = DOMUtils.getAttribute(ele, "resource-id")) != null) {
            try {
                String targetEntryPath = InternalHyperlinkUtils.importAttachment(sourceEntryPath, sourceWorkbook, targetWorkbook);
                DOMUtils.setAttribute(ele, "resource-id", targetEntryPath);
            }
            catch (IOException iOException) {}
        }
    }

    private static void replaceId(Element ele, CloneData data) {
        String oldId = DOMUtils.getAttribute(ele, "id");
        String newId = Core.getIdFactory().createId();
        DOMUtils.replaceId(ele, newId);
        if (oldId != null && data.get(oldId) == null) {
            data.put(oldId, newId);
        }
    }

    private static void replaceTopicRef(final Element e, final String attrName, final CloneData data) {
        String oldRefId = DOMUtils.getAttribute(e, attrName);
        if (oldRefId == null) {
            return;
        }
        String newRefId = data.getString(oldRefId);
        if (newRefId == null) {
            data.addCloneDataListener(oldRefId, new ICloneDataListener(){

                public void objectCloned(Object source, Object cloned) {
                    DOMUtils.setAttribute(e, attrName, (String)cloned);
                    data.removeCloneDataListener(source, this);
                }
            });
        } else {
            DOMUtils.setAttribute(e, attrName, newRefId);
        }
    }

    private static void replaceStyle(WorkbookImpl targetWorkbook, Element styledEle, String styleTag, IWorkbook sourceWorkbook, CloneData data) {
        IStyle targetStyle;
        String targetStyleId;
        String sourceStyleId;
        String styleId = styledEle.getAttribute(styleTag);
        IStyle sourceStyle = sourceWorkbook.getStyleSheet().findStyle(styleId);
        String string = sourceStyleId = sourceStyle == null ? null : sourceStyle.getId();
        if (sourceStyle != null) {
            WorkbookUtilsImpl.cloneStyle((StyleSheetImpl)targetWorkbook.getStyleSheet(), (StyleImpl)sourceStyle, (StyleSheetImpl)sourceWorkbook.getStyleSheet(), data);
        }
        String string2 = targetStyleId = (targetStyle = (IStyle)data.get(sourceStyle)) == null ? null : targetStyle.getId();
        if (targetStyleId == null) {
            styledEle.removeAttribute(styleTag);
        } else {
            styledEle.setAttribute(styleTag, targetStyle.getId());
        }
        data.put(sourceStyleId, targetStyleId);
    }

    private static String cloneUrl(WorkbookImpl targetWorkbook, String sourceUrl, IWorkbook sourceWorkbook, CloneData data) {
        String clonedUrl = data.getString(sourceUrl);
        if (clonedUrl != null || data.isCloned(sourceUrl)) {
            return clonedUrl;
        }
        if (HyperlinkUtils.isAttachmentURL(sourceUrl)) {
            try {
                clonedUrl = InternalHyperlinkUtils.importAttachmentURL(sourceUrl, sourceWorkbook, targetWorkbook);
            }
            catch (IOException iOException) {}
        } else {
            clonedUrl = sourceUrl;
        }
        data.put(sourceUrl, clonedUrl);
        return clonedUrl;
    }

    private static void replaceTopicHyperlink(WorkbookImpl targetWorkbook, Element topicEle, IWorkbook sourceWorkbook, CloneData data) {
        String oldUrl = DOMUtils.getAttribute(topicEle, "xlink:href");
        if (oldUrl != null) {
            String newUrl = WorkbookUtilsImpl.cloneUrl(targetWorkbook, oldUrl, sourceWorkbook, data);
            DOMUtils.setAttribute(topicEle, "xlink:href", newUrl);
        }
    }

    private static void replaceImageUrl(WorkbookImpl targetWorkbook, Element imgEle, IWorkbook sourceWorkbook, CloneData data) {
        String oldUrl = DOMUtils.getAttribute(imgEle, "xhtml:src");
        if (oldUrl != null) {
            String newUrl = WorkbookUtilsImpl.cloneUrl(targetWorkbook, oldUrl, sourceWorkbook, data);
            DOMUtils.setAttribute(imgEle, "xhtml:src", newUrl);
        }
    }

    private static void replaceMarkerRef(WorkbookImpl targetWorkbook, Element ele, IWorkbook sourceWorkbook, CloneData data) {
        String oldMarkerId = DOMUtils.getAttribute(ele, "marker-id");
        if (oldMarkerId != null) {
            String newMarkerId = WorkbookUtilsImpl.cloneMarkerId(targetWorkbook, oldMarkerId, sourceWorkbook, data);
            DOMUtils.setAttribute(ele, "marker-id", newMarkerId);
        }
    }

    private static String cloneMarkerId(WorkbookImpl targetWorkbook, String sourceMarkerId, IWorkbook sourceWorkbook, CloneData data) {
        IMarker clonedMarker;
        MarkerSheetImpl targetMarkerSheet;
        IMarker existingMarker;
        String clonedMarkerId = data.getString(sourceMarkerId);
        if (clonedMarkerId != null || data.isCloned(sourceMarkerId)) {
            return clonedMarkerId;
        }
        IMarkerSheet sourceMarkerSheet = sourceWorkbook.getMarkerSheet();
        IMarker sourceMarker = sourceMarkerSheet.findMarker(sourceMarkerId);
        if (sourceMarker != null && (existingMarker = (targetMarkerSheet = (MarkerSheetImpl)targetWorkbook.getMarkerSheet()).findMarker(sourceMarkerId)) == null && (clonedMarker = WorkbookUtilsImpl.cloneMarker(targetWorkbook, targetMarkerSheet, sourceMarkerId, sourceMarker, sourceMarkerSheet, data)) != null) {
            clonedMarkerId = clonedMarker.getId();
        }
        if (clonedMarkerId == null) {
            clonedMarkerId = sourceMarkerId;
        }
        data.put(sourceMarkerId, clonedMarkerId);
        return clonedMarkerId;
    }

    private static IMarker cloneMarker(WorkbookImpl targetWorkbook, MarkerSheetImpl targetMarkerSheet, String sourceMarkerId, IMarker sourceMarker, IMarkerSheet sourceMarkerSheet, CloneData data) {
        String sourceGroupId;
        String clonedGroupId;
        IMarkerGroup sourceGroup;
        if (!sourceMarkerSheet.isPermanent() && (sourceGroup = sourceMarker.getParent()) != null && (clonedGroupId = data.getString(sourceGroupId = sourceGroup.getId())) == null && !data.isCloned(sourceGroupId)) {
            IMarkerGroup targetGroup = targetMarkerSheet.findMarkerGroup(sourceGroupId);
            if (targetGroup != null && targetMarkerSheet.equals(targetGroup.getOwnedSheet())) {
                data.put(sourceGroupId, sourceGroupId);
            } else {
                WorkbookUtilsImpl.cloneMarkerGroup(targetWorkbook, targetMarkerSheet, sourceMarker, sourceGroup, sourceMarkerSheet, data);
            }
            String clonedMarkerId = data.getString(sourceMarkerId);
            if (clonedMarkerId != null) {
                return targetMarkerSheet.findMarker(clonedMarkerId);
            }
            IMarker iMarker = targetMarkerSheet.findMarker(sourceMarkerId);
        }
        return sourceMarker;
    }

    private static void cloneMarkerGroup(WorkbookImpl targetWorkbook, MarkerSheetImpl targetMarkerSheet, IMarker sourceMarker, IMarkerGroup sourceGroup, IMarkerSheet sourceMarkerSheet, CloneData data) {
        MarkerGroupImpl targetGroup;
        IMarkerGroup existingGroup = targetMarkerSheet.findMarkerGroup(sourceGroup.getId());
        if (existingGroup != null && targetMarkerSheet.equals(existingGroup.getOwnedSheet())) {
            targetGroup = (MarkerGroupImpl)existingGroup;
        } else {
            Node sourceGroupNode = (Node)sourceGroup.getAdapter(Node.class);
            if (sourceGroupNode != null) {
                Node clonedGroupNode = targetMarkerSheet.getImplementation().importNode(sourceGroupNode, true);
                WorkbookUtilsImpl.replaceMarkerPath(targetWorkbook, targetMarkerSheet, clonedGroupNode, data);
                MarkerGroupImpl clonedGroup = (MarkerGroupImpl)targetMarkerSheet.getElementAdapter(clonedGroupNode);
                WorkbookUtilsImpl.transferMarkerResources(targetWorkbook, targetMarkerSheet, clonedGroup, sourceGroup, sourceMarkerSheet, data);
                targetGroup = clonedGroup;
            } else {
                targetGroup = (MarkerGroupImpl)targetMarkerSheet.createMarkerGroup(sourceGroup.isSingleton());
                WorkbookUtilsImpl.cloneMarkerGroup(targetWorkbook, targetMarkerSheet, targetGroup, sourceGroup, sourceMarkerSheet, data);
            }
        }
        data.put(sourceGroup.getId(), targetGroup.getId());
    }

    private static void transferMarkerResources(WorkbookImpl targetWorkbook, MarkerSheetImpl targetMarkerSheet, MarkerGroupImpl targetGroup, IMarkerGroup sourceGroup, IMarkerSheet sourceMarkerSheet, CloneData data) {
        for (IMarker targetMarker : targetGroup.getMarkers()) {
            String markerId = targetMarker.getId();
            IMarker sourceMarker = sourceMarkerSheet.findMarker(markerId);
            if (sourceMarker != null) {
                WorkbookUtilsImpl.transferMarkerResource(targetWorkbook, sourceMarker, targetMarker);
            }
            data.put(markerId, markerId);
        }
    }

    private static void cloneMarkerGroup(WorkbookImpl targetWorkbook, MarkerSheetImpl targetMarkerSheet, MarkerGroupImpl targetGroup, IMarkerGroup sourceGroup, IMarkerSheet sourceMarkerSheet, CloneData data) {
        for (IMarker sourceMarker : sourceGroup.getMarkers()) {
            IMarker clonedMarker;
            String sourceMarkerId = sourceMarker.getId();
            IMarker existingMarker = targetMarkerSheet.findMarker(sourceMarkerId);
            if (existingMarker != null && targetMarkerSheet.equals(existingMarker.getOwnedSheet())) {
                clonedMarker = existingMarker;
            } else {
                clonedMarker = WorkbookUtilsImpl.cloneMarker(targetWorkbook, targetMarkerSheet, sourceMarkerSheet, sourceMarker, data);
                targetGroup.addMarker(clonedMarker);
            }
            data.put(sourceMarkerId, clonedMarker.getId());
        }
    }

    private static IMarker cloneMarker(WorkbookImpl targetWorkbook, MarkerSheetImpl targetMarkerSheet, IMarkerSheet sourceMarkerSheet, IMarker sourceMarker, CloneData data) {
        IMarker clonedMarker;
        Node sourceMarkerNode = (Node)sourceMarker.getAdapter(Node.class);
        if (sourceMarkerNode != null) {
            Node clonedMarkerNode = targetMarkerSheet.getImplementation().importNode(sourceMarkerNode, true);
            WorkbookUtilsImpl.replaceMarkerPath(targetWorkbook, targetMarkerSheet, clonedMarkerNode, data);
            clonedMarker = (IMarker)targetMarkerSheet.getElementAdapter(clonedMarkerNode);
        } else {
            clonedMarker = WorkbookUtilsImpl.createSimilarMarker(targetWorkbook, targetMarkerSheet, sourceMarker, sourceMarkerSheet, data);
        }
        WorkbookUtilsImpl.transferMarkerResource(targetWorkbook, sourceMarker, clonedMarker);
        return clonedMarker;
    }

    private static void transferMarkerResource(WorkbookImpl targetWorkbook, IMarker sourceMarker, IMarker targetMarker) {
        InputStream in;
        IMarkerResource sourceResource = sourceMarker.getResource();
        if (sourceResource != null && (in = sourceResource.getInputStream()) != null) {
            String targetPath = "markers/" + targetMarker.getResourcePath();
            IFileEntry entry = targetWorkbook.getManifest().createFileEntry(targetPath);
            OutputStream out = entry.getOutputStream();
            if (out != null) {
                try {
                    FileUtils.transfer(in, out, true);
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void replaceMarkerPath(WorkbookImpl targetWorkbook, MarkerSheetImpl targetMarkerSheet, Node node, CloneData data) {
        if (node instanceof Element) {
            Element ele = (Element)node;
            if ("marker".equals(ele.getTagName())) {
                String clonedPath = WorkbookUtilsImpl.createNewMarkerPath(ele.getAttribute("resource"));
                ele.setAttribute("resource", clonedPath);
            }
            Iterator<Element> it = DOMUtils.childElementIter(ele);
            while (it.hasNext()) {
                WorkbookUtilsImpl.replaceMarkerPath(targetWorkbook, targetMarkerSheet, it.next(), data);
            }
        }
    }

    private static String createNewMarkerPath(String sourcePath) {
        String clonedPath = String.valueOf(Core.getIdFactory().createId()) + FileUtils.getExtension(sourcePath);
        return clonedPath;
    }

    private static MarkerImpl createSimilarMarker(WorkbookImpl targetWorkbook, MarkerSheetImpl targetMarkerSheet, IMarker sourceMarker, IMarkerSheet sourceMarkerSheet, CloneData data) {
        MarkerImpl newMarker = (MarkerImpl)targetMarkerSheet.createMarker(WorkbookUtilsImpl.createNewMarkerPath(sourceMarker.getResourcePath()));
        newMarker.setName(sourceMarker.getName());
        return newMarker;
    }

    public static void increaseStyleRef(WorkbookImpl workbook, IStyled styled) {
        if (workbook == null || styled == null) {
            return;
        }
        String styleId = styled.getStyleId();
        if (styleId == null) {
            return;
        }
        workbook.getStyleRefCounter().increaseRef(styleId);
    }

    public static void decreaseStyleRef(WorkbookImpl workbook, IStyled styled) {
        if (workbook == null || styled == null) {
            return;
        }
        String styleId = styled.getStyleId();
        if (styleId == null) {
            return;
        }
        workbook.getStyleRefCounter().decreaseRef(styleId);
    }

    public static IStyle importStyle(StyleSheetImpl targetSheet, StyleImpl sourceStyle, StyleSheetImpl sourceSheet) {
        return WorkbookUtilsImpl.importStyle(targetSheet, sourceStyle, sourceSheet, new CloneData((Collection<? extends Object>)Arrays.asList(sourceStyle), null));
    }

    public static IStyle importStyle(StyleSheetImpl targetSheet, StyleImpl sourceStyle, StyleSheetImpl sourceSheet, CloneData data) {
        StyleProperties sourceProp;
        if (sourceSheet != null && sourceSheet.equals(targetSheet)) {
            return sourceStyle;
        }
        IStyle targetStyle = targetSheet.findStyle(sourceStyle.getId());
        if (targetStyle != null) {
            return targetStyle;
        }
        if (sourceSheet == null) {
            return WorkbookUtilsImpl.importNoParentStyle(targetSheet, sourceStyle);
        }
        if (data == null) {
            data = new CloneData((Collection<? extends Object>)Arrays.asList(sourceStyle), null);
        }
        if ((sourceProp = WorkbookUtilsImpl.getStyleProperties(sourceStyle, data)).isEmpty()) {
            return null;
        }
        String sourceGroup = sourceSheet.findOwnedGroup(sourceStyle);
        targetStyle = WorkbookUtilsImpl.findSimilarStyle(targetSheet, sourceGroup, sourceProp, data);
        if (targetStyle != null) {
            return targetStyle;
        }
        WorkbookUtilsImpl.cloneStyle(targetSheet, sourceStyle, sourceSheet, data);
        targetStyle = (IStyle)data.get(sourceStyle);
        if (targetStyle != null && sourceGroup != null) {
            targetSheet.addStyle(targetStyle, sourceGroup);
        }
        return targetStyle;
    }

    private static IStyle findSimilarStyle(StyleSheetImpl targetSheet, String group, StyleProperties sourceProp, CloneData data) {
        Set<IStyle> styles = group == null ? targetSheet.getAllStyles() : targetSheet.getStyles(group);
        for (IStyle style : styles) {
            if (!sourceProp.equals(WorkbookUtilsImpl.getStyleProperties(style, data))) continue;
            return style;
        }
        return null;
    }

    private static StyleProperties getStyleProperties(IStyle style, CloneData data) {
        StyleProperties prop = (StyleProperties)data.getCache(style);
        if (prop == null) {
            prop = new StyleProperties(style, data);
        }
        return prop;
    }

    private static void cloneStyle(StyleSheetImpl targetSheet, StyleImpl sourceStyle, StyleSheetImpl sourceSheet, CloneData data) {
        Element sourceEle = sourceStyle.getImplementation();
        Node targetEle = WorkbookUtilsImpl.clone(targetSheet.getImplementation(), sourceEle);
        if (targetEle instanceof Element) {
            WorkbookUtilsImpl.replaceStyleProperties(targetSheet, (Element)targetEle, sourceEle, sourceStyle, sourceSheet, data);
        }
        IStyle targetStyle = (IStyle)targetSheet.getNodeAdaptable(targetEle);
        data.put(sourceStyle, targetStyle);
    }

    private static void replaceStyleProperties(StyleSheetImpl targetSheet, Element targetEle, Element sourceEle, StyleImpl sourceStyle, StyleSheetImpl sourceSheet, CloneData data) {
        String type = targetEle.getAttribute("type").toLowerCase();
        String propTagName = String.valueOf(type) + "-" + "properties";
        Iterator<Element> targetPropIt = DOMUtils.childElementIterByTag(targetEle, propTagName);
        while (targetPropIt.hasNext()) {
            Element targetPropEle = targetPropIt.next();
            NamedNodeMap attrs = targetPropEle.getAttributes();
            int i = 0;
            while (i < attrs.getLength()) {
                Node attr = attrs.item(i);
                String value = attr.getNodeValue();
                if (HyperlinkUtils.isAttachmentURL(value)) {
                    String newValue = WorkbookUtilsImpl.cloneAttachment(value, sourceSheet.getManifest(), targetSheet.getManifest(), data);
                    attr.setNodeValue(newValue);
                }
                ++i;
            }
            Iterator<Element> targetDSIt = DOMUtils.childElementIterByTag(targetPropEle, "default-style");
            while (targetDSIt.hasNext()) {
                IStyle targetDS;
                String dsId;
                IStyle sourceDS;
                Element targetDSEle = targetDSIt.next();
                String family = DOMUtils.getAttribute(targetDSEle, "style-family");
                if (family == null || (sourceDS = sourceStyle.getDefaultStyleById(dsId = DOMUtils.getAttribute(targetDSEle, "style-id"))) == null || (targetDS = WorkbookUtilsImpl.importStyle(targetSheet, (StyleImpl)sourceDS, sourceSheet, data)) == null) continue;
                DOMUtils.setAttribute(targetDSEle, "style-id", targetDS.getId());
            }
        }
    }

    private static String cloneAttachment(String sourceURL, IManifest sourceManifest, IManifest targetManifest, CloneData data) {
        IFileEntry targetEntry;
        String targetURL;
        block21: {
            targetURL = (String)data.get(sourceURL);
            if (targetURL != null) {
                return targetURL;
            }
            if (sourceManifest == null || targetManifest == null) {
                return (String)WorkbookUtilsImpl.cache(data, sourceURL, sourceURL);
            }
            IFileEntry sourceEntry = sourceManifest.getFileEntry(HyperlinkUtils.toAttachmentPath(sourceURL));
            if (sourceEntry == null) {
                return (String)WorkbookUtilsImpl.cache(data, sourceURL, sourceURL);
            }
            String newPath = String.valueOf(Core.getIdFactory().createId()) + FileUtils.getExtension(sourceEntry.getPath());
            targetEntry = targetManifest.createFileEntry(targetManifest.makeAttachmentPath(newPath), sourceEntry.getMediaType());
            InputStream is = sourceEntry.getInputStream();
            OutputStream os = targetEntry.getOutputStream();
            if (is != null && os != null) {
                try {
                    try {
                        FileUtils.transfer(is, os, true);
                    }
                    catch (IOException iOException) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException2) {}
                        try {
                            os.close();
                        }
                        catch (IOException iOException3) {}
                        break block21;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                    try {
                        os.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    is.close();
                }
                catch (IOException iOException) {}
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
        targetURL = HyperlinkUtils.toAttachmentURL(targetEntry.getPath());
        return (String)WorkbookUtilsImpl.cache(data, sourceURL, targetURL);
    }

    private static Object cache(CloneData data, Object source, Object target) {
        data.cache(source, target);
        return target;
    }

    private static IStyle importNoParentStyle(StyleSheetImpl targetSheet, StyleImpl sourceStyle) {
        Element sourceEle = sourceStyle.getImplementation();
        Node targetEle = WorkbookUtilsImpl.clone(targetSheet.getImplementation(), sourceEle);
        return (IStyle)targetSheet.getNodeAdaptable(targetEle);
    }

    private static class StyleProperties {
        Map<String, String> properties = new HashMap<String, String>();
        Map<String, StyleProperties> defaultStyles = new HashMap<String, StyleProperties>();

        public StyleProperties(IStyle style, CloneData data) {
            Iterator<Property> propIt = style.properties();
            while (propIt.hasNext()) {
                Property next = propIt.next();
                this.properties.put(next.key, next.value);
            }
            Iterator<Property> dsIt = style.defaultStyles();
            while (dsIt.hasNext()) {
                Property next = dsIt.next();
                String family = next.key;
                IStyle ds = style.getDefaultStyleById(next.value);
                StyleProperties dsProp = (StyleProperties)data.getCache(ds);
                if (dsProp == null) {
                    dsProp = new StyleProperties(ds, data);
                }
                this.defaultStyles.put(family, dsProp);
            }
            data.cache(style, this);
        }

        public boolean isEmpty() {
            return this.properties.isEmpty() && this.defaultStyles.isEmpty();
        }

        public int hashCode() {
            return this.properties.hashCode() ^ this.defaultStyles.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !(obj instanceof StyleProperties)) {
                return false;
            }
            StyleProperties that = (StyleProperties)obj;
            return this.properties.equals(that.properties) && this.defaultStyles.equals(that.defaultStyles);
        }
    }
}

