/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.io.InputStream;
import java.io.OutputStream;
import org.xmind.core.Core;
import org.xmind.core.CoreException;
import org.xmind.core.internal.dom.WorkbookImpl;
import org.xmind.core.io.IInputSource;
import org.xmind.core.io.IStorage;
import org.xmind.core.marker.AbstractMarkerResource;
import org.xmind.core.marker.IMarker;

public class WorkbookMarkerResource
extends AbstractMarkerResource {
    private WorkbookImpl workbook;

    public WorkbookMarkerResource(WorkbookImpl workbook, IMarker marker) {
        super(marker, "markers/");
        this.workbook = workbook;
    }

    public InputStream getInputStream() {
        try {
            IStorage storage = this.getStorage();
            IInputSource inputSource = storage.getInputSource();
            String fullPath = this.getFullPath();
            InputStream entryStream = inputSource.getEntryStream(fullPath);
            return entryStream;
        }
        catch (CoreException e) {
            Core.getLogger().log(e);
            return null;
        }
    }

    public OutputStream getOutputStream() {
        try {
            return this.getStorage().getOutputTarget().getEntryStream(this.getFullPath());
        }
        catch (CoreException e) {
            Core.getLogger().log(e);
            return null;
        }
    }

    private IStorage getStorage() {
        return this.workbook.getTempStorage();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof WorkbookMarkerResource)) {
            return false;
        }
        WorkbookMarkerResource that = (WorkbookMarkerResource)obj;
        return this.workbook.equals(that.workbook) && super.equals(obj);
    }
}

