/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import org.xmind.core.IFileEntry;
import org.xmind.core.internal.AbstractRefCounter;
import org.xmind.core.internal.dom.ManifestImpl;
import org.xmind.core.internal.dom.MarkerSheetImpl;
import org.xmind.core.internal.dom.WorkbookMarkerResource;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerGroup;
import org.xmind.core.marker.IMarkerResource;
import org.xmind.core.marker.IMarkerSheet;
import org.xmind.core.util.FileUtils;
import org.xmind.core.util.IMarkerRefCounter;

public class WorkbookMarkerRefCounter
extends AbstractRefCounter
implements IMarkerRefCounter {
    private MarkerSheetImpl sheet;
    private ManifestImpl manifest;

    WorkbookMarkerRefCounter(MarkerSheetImpl sheet, ManifestImpl manifest) {
        this.sheet = sheet;
        this.manifest = manifest;
    }

    protected Object findResource(String resourceId) {
        return this.sheet.findMarker(resourceId);
    }

    protected void postIncreaseRef(String resourceId, Object resource) {
        IMarkerGroup group;
        IMarker marker = (IMarker)resource;
        if (this.sheet.equals(marker.getOwnedSheet()) && (group = marker.getParent()) != null) {
            IFileEntry sheetEntry;
            if (group.getParent() == null) {
                this.sheet.addMarkerGroup(group);
                for (IMarker m : group.getMarkers()) {
                    IMarkerResource res = m.getResource();
                    if (!(res instanceof WorkbookMarkerResource)) continue;
                    String fullPath = ((WorkbookMarkerResource)res).getFullPath();
                    IFileEntry e = this.manifest.getFileEntry(fullPath);
                    if (e == null) {
                        e = this.manifest.createFileEntry(fullPath, FileUtils.getMediaType(fullPath));
                    }
                    e.increaseReference();
                }
            }
            if ((sheetEntry = this.manifest.getFileEntry("markers/markerSheet.xml")) == null) {
                sheetEntry = this.manifest.createFileEntry("markers/markerSheet.xml");
            }
            sheetEntry.increaseReference();
        }
    }

    protected void postDecreaseRef(String resourceId, Object resource) {
        IMarker marker = (IMarker)resource;
        if (this.sheet.equals(marker.getOwnedSheet())) {
            IFileEntry entry;
            IMarkerSheet parent;
            IMarkerGroup group = marker.getParent();
            if (group != null && this.sheet.equals(parent = group.getParent()) && !this.isGroupReferenced(group)) {
                parent.removeMarkerGroup(group);
                for (IMarker m : group.getMarkers()) {
                    String fullPath;
                    IFileEntry e;
                    IMarkerResource res = m.getResource();
                    if (!(res instanceof WorkbookMarkerResource) || (e = this.manifest.getFileEntry(fullPath = ((WorkbookMarkerResource)res).getFullPath())) == null) continue;
                    e.decreaseReference();
                }
            }
            if (this.sheet.isEmpty() && (entry = this.manifest.getFileEntry("markers/markerSheet.xml")) != null) {
                entry.decreaseReference();
            }
        }
    }

    private boolean isGroupReferenced(IMarkerGroup group) {
        for (IMarker marker : group.getMarkers()) {
            int c = this.getRefCount(marker.getId());
            if (c <= 0) continue;
            return true;
        }
        return false;
    }
}

