/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;
import org.xmind.core.Core;
import org.xmind.core.CoreException;
import org.xmind.core.IChecksumStream;
import org.xmind.core.IEncryptionData;
import org.xmind.core.IEncryptionHandler;
import org.xmind.core.IFileEntry;
import org.xmind.core.IManifest;
import org.xmind.core.ISheet;
import org.xmind.core.IWorkbook;
import org.xmind.core.internal.compatibility.Compatibility;
import org.xmind.core.internal.dom.ManifestImpl;
import org.xmind.core.internal.dom.MarkerSheetBuilderImpl;
import org.xmind.core.internal.dom.MarkerSheetImpl;
import org.xmind.core.internal.dom.MetaImpl;
import org.xmind.core.internal.dom.SheetImpl;
import org.xmind.core.internal.dom.StyleSheetBuilderImpl;
import org.xmind.core.internal.dom.StyleSheetImpl;
import org.xmind.core.internal.dom.WorkbookBuilderImpl;
import org.xmind.core.internal.dom.WorkbookImpl;
import org.xmind.core.internal.dom.WorkbookMarkerResourceProvider;
import org.xmind.core.internal.dom.XMLLoader;
import org.xmind.core.internal.security.Crypto;
import org.xmind.core.io.IInputSource;
import org.xmind.core.io.IOutputTarget;
import org.xmind.core.io.IStorage;
import org.xmind.core.marker.IMarkerSheet;
import org.xmind.core.style.IStyleSheet;
import org.xmind.core.util.FileUtils;

public class WorkbookLoader
extends XMLLoader {
    private WorkbookBuilderImpl builder;
    private IInputSource source;
    private IStorage storage;
    private IEncryptionHandler encryptionHandler;
    private WorkbookImpl workbook;
    private Set<String> loadedEntries;
    private ManifestImpl manifest;
    private boolean ignoreCopy;
    private String password;

    public WorkbookLoader(WorkbookBuilderImpl builder, IInputSource source, IStorage storage, IEncryptionHandler encryptionHandler) throws CoreException {
        this.builder = builder;
        if (source == null && storage != null) {
            source = storage.getInputSource();
            this.ignoreCopy = true;
        } else {
            this.ignoreCopy = false;
        }
        this.source = source;
        this.storage = storage;
        this.encryptionHandler = encryptionHandler;
    }

    public IWorkbook load() throws IOException, CoreException {
        this.loadedEntries = null;
        this.password = null;
        this.manifest = null;
        try {
            this.doLoad();
        }
        finally {
            this.manifest = null;
            this.password = null;
            this.loadedEntries = null;
        }
        return this.workbook;
    }

    private void doLoad() throws IOException, CoreException {
        this.loadManifest();
        if (this.loadOldFormat()) {
            return;
        }
        this.loadContents();
        this.loadMeta();
        this.loadStyleSheet();
        this.loadMarkerSheet();
        this.copyOtherStaff();
        this.initWorkbook();
        this.clearEncryptionData();
    }

    private void loadManifest() throws IOException, CoreException {
        Document doc = this.forceLoadXML("META-INF/manifest.xml");
        this.manifest = new ManifestImpl(doc);
    }

    private boolean loadOldFormat() throws IOException, CoreException {
        IWorkbook compatible = Compatibility.loadCompatibleWorkbook(this.source, this);
        if (compatible != null) {
            this.workbook = (WorkbookImpl)compatible;
            return true;
        }
        return false;
    }

    private void loadContents() throws IOException, CoreException {
        Document doc = this.loadXMLFile(this.source, "content.xml");
        this.workbook = new WorkbookImpl(doc);
        this.workbook.setManifest(this.manifest);
    }

    private void loadMeta() throws IOException, CoreException {
        Document doc = this.forceLoadXML("meta.xml");
        this.workbook.setMeta(new MetaImpl(doc));
    }

    private void loadStyleSheet() throws IOException, CoreException {
        block3: {
            try {
                IStyleSheet styleSheet = ((StyleSheetBuilderImpl)Core.getStyleSheetBuilder()).loadFromInputSource(this.source, this);
                this.workbook.setStyleSheet((StyleSheetImpl)styleSheet);
            }
            catch (IOException e) {
                throw e;
            }
            catch (CoreException e) {
                if (e.getType() == 11) break block3;
                throw e;
            }
        }
    }

    private void loadMarkerSheet() throws IOException, CoreException {
        block3: {
            try {
                IMarkerSheet markerSheet = ((MarkerSheetBuilderImpl)Core.getMarkerSheetBuilder()).loadFromInputSource(this.source, this, new WorkbookMarkerResourceProvider(this.workbook));
                this.workbook.setMarkerSheet((MarkerSheetImpl)markerSheet);
            }
            catch (IOException e) {
                throw e;
            }
            catch (CoreException e) {
                if (e.getType() == 11) break block3;
                throw e;
            }
        }
    }

    private void copyOtherStaff() throws IOException, CoreException {
        if (this.ignoreCopy || this.source == null || this.storage == null) {
            return;
        }
        IOutputTarget target = this.storage.getOutputTarget();
        this.copyAll(this.source, target);
    }

    private void copyAll(IInputSource source, IOutputTarget target) throws CoreException {
        IManifest manifest = this.workbook.getManifest();
        for (IFileEntry entry : manifest.getFileEntries()) {
            String entryPath;
            if (entry.isDirectory() || (entryPath = entry.getPath()) == null || "".equals(entryPath) || this.hasBeenLoaded(entryPath)) continue;
            this.copyEntry(source, target, entryPath);
            this.markLoaded(entryPath);
        }
    }

    private void copyEntry(IInputSource source, IOutputTarget target, String entryPath) throws CoreException {
        try {
            OutputStream out;
            InputStream in = this.getInputStream(source, entryPath);
            if (in != null && (out = this.getOutputStream(target, entryPath)) != null) {
                try {
                    FileUtils.transfer(in, out, true);
                }
                finally {
                    Exception e2;
                    long time = source.getEntryTime(entryPath);
                    if (time >= 0L) {
                        target.setEntryTime(entryPath, time);
                    }
                    if ((e2 = this.checkChecksum(source, entryPath, in, null)) instanceof CoreException) {
                        throw (CoreException)e2;
                    }
                }
            }
        }
        catch (IOException e) {
            Core.getLogger().log(e);
        }
        catch (CoreException e) {
            if (e.getType() == 17 || e.getType() == 100) {
                throw e;
            }
            Core.getLogger().log(e);
        }
    }

    private OutputStream getOutputStream(IOutputTarget target, String entryPath) {
        if (!target.isEntryAvaialble(entryPath)) {
            return null;
        }
        return target.getEntryStream(entryPath);
    }

    private void markLoaded(String entryPath) {
        if (this.loadedEntries == null) {
            this.loadedEntries = new HashSet<String>();
        }
        this.loadedEntries.add(entryPath);
    }

    private boolean hasBeenLoaded(String entryPath) {
        return this.loadedEntries != null && this.loadedEntries.contains(entryPath);
    }

    private void initWorkbook() throws IOException, CoreException {
        if (this.storage != null) {
            this.workbook.setTempStorage(this.storage);
        }
        this.initWorkbookContents(this.workbook);
        this.workbook.setPassword(this.password);
    }

    private void initWorkbookContents(IWorkbook workbook) {
        for (ISheet s : workbook.getSheets()) {
            this.initSheet(s, workbook);
        }
    }

    private void initSheet(ISheet s, IWorkbook wb) {
        ((SheetImpl)s).addNotify((WorkbookImpl)wb);
    }

    private void clearEncryptionData() {
        for (IFileEntry entry : this.manifest.getFileEntries()) {
            entry.deleteEncryptionData();
        }
    }

    private Document forceLoadXML(String entryPath) throws IOException, CoreException {
        try {
            return this.loadXMLFile(this.source, entryPath);
        }
        catch (Throwable e) {
            CoreException coreEx;
            if (e instanceof CoreException && (coreEx = (CoreException)e).getType() == 100) {
                throw coreEx;
            }
            Core.getLogger().log(e, "Faild to load " + entryPath);
            return this.createDocument();
        }
    }

    private InputStream getInputStream(IInputSource source, String entryPath) throws CoreException {
        IEncryptionData encData;
        if (!source.hasEntry(entryPath)) {
            return null;
        }
        InputStream in = source.getEntryStream(entryPath);
        if (in == null) {
            return null;
        }
        if (this.manifest != null && (encData = this.manifest.getEncryptionData(entryPath)) != null) {
            in = this.createDecryptedStream(in, encData);
        }
        return in;
    }

    private InputStream createDecryptedStream(InputStream in, IEncryptionData encData) throws CoreException {
        String password = this.getPassword();
        if (password == null) {
            throw new CoreException(100);
        }
        return Crypto.createInputStream(in, false, encData, password);
    }

    private String getPassword() throws CoreException {
        if (this.password == null && this.encryptionHandler != null) {
            this.password = this.encryptionHandler.retrievePassword();
        }
        return this.password;
    }

    protected Document doLoadXMLFile(IInputSource source, String entryPath) throws IOException, CoreException {
        try {
            Document doc;
            InputStream stream = this.getInputStream(source, entryPath);
            if (stream == null) {
                throw new CoreException(11, entryPath);
            }
            try {
                try {
                    DocumentBuilder loader = this.builder.getDocumentLoader();
                    doc = loader.parse(stream);
                }
                catch (Throwable e) {
                    Exception e2 = this.checkChecksum(source, entryPath, stream, new CoreException(13, e));
                    if (e2 instanceof IOException) {
                        throw (IOException)e2;
                    }
                    throw (CoreException)e2;
                }
            }
            finally {
                stream.close();
            }
            Exception ex = this.checkChecksum(source, entryPath, stream, null);
            if (ex instanceof CoreException) {
                throw (CoreException)ex;
            }
            Document document = doc;
            return document;
        }
        finally {
            this.markLoaded(entryPath);
        }
    }

    private Exception checkChecksum(IInputSource source, String entryName, InputStream stream, Throwable ex) {
        if (stream instanceof IChecksumStream) {
            String expectedChecksum;
            if (this.manifest == null) {
                throw new InternalError("Manifest should not be encrypted");
            }
            IEncryptionData encData = this.manifest.getEncryptionData(entryName);
            if (encData != null && (expectedChecksum = encData.getChecksum()) != null) {
                try {
                    String actualChecksum = ((IChecksumStream)((Object)stream)).getChecksum();
                    if (actualChecksum == null || !expectedChecksum.equals(actualChecksum)) {
                        if (ex == null) {
                            return new CoreException(17);
                        }
                        return new CoreException(17, ex);
                    }
                }
                catch (IOException iOException) {}
            }
        }
        if (ex == null) {
            return null;
        }
        if (ex instanceof IOException) {
            return (IOException)ex;
        }
        return new CoreException(13, ex);
    }

    public Document createDocument() {
        return this.builder.createDocument();
    }
}

