/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.xmind.core.Core;
import org.xmind.core.CoreException;
import org.xmind.core.IAdaptable;
import org.xmind.core.internal.dom.WorkbookImpl;
import org.xmind.core.io.ByteArrayStorage;
import org.xmind.core.io.IInputSource;
import org.xmind.core.io.IOutputTarget;
import org.xmind.core.io.IStorage;
import org.xmind.core.marker.IMarkerSheet;
import org.xmind.core.style.IStyleSheet;
import org.xmind.core.util.DOMUtils;
import org.xmind.core.util.FileUtils;

public class TempSaver {
    private WorkbookImpl workbook;
    private IStorage storage;
    private IStorage oldStorage;
    private Set<String> savedEntries;

    public TempSaver(WorkbookImpl workbook) {
        this.workbook = workbook;
    }

    public IStorage getStorage() {
        if (this.storage == null) {
            this.storage = new ByteArrayStorage();
        }
        return this.storage;
    }

    public void setStorage(IStorage storage) {
        if (storage == this.storage) {
            return;
        }
        if (this.oldStorage != null) {
            this.oldStorage = this.storage;
        }
        this.storage = storage;
    }

    public void save() throws IOException, CoreException {
        this.savedEntries = new HashSet<String>();
        try {
            this.saveAll();
        }
        finally {
            this.savedEntries = null;
            this.oldStorage = null;
        }
    }

    private void saveAll() throws IOException, CoreException {
        IStyleSheet styleSheet;
        IOutputTarget target = this.storage.getOutputTarget();
        this.saveDOM(this.workbook.getMeta(), target, "meta.xml");
        this.saveDOM(this.workbook, target, "content.xml");
        IMarkerSheet markerSheet = this.workbook.getMarkerSheet();
        if (!markerSheet.isEmpty()) {
            this.saveDOM(markerSheet, target, "markers/markerSheet.xml");
        }
        if (!(styleSheet = this.workbook.getStyleSheet()).isEmpty()) {
            this.saveDOM(styleSheet, target, "styles.xml");
        }
        if (this.oldStorage != null) {
            this.saveStorage(this.oldStorage, target);
        }
        this.saveDOM(this.workbook.getManifest(), target, "META-INF/manifest.xml");
    }

    private void saveStorage(IStorage sourceStorage, IOutputTarget target) throws CoreException, IOException {
        IInputSource source = this.storage.getInputSource();
        Iterator<String> entries = source.getEntries();
        while (entries.hasNext()) {
            String entryPath = entries.next();
            if (entryPath == null || "".equals(entryPath) || this.hasBeenSaved(entryPath)) continue;
            this.saveStorageEntry(source, target, entryPath);
            this.markSaved(entryPath);
        }
    }

    private void saveStorageEntry(IInputSource source, IOutputTarget target, String entryPath) {
        block7: {
            try {
                OutputStream out;
                InputStream in = this.getInputStream(source, entryPath);
                if (in == null || (out = this.getOutputStream(target, entryPath)) == null) break block7;
                try {
                    FileUtils.transfer(in, out, true);
                }
                finally {
                    long time = source.getEntryTime(entryPath);
                    if (time >= 0L) {
                        target.setEntryTime(entryPath, time);
                    }
                }
            }
            catch (IOException e) {
                Core.getLogger().log(e);
            }
            catch (CoreException e) {
                Core.getLogger().log(e);
            }
        }
    }

    private InputStream getInputStream(IInputSource source, String entryPath) throws CoreException {
        if (source.hasEntry(entryPath)) {
            return source.getEntryStream(entryPath);
        }
        return null;
    }

    private void saveDOM(IAdaptable domAdapter, IOutputTarget target, String entryPath) throws IOException, CoreException {
        OutputStream out = this.getOutputStream(target, entryPath);
        if (out != null) {
            try {
                DOMUtils.save(domAdapter, out, true);
            }
            finally {
                this.markSaved(entryPath);
            }
        }
    }

    private OutputStream getOutputStream(IOutputTarget target, String entryPath) throws IOException, CoreException {
        if (!target.isEntryAvaialble(entryPath)) {
            return null;
        }
        return target.getEntryStream(entryPath);
    }

    private boolean hasBeenSaved(String entryPath) {
        return this.savedEntries != null && this.savedEntries.contains(entryPath);
    }

    private void markSaved(String entryPath) {
        if (this.savedEntries == null) {
            this.savedEntries = new HashSet<String>();
        }
        this.savedEntries.add(entryPath);
    }
}

