/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xmind.core.Core;
import org.xmind.core.CoreException;
import org.xmind.core.internal.MarkerSheetBuilder;
import org.xmind.core.internal.dom.MarkerSheetImpl;
import org.xmind.core.io.IInputSource;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerGroup;
import org.xmind.core.marker.IMarkerResourceProvider;
import org.xmind.core.marker.IMarkerSheet;
import org.xmind.core.util.DOMUtils;
import org.xmind.core.util.IXMLLoader;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class MarkerSheetBuilderImpl
extends MarkerSheetBuilder
implements ErrorHandler {
    private DocumentBuilder documentCreator = null;
    private DocumentBuilder documentLoader = null;

    private DocumentBuilder getDocumentCreator() {
        if (this.documentCreator == null) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                this.documentCreator = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new IllegalStateException(e);
            }
        }
        return this.documentCreator;
    }

    private DocumentBuilder getDocumentLoader() throws CoreException {
        if (this.documentLoader == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setAttribute("http://apache.org/xml/features/continue-after-fatal-error", Boolean.TRUE);
            try {
                this.documentLoader = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new CoreException(12, (Throwable)e);
            }
            this.documentLoader.setErrorHandler(this);
        }
        return this.documentLoader;
    }

    public IMarkerSheet createMarkerSheet(IMarkerResourceProvider resourceProvider) {
        Document impl = this.createDocument();
        DOMUtils.createElement(impl, "marker-sheet");
        MarkerSheetImpl sheet = new MarkerSheetImpl(impl, resourceProvider);
        return sheet;
    }

    private Document createDocument() {
        return this.getDocumentCreator().newDocument();
    }

    public IMarkerSheet loadFromStream(InputStream stream, IMarkerResourceProvider resourceProvider) throws IOException, CoreException {
        DocumentBuilder loader = this.getDocumentLoader();
        Document doc = this.parse(loader, stream);
        return this.createMarkerSheet(doc, resourceProvider);
    }

    private IMarkerSheet createMarkerSheet(Document doc, IMarkerResourceProvider resourceProvider) {
        MarkerSheetImpl sheet = new MarkerSheetImpl(doc, resourceProvider);
        this.init(sheet);
        return sheet;
    }

    public IMarkerSheet loadFromInputSource(IInputSource source, IXMLLoader xmlLoader, IMarkerResourceProvider resourceProvider) throws IOException, CoreException {
        Document doc = xmlLoader.loadXMLFile(source, "markers/markerSheet.xml");
        return this.createMarkerSheet(doc, resourceProvider);
    }

    private void init(MarkerSheetImpl sheet) {
        for (IMarkerGroup group : sheet.getMarkerGroups()) {
            this.initGroup(group);
        }
    }

    private void initGroup(IMarkerGroup group) {
        for (IMarker marker : group.getMarkers()) {
            this.initMarker(marker);
        }
    }

    private void initMarker(IMarker marker) {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Document parse(DocumentBuilder loader, InputStream stream) throws IOException, CoreException {
        Document document;
        try {
            document = loader.parse(stream);
        }
        catch (SAXException e) {
            try {
                throw new CoreException(13, (Throwable)e);
                catch (IOException e2) {
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                try {
                    stream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            stream.close();
            return document;
        }
        catch (IOException iOException) {}
        return document;
    }

    public void error(SAXParseException exception) throws SAXException {
        Core.getLogger().log(exception);
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        Core.getLogger().log(exception);
    }

    public void warning(SAXParseException exception) throws SAXException {
        Core.getLogger().log(exception);
    }

    public void loadProperties(InputStream stream, IMarkerSheet sheet) throws IOException, CoreException {
        Properties p = new Properties();
        p.load(stream);
        ((MarkerSheetImpl)sheet).setProperties(p);
    }
}

