/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmind.core.Core;
import org.xmind.core.IEncryptionData;
import org.xmind.core.IFileEntry;
import org.xmind.core.IWorkbook;
import org.xmind.core.internal.Manifest;
import org.xmind.core.internal.dom.FileEntryImpl;
import org.xmind.core.internal.dom.InternalDOMUtils;
import org.xmind.core.internal.dom.NS;
import org.xmind.core.internal.dom.WorkbookImpl;
import org.xmind.core.util.DOMUtils;
import org.xmind.core.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManifestImpl
extends Manifest {
    private static final Collection<IFileEntry> NO_ENTRIES = Collections.emptyList();
    private static final Comparator<String> ENTRY_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return o1.compareToIgnoreCase(o2);
        }
    };
    private Document implementation;
    private WorkbookImpl ownedWorkbook;
    private Map<String, IFileEntry> entries = null;

    public ManifestImpl(Document implementation) {
        this.implementation = implementation;
        this.init();
    }

    protected void setWorkbook(WorkbookImpl workbook) {
        this.ownedWorkbook = workbook;
    }

    private void init() {
        Element m = DOMUtils.ensureChildElement(this.implementation, "manifest");
        NS.setNS(NS.Manifest, m, new NS[0]);
    }

    public Document getImplementation() {
        return this.implementation;
    }

    public Element getManifestElement() {
        return this.implementation.getDocumentElement();
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == Document.class || adapter == Node.class) {
            return this.implementation;
        }
        if (adapter == IWorkbook.class) {
            return this.ownedWorkbook;
        }
        return super.getAdapter(adapter);
    }

    @Override
    public IWorkbook getOwnedWorkbook() {
        return this.ownedWorkbook;
    }

    protected Collection<IFileEntry> getAllRegisteredEntries() {
        if (this.entries == null) {
            return NO_ENTRIES;
        }
        return this.entries.values();
    }

    @Override
    public List<IFileEntry> getFileEntries() {
        Element ms = this.getManifestElement();
        ArrayList<IFileEntry> list = new ArrayList<IFileEntry>(ms.getChildNodes().getLength());
        Iterator<Element> it = DOMUtils.childElementIterByTag(ms, "file-entry");
        while (it.hasNext()) {
            IFileEntry entry;
            Element e = it.next();
            if (!e.hasAttribute("full-path")) continue;
            String path = e.getAttribute("full-path");
            if (this.entries == null) {
                this.entries = new TreeMap<String, IFileEntry>(ENTRY_COMPARATOR);
            }
            if ((entry = this.entries.get(path)) == null) {
                entry = this.createFileEntry(path, e);
            }
            list.add(entry);
        }
        return list;
    }

    @Override
    public IFileEntry getFileEntry(String path) {
        if (path == null) {
            return null;
        }
        IFileEntry entry = this.findEntry(path);
        if (entry == null) {
            while (path.startsWith("/")) {
                entry = this.findEntry(path = path.substring(1, path.length()));
                if (entry != null) break;
            }
        }
        if (entry == null) {
            entry = this.findEntry("/" + path);
        }
        return entry;
    }

    private IFileEntry findEntry(String path) {
        Element e;
        IFileEntry entry = null;
        if (this.entries != null) {
            entry = this.entries.get(path);
        }
        if (entry == null && (e = this.findEntryElementByPath(path)) != null) {
            entry = this.createFileEntry(path, e);
        }
        return entry;
    }

    private Element findEntryElementByPath(String path) {
        Iterator<Element> it = DOMUtils.childElementIterByTag(this.getManifestElement(), "file-entry");
        while (it.hasNext()) {
            Element e = it.next();
            if (!path.equals(e.getAttribute("full-path"))) continue;
            return e;
        }
        return null;
    }

    @Override
    public IFileEntry createFileEntry(String path) {
        return this.createFileEntry(path, "");
    }

    @Override
    public IFileEntry createFileEntry(String path, String mediaType) {
        IFileEntry entry = this.getFileEntry(path);
        if (entry != null) {
            return entry;
        }
        String parent = InternalDOMUtils.getParentPath(path);
        if (parent != null) {
            this.createFileEntry(parent);
        }
        Element e = this.implementation.createElement("file-entry");
        e.setAttribute("full-path", path);
        e.setAttribute("media-type", mediaType);
        return this.createFileEntry(path, e);
    }

    private IFileEntry createFileEntry(String path, Element entryElement) {
        FileEntryImpl entry = new FileEntryImpl(entryElement, this);
        if (this.entries == null) {
            this.entries = new TreeMap<String, IFileEntry>(ENTRY_COMPARATOR);
        }
        this.entries.put(path, entry);
        return entry;
    }

    protected void insertFileEntry(IFileEntry entry) {
        Element e = (Element)entry.getAdapter(Element.class);
        if (e != null) {
            this.insertFileEntryImpl(e);
        }
    }

    protected void removeFileEntry(IFileEntry entry) {
        Element m;
        Element e = (Element)entry.getAdapter(Element.class);
        if (e != null && (m = this.getManifestElement()) == e.getParentNode()) {
            m.removeChild(e);
        }
    }

    private void insertFileEntryImpl(Element entryElement) {
        Element e = this.findInsertLocation(entryElement);
        if (e != null) {
            this.getManifestElement().insertBefore(entryElement, e);
        } else {
            this.getManifestElement().appendChild(entryElement);
        }
    }

    private Element findInsertLocation(Element entryElement) {
        if (entryElement.hasAttribute("full-path")) {
            return this.findInsertLocation(entryElement, entryElement.getAttribute("full-path"));
        }
        return null;
    }

    private Element findInsertLocation(Element entryElement, String path) {
        Iterator<Element> it = DOMUtils.childElementIterByTag(this.getManifestElement(), "file-entry");
        while (it.hasNext()) {
            String p;
            Element e = it.next();
            if (e == entryElement || !e.hasAttribute("full-path") || (p = e.getAttribute("full-path")) == null || path.compareToIgnoreCase(p) >= 0) continue;
            return e;
        }
        return null;
    }

    @Override
    public IFileEntry createAttachmentFromFilePath(String sourcePath) throws IOException {
        return this.createAttachmentFromFilePath(sourcePath, null);
    }

    @Override
    public IFileEntry createAttachmentFromFilePath(String sourcePath, String mediaType) throws IOException {
        if (sourcePath == null) {
            throw new IllegalArgumentException("Path is null!");
        }
        File file = new File(sourcePath);
        if (!file.exists()) {
            throw new FileNotFoundException("Source path does not exists.");
        }
        if (file.isFile()) {
            IFileEntry entry = this.createAttachmentFromStream(new FileInputStream(sourcePath), sourcePath, mediaType);
            if (entry != null) {
                entry.setTime(file.lastModified());
            }
            return entry;
        }
        if (file.isDirectory()) {
            IFileEntry root;
            String fileName = file.getName();
            String path = this.makeAttachmentPath(fileName, true);
            if (mediaType == null) {
                mediaType = FileUtils.getMediaType(fileName);
            }
            if ((root = this.createFileEntry(path, mediaType)) != null) {
                this.importDirectory(path, file);
            }
            return root;
        }
        throw new IllegalArgumentException("Unknown file type (neither a file nor a directory)");
    }

    protected void importDirectory(String parentPath, File dir) throws IOException {
        String[] stringArray = dir.list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String path;
            String sub = stringArray[n2];
            File f = new File(dir, sub);
            if (f.isFile()) {
                String mediaType;
                path = parentPath == null ? sub : String.valueOf(parentPath) + sub;
                IFileEntry e = this.createFileEntry(path, mediaType = FileUtils.getMediaType(sub));
                if (e != null) {
                    OutputStream os = e.getOutputStream();
                    if (os != null) {
                        FileUtils.transfer(new FileInputStream(f), os);
                    }
                    e.setTime(f.lastModified());
                }
            } else if (f.isDirectory()) {
                path = parentPath == null ? String.valueOf(sub) + "/" : String.valueOf(parentPath) + sub + "/";
                this.importDirectory(path, f);
            }
            ++n2;
        }
    }

    @Override
    public IFileEntry createAttachmentFromStream(InputStream stream, String sourceName) throws IOException {
        return this.createAttachmentFromStream(stream, sourceName, null);
    }

    @Override
    public IFileEntry createAttachmentFromStream(InputStream stream, String sourceName, String mediaType) throws IOException {
        IFileEntry entry;
        if (sourceName == null || stream == null) {
            return null;
        }
        String path = this.makeAttachmentPath(sourceName, false);
        if (mediaType == null) {
            mediaType = FileUtils.getMediaType(sourceName);
        }
        if ((entry = this.createFileEntry(path, mediaType)) != null) {
            OutputStream os = entry.getOutputStream();
            if (os == null) {
                throw new IOException();
            }
            FileUtils.transfer(stream, os);
        }
        return entry;
    }

    @Override
    public IFileEntry cloneEntry(IFileEntry sourceEntry, String targetPath) throws IOException {
        if (sourceEntry == null || targetPath == null) {
            return null;
        }
        IFileEntry existingEntry = this.getFileEntry(targetPath);
        if (existingEntry != null) {
            return null;
        }
        if (sourceEntry.isDirectory()) {
            if (!targetPath.endsWith("/")) {
                targetPath = String.valueOf(targetPath) + "/";
            }
            this.importDirectoryEntry(targetPath, sourceEntry);
        } else {
            this.importFileEntry(targetPath, sourceEntry);
        }
        return this.getFileEntry(targetPath);
    }

    private void importFileEntry(String path, IFileEntry sourceEntry) throws IOException {
        InputStream in = sourceEntry.getInputStream();
        if (in != null) {
            OutputStream os;
            IFileEntry entry = this.createFileEntry(path, sourceEntry.getMediaType());
            if (entry != null && (os = entry.getOutputStream()) != null) {
                FileUtils.transfer(in, os);
            }
            entry.setTime(sourceEntry.getTime());
        }
    }

    private void importDirectoryEntry(String parentPath, IFileEntry sourceEntry) throws IOException {
        String sourceParentPath = InternalDOMUtils.getParentPath(sourceEntry.getPath());
        for (IFileEntry sourceSubEntry : sourceEntry.getSubEntries()) {
            String sourceSubPath = sourceSubEntry.getPath();
            if (sourceSubPath == null) continue;
            String subPath = sourceSubPath.substring(sourceParentPath.length());
            if (parentPath != null) {
                subPath = String.valueOf(parentPath) + subPath;
            }
            if (sourceSubEntry.isDirectory()) continue;
            this.importFileEntry(subPath, sourceSubEntry);
        }
        if (this.getFileEntry(parentPath) == null) {
            this.createFileEntry(parentPath, sourceEntry.getMediaType());
        }
    }

    @Override
    public IFileEntry cloneEntryAsAttachment(IFileEntry sourceEntry) throws IOException {
        String sourcePath = sourceEntry.getPath();
        String path = this.makeAttachmentPath(sourcePath, sourceEntry.isDirectory());
        return this.cloneEntry(sourceEntry, path);
    }

    @Override
    public String makeAttachmentPath(String source) {
        return this.makeAttachmentPath(source, false);
    }

    @Override
    public String makeAttachmentPath(String source, boolean directory) {
        String path = "attachments/" + Core.getIdFactory().createId() + FileUtils.getExtension(source);
        if (directory) {
            path = String.valueOf(path) + "/";
        }
        return path;
    }

    @Override
    public IEncryptionData getEncryptionData(String entryPath) {
        IFileEntry entry = this.getFileEntry(entryPath);
        if (entry != null) {
            return entry.getEncryptionData();
        }
        return null;
    }
}

