/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmind.core.ISheet;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.internal.Legend;
import org.xmind.core.internal.dom.NumberUtils;
import org.xmind.core.internal.dom.SheetImpl;
import org.xmind.core.marker.IMarker;
import org.xmind.core.util.DOMUtils;
import org.xmind.core.util.Point;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegendImpl
extends Legend
implements ICoreEventSource {
    private Element sheetElement;
    private SheetImpl ownedSheet;

    public LegendImpl(Element sheetElement, SheetImpl ownedSheet) {
        this.sheetElement = sheetElement;
        this.ownedSheet = ownedSheet;
    }

    public Element getSheetElement() {
        return this.sheetElement;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof LegendImpl)) {
            return false;
        }
        LegendImpl that = (LegendImpl)obj;
        return this.sheetElement == that.sheetElement;
    }

    public int hashCode() {
        return this.sheetElement.hashCode();
    }

    public String toString() {
        return "LGD{" + this.ownedSheet + "}";
    }

    @Override
    public ISheet getOwnedSheet() {
        return this.ownedSheet;
    }

    @Override
    public IWorkbook getOwnedWorkbook() {
        return this.ownedSheet.getOwnedWorkbook();
    }

    public Element getImplementation() {
        return DOMUtils.getFirstChildElementByTag(this.sheetElement, "legend");
    }

    private Element ensureImplementation() {
        return DOMUtils.ensureChildElement(this.sheetElement, "legend");
    }

    private void checkImplementation() {
        Element implementation = this.getImplementation();
        if (!implementation.hasAttributes() && !implementation.hasChildNodes()) {
            this.sheetElement.removeChild(implementation);
        }
    }

    @Override
    public boolean isEmpty() {
        Element implementation = this.getImplementation();
        if (implementation != null) {
            return !implementation.hasChildNodes();
        }
        return true;
    }

    @Override
    public boolean isVisible() {
        Element implementation = this.getImplementation();
        if (implementation != null) {
            return "visible".equals(implementation.getAttribute("visibility"));
        }
        return false;
    }

    @Override
    public void setVisible(boolean visible) {
        Element implementation;
        if (visible) {
            if (!this.isVisible()) {
                Element implementation2 = this.ensureImplementation();
                DOMUtils.setAttribute(implementation2, "visibility", "visible");
                this.fireValueChange("visibility", Boolean.FALSE, Boolean.TRUE);
            }
        } else if (this.isVisible() && (implementation = this.getImplementation()) != null) {
            DOMUtils.setAttribute(implementation, "visibility", "hidden");
            this.checkImplementation();
            this.fireValueChange("visibility", Boolean.TRUE, Boolean.FALSE);
        }
    }

    @Override
    public Point getPosition() {
        Element implementation = this.getImplementation();
        if (implementation == null) {
            return null;
        }
        Element e = DOMUtils.getFirstChildElementByTag(implementation, "position");
        if (e == null) {
            return null;
        }
        String x = DOMUtils.getAttribute(e, "svg:x");
        String y = DOMUtils.getAttribute(e, "svg:y");
        if (x == null && y == null) {
            return null;
        }
        return new Point(NumberUtils.safeParseInt(x, 0), NumberUtils.safeParseInt(y, 0));
    }

    @Override
    public boolean hasPosition() {
        Element e;
        Element implementation = this.getImplementation();
        if (implementation != null && (e = DOMUtils.getFirstChildElementByTag(implementation, "position")) != null) {
            return e.hasAttribute("svg:x") && e.hasAttribute("svg:y");
        }
        return false;
    }

    @Override
    public void setPosition(int x, int y) {
        Element implementation = this.ensureImplementation();
        Point oldValue = this.getPosition();
        Element e = DOMUtils.ensureChildElement(implementation, "position");
        DOMUtils.setAttribute(e, "svg:x", Integer.toString(x));
        DOMUtils.setAttribute(e, "svg:y", Integer.toString(y));
        Point newValue = this.getPosition();
        this.fireValueChange("position", oldValue, newValue);
    }

    @Override
    protected void removePosition() {
        Element implementation = this.getImplementation();
        if (implementation == null) {
            return;
        }
        Point oldValue = this.getPosition();
        Element e = DOMUtils.getFirstChildElementByTag(implementation, "position");
        if (e != null) {
            implementation.removeChild(e);
        }
        Point newValue = this.getPosition();
        this.fireValueChange("position", oldValue, newValue);
    }

    private Element getItemsElement() {
        Element implementation = this.getImplementation();
        if (implementation != null) {
            return DOMUtils.getFirstChildElementByTag(implementation, "marker-descriptions");
        }
        return null;
    }

    private Element ensureItemsElement() {
        Element implementation = this.ensureImplementation();
        return DOMUtils.ensureChildElement(implementation, "marker-descriptions");
    }

    @Override
    public String getMarkerDescription(String markerId) {
        String description;
        Element itemsEle = this.getItemsElement();
        Element item = this.findItem(itemsEle, markerId);
        if (item != null && (description = DOMUtils.getAttribute(item, "description")) != null) {
            return description;
        }
        IMarker marker = this.getOwnedWorkbook().getMarkerSheet().findMarker(markerId);
        if (marker != null) {
            return marker.getName();
        }
        return "";
    }

    private Element findItem(Element itemsEle, String markerId) {
        if (itemsEle != null) {
            Iterator<Element> it = DOMUtils.childElementIterByTag(itemsEle, "marker-description");
            while (it.hasNext()) {
                Element item = it.next();
                String m = DOMUtils.getAttribute(item, "marker-id");
                if (m == null || !m.equals(markerId)) continue;
                return item;
            }
        }
        return null;
    }

    @Override
    public void setMarkerDescription(String markerId, String description) {
        String oldValue = null;
        Element itemsEle = this.getItemsElement();
        Element item = this.findItem(itemsEle, markerId);
        if (item != null) {
            oldValue = DOMUtils.getAttribute(item, "description");
            if (description != null) {
                DOMUtils.setAttribute(item, "description", description);
            } else {
                Node p;
                itemsEle.removeChild(item);
                if (!itemsEle.hasChildNodes() && (p = itemsEle.getParentNode()) != null) {
                    p.removeChild(itemsEle);
                }
                this.checkImplementation();
            }
        } else if (description != null) {
            if (itemsEle == null) {
                itemsEle = this.ensureItemsElement();
            }
            item = DOMUtils.createElement(itemsEle, "marker-description");
            DOMUtils.setAttribute(item, "marker-id", markerId);
            DOMUtils.setAttribute(item, "description", description);
        }
        this.fireTargetValueChange("markerDescription", markerId, oldValue, description);
    }

    @Override
    public Set<String> getMarkerIds() {
        Iterator<Element> it;
        Element itemsEle = this.getItemsElement();
        if (itemsEle != null && (it = DOMUtils.childElementIterByTag(itemsEle, "marker-description")).hasNext()) {
            ArrayList<String> list = new ArrayList<String>(itemsEle.getChildNodes().getLength());
            while (it.hasNext()) {
                Element item = it.next();
                String markerId = DOMUtils.getAttribute(item, "marker-id");
                if (markerId == null) continue;
                list.add(markerId);
            }
            if (!list.isEmpty()) {
                return DOMUtils.unmodifiableSet(list);
            }
        }
        return NO_MARKER_IDS;
    }

    @Override
    public ICoreEventRegistration registerCoreEventListener(String type, ICoreEventListener listener) {
        return this.getCoreEventSupport().registerCoreEventListener(this, type, listener);
    }

    protected void fireValueChange(String type, Object oldValue, Object newValue) {
        this.getCoreEventSupport().dispatchValueChange(this, type, oldValue, newValue);
    }

    protected void fireTargetValueChange(String type, Object target, Object oldValue, Object newValue) {
        this.getCoreEventSupport().dispatchTargetValueChange(this, type, target, oldValue, newValue);
    }

    @Override
    public ICoreEventSupport getCoreEventSupport() {
        return this.ownedSheet.getCoreEventSupport();
    }
}

