/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xmind.core.IAdaptable;
import org.xmind.core.IHtmlNotesContent;
import org.xmind.core.IHyperlinkSpan;
import org.xmind.core.IImageSpan;
import org.xmind.core.INotes;
import org.xmind.core.IParagraph;
import org.xmind.core.ITextSpan;
import org.xmind.core.internal.ElementRegistry;
import org.xmind.core.internal.dom.HyperlinkSpanImpl;
import org.xmind.core.internal.dom.INodeAdaptableProvider;
import org.xmind.core.internal.dom.ImageSpanImpl;
import org.xmind.core.internal.dom.NotesContentImplBase;
import org.xmind.core.internal.dom.NotesImpl;
import org.xmind.core.internal.dom.ParagraphImpl;
import org.xmind.core.internal.dom.TextSpanImpl;
import org.xmind.core.internal.dom.WorkbookImpl;
import org.xmind.core.util.DOMUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlNotesContentImpl
extends NotesContentImplBase
implements IHtmlNotesContent,
INodeAdaptableProvider {
    public HtmlNotesContentImpl(Element implementation, WorkbookImpl ownedWorkbook) {
        super(implementation, ownedWorkbook);
    }

    @Override
    public void addParagraph(IParagraph paragraph) {
        ParagraphImpl p = (ParagraphImpl)paragraph;
        this.getImplementation().appendChild(p.getImplementation());
        p.addNotify(this.getRealizedWorkbook());
    }

    @Override
    public IImageSpan createImageSpan(String source) {
        Element e = ((WorkbookImpl)this.getOwnedWorkbook()).getImplementation().createElement("xhtml:img");
        ImageSpanImpl image = new ImageSpanImpl(e, this);
        image.setSource(source);
        this.register(e, image);
        return image;
    }

    @Override
    public IHyperlinkSpan createHyperlinkSpan(String sourceHyper) {
        Element e = ((WorkbookImpl)this.getOwnedWorkbook()).getImplementation().createElement("xhtml:a");
        HyperlinkSpanImpl hyperlink = new HyperlinkSpanImpl(e, this);
        hyperlink.setHref(sourceHyper);
        this.register(e, hyperlink);
        return hyperlink;
    }

    @Override
    public IParagraph createParagraph() {
        Element e = ((WorkbookImpl)this.getOwnedWorkbook()).getImplementation().createElement("xhtml:p");
        ParagraphImpl paragraph = new ParagraphImpl(e, this);
        this.register(e, paragraph);
        return paragraph;
    }

    @Override
    public ITextSpan createTextSpan(String textContent) {
        Text t = ((WorkbookImpl)this.getOwnedWorkbook()).getImplementation().createTextNode(textContent);
        TextSpanImpl text = new TextSpanImpl(t, this);
        this.register(t, text);
        return text;
    }

    @Override
    public List<IParagraph> getParagraphs() {
        return DOMUtils.getChildList(this.getImplementation(), "xhtml:p", this);
    }

    @Override
    public void removeParagraph(IParagraph paragraph) {
        ParagraphImpl p = (ParagraphImpl)paragraph;
        if (p.getImplementation().getParentNode() == this.getImplementation()) {
            p.removeNotify(this.getRealizedWorkbook());
            this.getImplementation().removeChild(p.getImplementation());
        }
    }

    protected ElementRegistry getElementRegistry() {
        return ((WorkbookImpl)this.getOwnedWorkbook()).getElementRegistry();
    }

    @Override
    public IAdaptable getAdaptable(Node node) {
        if (node == null) {
            return null;
        }
        IAdaptable element = ((WorkbookImpl)this.getOwnedWorkbook()).getAdaptable(node);
        if (element == null) {
            if (node instanceof Element) {
                Element e = (Element)node;
                String tagName = e.getTagName();
                if ("xhtml:p".equals(tagName)) {
                    element = new ParagraphImpl(e, this);
                } else if ("xhtml:span".equals(tagName)) {
                    element = new TextSpanImpl(e, this);
                } else if ("xhtml:img".equals(tagName)) {
                    element = new ImageSpanImpl(e, this);
                } else if ("xhtml:a".equals(tagName)) {
                    element = new HyperlinkSpanImpl(e, this);
                }
            } else {
                Node p = node.getParentNode();
                if (p instanceof Element && ("xhtml:p".equals(p.getNodeName()) || "xhtml:a".equals(p.getNodeName()))) {
                    element = new TextSpanImpl(node, this);
                }
            }
            if (element != null) {
                this.register(node, element);
            }
        }
        return element;
    }

    protected void register(Object key, Object element) {
        this.getElementRegistry().registerByKey(key, element);
    }

    protected void unregister(Object key) {
        this.getElementRegistry().unregisterByKey(key);
    }

    @Override
    protected void addNotify(WorkbookImpl workbook) {
        for (IParagraph p : this.getParagraphs()) {
            ((ParagraphImpl)p).addNotify(workbook);
        }
    }

    @Override
    protected void removeNotify(WorkbookImpl workbook) {
        for (IParagraph p : this.getParagraphs()) {
            ((ParagraphImpl)p).removeNotify(workbook);
        }
    }

    protected WorkbookImpl getRealizedWorkbook() {
        INotes parent = this.getParent();
        if (parent instanceof NotesImpl) {
            return ((NotesImpl)parent).getRealizedWorkbook();
        }
        return null;
    }
}

