/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.signin.internal.actions;

import java.util.Properties;
import net.xmind.signin.ISignInListener;
import net.xmind.signin.XMindNetEntry;
import net.xmind.signin.internal.Messages;
import net.xmind.signin.internal.actions.XMindNetActionDelegate;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class SignInActionDelegate
extends XMindNetActionDelegate
implements IWorkbenchWindowActionDelegate,
IActionDelegate2,
ISignInListener {
    private IWorkbenchWindow window;
    private IAction action;

    public void dispose() {
        this.window = null;
        this.action = null;
        XMindNetEntry.removeSignInListener(this);
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
        XMindNetEntry.addSignInListener(this);
        this.update();
    }

    public void init(IAction action) {
        this.action = action;
        this.update();
    }

    private void update() {
        if (this.action == null) {
            return;
        }
        boolean signedIn = XMindNetEntry.hasSignedIn();
        this.action.setText(signedIn ? Messages.SignOut_text : Messages.SignIn_text);
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void run(IAction action) {
        if (this.window == null) {
            return;
        }
        boolean signedIn = XMindNetEntry.hasSignedIn();
        if (signedIn) {
            XMindNetEntry.signOut();
            this.showWelcome();
        } else {
            XMindNetEntry.signIn(new ISignInListener(){

                public void postSignOut() {
                }

                public void postSignIn(Properties userInfo) {
                    if (userInfo != null) {
                        SignInActionDelegate.this.showAccount(userInfo);
                    }
                }
            }, false);
        }
    }

    private void showWelcome() {
        this.setURL("http://www.xmind.net/xmind/welcome/");
        this.gotoURL();
    }

    private void showAccount(Properties userInfo) {
        String userID = userInfo.getProperty("USER_ID");
        String token = userInfo.getProperty("TOKEN");
        String url = String.format("http://www.xmind.net/xmind/account/%s/%s", userID, token);
        this.setURL(url);
        this.gotoURL();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void postSignIn(Properties userInfo) {
        this.update();
    }

    public void postSignOut() {
        this.update();
    }
}

