/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.spreadsheet.structures;

import java.util.HashSet;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.Request;
import org.xmind.gef.draw2d.IReferencedFigure;
import org.xmind.gef.draw2d.ReferencedLayoutData;
import org.xmind.gef.graphicalpolicy.IStructure;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.ui.branch.AbstractBranchStructure;
import org.xmind.ui.branch.ICreatableBranchStructureExtension;
import org.xmind.ui.branch.IInsertion;
import org.xmind.ui.branch.IMovableBranchStructureExtension;
import org.xmind.ui.branch.Insertion;
import org.xmind.ui.internal.spreadsheet.structures.Cell;
import org.xmind.ui.internal.spreadsheet.structures.CellInsertion;
import org.xmind.ui.internal.spreadsheet.structures.Chart;
import org.xmind.ui.internal.spreadsheet.structures.Column;
import org.xmind.ui.internal.spreadsheet.structures.ColumnHead;
import org.xmind.ui.internal.spreadsheet.structures.Item;
import org.xmind.ui.internal.spreadsheet.structures.Row;
import org.xmind.ui.internal.spreadsheet.structures.SpreadsheetStructure;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.IBranchRangePart;
import org.xmind.ui.mindmap.IPlusMinusPart;
import org.xmind.ui.mindmap.ISummaryPart;
import org.xmind.ui.tools.ParentSearchKey;
import org.xmind.ui.util.MindMapUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RowStructure
extends AbstractBranchStructure
implements ICreatableBranchStructureExtension,
IMovableBranchStructureExtension {
    protected boolean isValidStructureData(IBranchPart branch, Object data) {
        return super.isValidStructureData(branch, data) && data instanceof Row;
    }

    protected Object createStructureData(IBranchPart branch) {
        IBranchPart parent = branch.getParentBranch();
        if (parent != null) {
            Chart chart = null;
            IStructure sa = parent.getBranchPolicy().getStructure((IGraphicalPart)parent);
            if (sa instanceof SpreadsheetStructure) {
                chart = ((SpreadsheetStructure)sa).getChart(parent);
            }
            if (chart == null) {
                chart = new Chart(parent);
            }
            return chart.getRow(branch.getBranchIndex());
        }
        Chart chart = new Chart(null);
        Row row = new Row(branch, chart);
        Column col = new Column(chart, ColumnHead.EMPTY);
        chart.setContent(row, col);
        chart.setLineWidth(1);
        Cell cell = new Cell(chart, row, col);
        row.addCell(cell);
        for (IBranchPart sub : branch.getSubBranches()) {
            cell.addItem(new Item(chart, sub));
        }
        return row;
    }

    public Row getRow(IBranchPart branch) {
        return (Row)((Object)super.getStructureData(branch));
    }

    protected void doFillPlusMinus(IBranchPart branch, IPlusMinusPart plusMinus, AbstractBranchStructure.LayoutInfo info) {
        Point ref = info.getReference();
        int y = ref.y;
        Rectangle topicBounds = info.getCheckedClientArea();
        int x = topicBounds.right();
        IFigure pmFigure = plusMinus.getFigure();
        Dimension size = pmFigure.getPreferredSize();
        Rectangle r = new Rectangle(x, y - size.height / 2, size.width, size.height);
        info.put(pmFigure, r);
    }

    protected void doFillSubBranches(IBranchPart branch, List<IBranchPart> subBranches, AbstractBranchStructure.LayoutInfo info) {
    }

    protected void fillSubBranches(IBranchPart branch, List<IBranchPart> subBranches, AbstractBranchStructure.LayoutInfo info) {
        Rectangle area = info.getCheckedClientArea();
        Row row = this.getRow(branch);
        Chart chart = row.getOwnedChart();
        int lineWidth = chart.getLineWidth();
        int cellSpacing = chart.getMinorSpacing();
        int itemSpacing = row.getMinorSpacing();
        IInsertion insertion = this.getCurrentInsertion(branch);
        ColumnHead insHead = (ColumnHead)MindMapUtils.getCache((IPart)branch, (String)"org.xmind.ui.spreadsheet.cache.insertionColumnHead");
        int startY = info.getReference().y - row.getPrefCellHeight() / 2;
        int x = area.x + chart.getRowHeadWidth() + cellSpacing + lineWidth;
        List<Column> columns = chart.getColumns();
        IInsertion colIns = (IInsertion)MindMapUtils.getCache((IPart)chart.getTitle(), (String)"org.xmind.ui.spreadsheet.cache.columnInsertion");
        int colIndex = 0;
        while (colIndex < columns.size()) {
            if (colIns != null && colIns.getIndex() == colIndex) {
                x += colIns.getSize().width + chart.getMinorSpacing() + lineWidth;
            }
            Column col = columns.get(colIndex);
            int y = startY;
            boolean insertionInColumn = insertion != null && col.getHead().equals(insHead);
            Cell cell = row.findCellByColumn(col);
            if (cell != null) {
                info.add(new Rectangle(x, y, col.getPrefCellWidth(), cell.getContentHeight()));
                List<Item> items = cell.getItems();
                int num = items.size();
                int i = 0;
                while (i < num) {
                    Item item = items.get(i);
                    if (insertionInColumn && insertion.getIndex() == i) {
                        Rectangle r = insertion.createRectangle(x, y);
                        info.add(r);
                        y += r.height + itemSpacing;
                    }
                    IBranchPart child = item.getBranch();
                    IFigure childFigure = child.getFigure();
                    Dimension size = childFigure.getPreferredSize();
                    Rectangle childBounds = new Rectangle(x, y, size.width, size.height);
                    info.put(childFigure, childBounds);
                    y += size.height + itemSpacing;
                    ++i;
                }
                if (insertionInColumn && insertion.getIndex() == num) {
                    info.add(insertion.createRectangle(x, y));
                }
            } else if (insertionInColumn) {
                info.add(insertion.createRectangle(x, y));
            }
            x += col.getPrefCellWidth() + cellSpacing + lineWidth;
            ++colIndex;
        }
        if (colIns != null && colIns.getIndex() == columns.size()) {
            info.add(new Rectangle(x, startY, colIns.getSize().width, 1));
        }
    }

    public void fillLayoutData(IBranchPart branch, ReferencedLayoutData data) {
        super.fillLayoutData(branch, data);
        MindMapUtils.flushCache((IPart)branch, (String)"org.xmind.ui.spreadsheet.cache.invalidating");
    }

    protected void invalidateBranch(IBranchPart branch) {
        super.invalidateBranch(branch);
        MindMapUtils.setCache((IPart)branch, (String)"org.xmind.ui.spreadsheet.cache.invalidating", (Object)Boolean.TRUE);
    }

    public int getSourceOrientation(IBranchPart branch) {
        return 0;
    }

    public int getChildTargetOrientation(IBranchPart branch, IBranchPart subBranch) {
        return 0;
    }

    public int getRangeGrowthDirection(IBranchPart branch, IBranchRangePart range) {
        return 4;
    }

    public int getSummaryDirection(IBranchPart branch, ISummaryPart summary) {
        return 16;
    }

    public IPart calcNavigation(IBranchPart branch, String navReqType) {
        Cell cell;
        Row row;
        if ("navigate right".equals(navReqType) && !(row = this.getRow(branch)).getCells().isEmpty() && !(cell = row.getCells().get(0)).getItems().isEmpty()) {
            Item item = cell.getItems().get(0);
            return item.getBranch().getTopicPart();
        }
        return super.calcNavigation(branch, navReqType);
    }

    public IPart calcChildNavigation(IBranchPart branch, IBranchPart sourceChild, String navReqType, boolean sequential) {
        Item next;
        Row row;
        Item item;
        if ("navigate left".equals(navReqType)) {
            Cell prev;
            Row row2 = this.getRow(branch);
            Cell cell = row2.findCellByItem(sourceChild);
            if (cell != null && (prev = row2.getPreviousCell(cell)) == null && !sequential) {
                return branch.getTopicPart();
            }
        } else if ("navigate up".equals(navReqType)) {
            Item prev;
            Row row3 = this.getRow(branch);
            Item item2 = row3.findItem(sourceChild);
            if (item2 != null && (prev = item2.getPreviousItem()) != null) {
                return prev.getBranch().getTopicPart();
            }
        } else if ("navigate down".equals(navReqType) && (item = (row = this.getRow(branch)).findItem(sourceChild)) != null && (next = item.getNextItem()) != null) {
            return next.getBranch().getTopicPart();
        }
        return super.calcChildNavigation(branch, sourceChild, navReqType, sequential);
    }

    public void calcSequentialNavigation(IBranchPart branch, IBranchPart startChild, IBranchPart endChild, List<IBranchPart> results) {
        Row row = this.getRow(branch);
        Item startItem = row.findItem(startChild);
        if (startItem != null) {
            Cell cell = startItem.getOwnedCell();
            Item endItem = row.findItem(endChild);
            if (endItem != null && cell == endItem.getOwnedCell()) {
                int startIndex = cell.getItemIndex(startItem);
                int endIndex = cell.getItemIndex(endItem);
                if (startIndex >= 0 && endIndex >= 0) {
                    boolean decreasing = endIndex < startIndex;
                    int i = startIndex;
                    while (!(decreasing ? i < endIndex : i > endIndex)) {
                        Item item = cell.getItems().get(i);
                        results.add(item.getBranch());
                        if (decreasing) {
                            --i;
                            continue;
                        }
                        ++i;
                    }
                }
            }
        }
        super.calcSequentialNavigation(branch, startChild, endChild, results);
    }

    public int calcChildDistance(IBranchPart branch, ParentSearchKey key) {
        Point pos = key.getCursorPos();
        Row row = this.getRow(branch);
        Chart chart = row.getOwnedChart();
        int rowY = row.getTop();
        int rowHeight = row.getHeight();
        if (pos.y > rowY && pos.y < rowY + rowHeight) {
            Cell cell;
            if (!chart.hasColumns()) {
                int x = chart.getTitle().getFigure().getBounds().x;
                int w = chart.getTitle().getFigure().getBounds().width;
                int childX = key.getFigure().getBounds().x;
                if (childX > x && childX < x + w) {
                    return 0;
                }
            }
            if ((cell = row.findCell(pos)) != null) {
                if (cell.getItems().isEmpty()) {
                    return 0;
                }
                int colX = cell.getOwnedColumn().getLeft();
                int offset = pos.x - colX;
                int index = 0;
                int last = cell.getItems().size() - 1;
                for (Item item : cell.getItems()) {
                    Rectangle itemBounds = item.getBranch().getFigure().getBounds();
                    if (index == 0 && pos.y < itemBounds.y) {
                        return 0;
                    }
                    if (index == last && pos.y > itemBounds.bottom()) {
                        return 0;
                    }
                    if (pos.x < itemBounds.x) {
                        return 0;
                    }
                    Rectangle itemTopicBounds = item.getBranch().getTopicPart().getFigure().getBounds();
                    if (pos.x < itemTopicBounds.right()) {
                        return offset;
                    }
                    ++index;
                }
                return offset;
            }
        }
        return -1;
    }

    public int calcChildIndex(IBranchPart branch, ParentSearchKey key) {
        Row row = this.getRow(branch);
        Chart chart = row.getOwnedChart();
        Point pos = key.getCursorPos();
        Cell cell = row.findCell(pos);
        if (cell == null || cell.getItems().isEmpty()) {
            return -1;
        }
        Dimension insSize = this.getInsSize(key.getFigure());
        int y = row.getTop() + chart.getMinorSpacing() / 2;
        int insHeight = insSize.height;
        int spacing = row.getMinorSpacing();
        int disabled = 0;
        for (Item item : cell.getItems()) {
            IBranchPart itemBranch = item.getBranch();
            Dimension itemSize = itemBranch.getFigure().getSize();
            int hint = y + (itemSize.height + insHeight) / 2;
            if (pos.y < hint) {
                return itemBranch.getBranchIndex() - disabled;
            }
            y += itemSize.height + spacing;
            if (itemBranch.getFigure().isEnabled()) continue;
            ++disabled;
        }
        return -1;
    }

    public IInsertion calcInsertion(IBranchPart branch, ParentSearchKey key) {
        return this.calcInsertion(branch, key, true);
    }

    private Insertion calcInsertion(IBranchPart branch, ParentSearchKey key, boolean withDisabled) {
        Row row = this.getRow(branch);
        Chart chart = row.getOwnedChart();
        Point pos = key.getCursorPos();
        Cell cell = row.findCell(pos);
        if (cell == null) {
            return null;
        }
        Dimension insSize = this.getInsSize(key.getFigure());
        if (cell.getItems().isEmpty()) {
            return new CellInsertion(branch, -1, insSize, cell.getOwnedColumn().getHead());
        }
        int y = row.getTop() + chart.getMinorSpacing() / 2;
        int insHeight = insSize.height;
        int spacing = row.getMinorSpacing();
        int index = 0;
        for (Item item : cell.getItems()) {
            IBranchPart itemBranch = item.getBranch();
            Dimension itemSize = itemBranch.getFigure().getSize();
            int hint = y + (itemSize.height + insHeight) / 2;
            if (pos.y < hint) {
                return new CellInsertion(branch, index, insSize, cell.getOwnedColumn().getHead());
            }
            y += itemSize.height + spacing;
            if (!withDisabled && !itemBranch.getFigure().isEnabled()) continue;
            ++index;
        }
        return new CellInsertion(branch, withDisabled ? index : -1, insSize, cell.getOwnedColumn().getHead());
    }

    private Dimension getInsSize(IReferencedFigure child) {
        return child.getSize();
    }

    public void decorateMoveInRequest(IBranchPart targetParent, ParentSearchKey childKey, IBranchPart sourceParent, Request request) {
        ColumnHead colHead = (ColumnHead)MindMapUtils.getCache((IPart)targetParent, (String)"org.xmind.ui.spreadsheet.cache.insertionColumnHead");
        if (colHead != null) {
            request.setParameter("property.labels", new HashSet<String>(colHead.getLabels()));
        } else {
            request.setParameter("property.labels", new HashSet());
        }
    }

    public void decorateMoveOutRequest(IBranchPart sourceParent, ParentSearchKey childKey, IBranchPart targetParent, Request request) {
        request.setParameter("property.labels", null);
    }

    public void decorateCreateRequest(IBranchPart branch, IBranchPart sourceChild, Request request) {
        Row row = this.getRow(branch);
        Cell cell = row.findCellByItem(sourceChild);
        if (cell != null) {
            ColumnHead colHead = cell.getOwnedColumn().getHead();
            request.setParameter("property.labels", new HashSet<String>(colHead.getLabels()));
        }
    }

    public int getQuickMoveOffset(IBranchPart branch, IBranchPart child, int direction) {
        Item next;
        Row row;
        Item item;
        if (direction == 4) {
            Item next2;
            Row row2 = this.getRow(branch);
            Item item2 = row2.findItem(child);
            if (item2 != null && (next2 = item2.getNextItem()) != null) {
                return next2.getBranch().getBranchIndex() - child.getBranchIndex();
            }
        } else if (direction == 1 && (item = (row = this.getRow(branch)).findItem(child)) != null && (next = item.getPreviousItem()) != null) {
            return next.getBranch().getBranchIndex() - child.getBranchIndex();
        }
        return super.getQuickMoveOffset(branch, child, direction);
    }
}

