/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.texteditor;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.CommandStackBase;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.command.ICommandStack2;
import org.xmind.gef.command.ICommandStackDelegate;
import org.xmind.gef.event.KeyEvent;
import org.xmind.gef.part.IGraphicalEditPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.tool.EditTool;
import org.xmind.gef.tool.PartTextSelection;
import org.xmind.ui.texteditor.FloatingTextEditor;
import org.xmind.ui.texteditor.IFloatingTextEditorListener;
import org.xmind.ui.texteditor.TextEvent;
import org.xmind.ui.viewers.SWTUtils;

public abstract class FloatingTextEditTool
extends EditTool {
    private static final boolean DEBUG = false;
    private FloatingTextEditor editor = null;
    private boolean closingFromEditor = false;
    private boolean closingFromTool = false;
    private EditorListener editorListener = null;
    private ISelectionChangedListener editorSelectionChangedListener;
    private boolean notifyingSelectionChange = false;
    private TextCommandStackDelegate delegate = null;
    private ICommandStackDelegate oldDelegate = null;

    public FloatingTextEditTool() {
        this(false);
    }

    public FloatingTextEditTool(boolean listensToSelectionChange) {
        this.editorSelectionChangedListener = listensToSelectionChange ? new EditorSelectionChangedListener() : null;
    }

    public FloatingTextEditor getEditor() {
        return this.editor;
    }

    public ITextSelection getTextSelection() {
        ISelection editorSelection;
        ISelection iSelection = editorSelection = this.editor == null ? null : this.editor.getSelection();
        if (editorSelection instanceof ITextSelection) {
            ITextSelection s = (ITextSelection)editorSelection;
            PartTextSelection realSelection = new PartTextSelection((IPart)this.getSource(), (IDocument)this.editor.getInput(), s.getOffset(), s.getLength());
            return realSelection;
        }
        return null;
    }

    public void setTextSelection(ITextSelection selection) {
        if (this.notifyingSelectionChange) {
            return;
        }
        if (selection != null) {
            this.editor.setSelection((ISelection)selection, true);
        } else {
            this.cancelEditing();
        }
    }

    protected void notifySelectionChange() {
        if (this.editorSelectionChangedListener == null) {
            return;
        }
        this.notifyingSelectionChange = true;
        this.getTargetViewer().setSelection((ISelection)this.getTextSelection(), false);
        this.notifyingSelectionChange = false;
    }

    protected boolean startEditing(IGraphicalEditPart source) {
        boolean started;
        IDocument document = this.getTextContents((IPart)source);
        if (document == null) {
            return false;
        }
        if (this.editor == null) {
            this.editor = this.createEditor();
        }
        if (started = this.openEditor(this.editor, document)) {
            this.notifySelectionChange();
            this.installCommandStackDelegate();
        }
        return started;
    }

    protected void installCommandStackDelegate() {
        ICommandStack cs = this.getDomain().getCommandStack();
        if (cs != null && cs instanceof ICommandStack2) {
            this.delegate = new TextCommandStackDelegate();
            ICommandStack2 cs2 = (ICommandStack2)cs;
            this.oldDelegate = cs2.getDelegate();
            cs2.setDelegate((ICommandStackDelegate)this.delegate);
        }
    }

    protected void uninstallCommandStackDelegate() {
        if (this.delegate != null) {
            ICommandStack cs = this.getDomain().getCommandStack();
            if (cs != null && cs instanceof ICommandStack2) {
                ICommandStack2 cs2 = (ICommandStack2)cs;
                cs2.setDelegate(this.oldDelegate);
            }
            this.oldDelegate = null;
            this.delegate = null;
        }
    }

    protected void updateCommandActions() {
        if (this.delegate != null) {
            this.delegate.fireUpdate();
        }
    }

    protected boolean openEditor(FloatingTextEditor editor, IDocument document) {
        editor.setInput((Object)document);
        this.hookEditor(editor);
        boolean open = editor.open(!this.getStatus().isStatus(4096));
        if (open) {
            if (editor.canDoOperation(7)) {
                editor.doOperation(7);
            }
            editor.getTextViewer().getTextWidget().addListener(16, (Listener)this.getEditorListener());
            this.hookEditorControl(editor, editor.getTextViewer());
        }
        return open;
    }

    protected void hookEditorControl(FloatingTextEditor editor, ITextViewer textViewer) {
    }

    protected void cancelEditing() {
        this.uninstallCommandStackDelegate();
        if (this.editor != null) {
            if (this.closingFromEditor) {
                this.unhookEditor(this.editor);
            } else if (!this.editor.isClosed()) {
                this.closingFromTool = true;
                this.closeEditor(this.editor, false);
                this.closingFromTool = false;
            }
        }
        super.cancelEditing();
        this.notifySelectionChange();
    }

    protected void finishEditing() {
        this.uninstallCommandStackDelegate();
        if (this.editor != null) {
            if (this.closingFromEditor) {
                this.unhookEditor(this.editor);
            } else if (!this.editor.isClosed()) {
                this.closingFromTool = true;
                this.closeEditor(this.editor, true);
                this.closingFromTool = false;
            }
            Object input = this.editor.getInput();
            if (input instanceof IDocument) {
                IDocument document = (IDocument)input;
                this.handleTextModified((IPart)this.getSource(), document);
            }
        }
        super.finishEditing();
        this.notifySelectionChange();
    }

    protected void closeEditor(FloatingTextEditor editor, boolean finish) {
        this.unhookEditor(editor);
        editor.close(finish);
    }

    protected abstract IDocument getTextContents(IPart var1);

    protected abstract void handleTextModified(IPart var1, IDocument var2);

    protected FloatingTextEditor createEditor() {
        int style = 0xA00 | (this.isMultilineAllowed() ? 2 : 4);
        style = this.isWrapAllowed() ? (style |= 0x40) : (style |= 0x100);
        FloatingTextEditor editor = new FloatingTextEditor((Composite)this.getTargetViewer().getCanvas(), style);
        return editor;
    }

    protected void hookEditor(FloatingTextEditor editor) {
        editor.addFloatingTextEditorListener((IFloatingTextEditorListener)this.getEditorListener());
        if (this.editorSelectionChangedListener != null) {
            editor.addSelectionChangedListener(this.editorSelectionChangedListener);
        }
    }

    protected void unhookEditor(FloatingTextEditor editor) {
        if (this.editorSelectionChangedListener != null) {
            editor.removeSelectionChangedListener(this.editorSelectionChangedListener);
        }
        editor.removeFloatingTextEditorListener((IFloatingTextEditorListener)this.getEditorListener());
    }

    private EditorListener getEditorListener() {
        if (this.editorListener == null) {
            this.editorListener = new EditorListener();
        }
        return this.editorListener;
    }

    protected boolean isMultilineAllowed() {
        return false;
    }

    protected boolean isWrapAllowed() {
        return false;
    }

    protected void selectAll() {
        if (this.editor != null && this.editor.canDoOperation(7)) {
            this.editor.doOperation(7);
        }
    }

    protected void copy() {
        if (this.editor != null && this.editor.canDoOperation(4)) {
            this.editor.doOperation(4);
        }
    }

    protected void cut() {
        if (this.editor != null && this.editor.canDoOperation(3)) {
            this.editor.doOperation(3);
        }
    }

    protected void delete() {
        if (this.editor != null && this.editor.canDoOperation(6)) {
            this.editor.doOperation(6);
        }
    }

    protected void paste() {
        if (this.editor != null && this.editor.canDoOperation(5)) {
            this.editor.doOperation(5);
        }
    }

    protected void undo() {
        this.editor.doOperation(1);
    }

    protected void redo() {
        this.editor.doOperation(2);
    }

    public boolean canUndo() {
        return this.editor != null && this.editor.canDoOperation(1);
    }

    public boolean canRedo() {
        return this.editor != null && this.editor.canDoOperation(2);
    }

    protected abstract String getUndoLabel();

    protected abstract String getRedoLabel();

    protected boolean shouldFinish(KeyEvent ke) {
        return SWTUtils.matchKey((int)ke.getState(), (int)ke.keyCode, (int)0, (int)13);
    }

    protected boolean shouldCancel(KeyEvent ke) {
        return SWTUtils.matchKey((int)ke.getState(), (int)ke.keyCode, (int)0, (int)27);
    }

    private class EditorListener
    extends IFloatingTextEditorListener.Stub
    implements Listener {
        private EditorListener() {
        }

        public void editingCanceled(TextEvent e) {
            if (FloatingTextEditTool.this.closingFromTool) {
                return;
            }
            FloatingTextEditTool.this.closingFromEditor = true;
            FloatingTextEditTool.this.cancelEditing();
            FloatingTextEditTool.this.closingFromEditor = false;
        }

        public void editingFinished(TextEvent e) {
            if (FloatingTextEditTool.this.closingFromTool) {
                return;
            }
            FloatingTextEditTool.this.closingFromEditor = true;
            FloatingTextEditTool.this.finishEditing();
            FloatingTextEditTool.this.closingFromEditor = false;
        }

        public void textChanged(TextEvent e) {
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    if (!FloatingTextEditTool.this.getStatus().isStatus(1)) {
                        return;
                    }
                    FloatingTextEditTool.this.updateCommandActions();
                }
            });
        }

        public void handleEvent(Event event) {
            if (event.type == 16) {
                final Shell oldShell = FloatingTextEditTool.this.getTargetViewer().getControl().getShell();
                final Display display = event.display;
                display.asyncExec(new Runnable(){

                    public void run() {
                        if (!FloatingTextEditTool.this.getStatus().isStatus(1) || oldShell.isDisposed()) {
                            return;
                        }
                        if (!display.isDisposed()) {
                            display.asyncExec(new Runnable(){

                                public void run() {
                                    if (display.isDisposed() || oldShell.isDisposed() || !FloatingTextEditTool.this.getStatus().isStatus(1)) {
                                        return;
                                    }
                                    Shell newShell = display.getActiveShell();
                                    if (newShell != null && !newShell.isDisposed() && !EditorListener.this.isDescendantShell(newShell, oldShell)) {
                                        FloatingTextEditTool.this.finishEditing();
                                    }
                                }
                            });
                        }
                    }
                });
            }
        }

        private boolean isDescendantShell(Shell newShell, Shell oldShell) {
            Composite parent = newShell.getParent();
            if (parent == null || !(parent instanceof Shell)) {
                return false;
            }
            if (parent == oldShell) {
                return true;
            }
            return this.isDescendantShell((Shell)parent, oldShell);
        }
    }

    private class EditorSelectionChangedListener
    implements ISelectionChangedListener {
        private EditorSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            FloatingTextEditTool.this.notifySelectionChange();
        }
    }

    private class TextCommandStackDelegate
    extends CommandStackBase
    implements ICommandStackDelegate {
        private TextCommandStackDelegate() {
        }

        public boolean canExecute(Command command) {
            return false;
        }

        public boolean canRedo() {
            return FloatingTextEditTool.this.canRedo();
        }

        public boolean canUndo() {
            return FloatingTextEditTool.this.canUndo();
        }

        public void clear() {
        }

        public void execute(Command command) {
        }

        public String getRedoLabel() {
            return FloatingTextEditTool.this.getRedoLabel();
        }

        public String getUndoLabel() {
            return FloatingTextEditTool.this.getUndoLabel();
        }

        public void redo() {
            FloatingTextEditTool.this.redo();
        }

        public void undo() {
            FloatingTextEditTool.this.undo();
        }

        public void fireUpdate() {
            this.fireEvent(128);
        }
    }
}

