/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gallery;

import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;

public class ShadowBorder
extends AbstractBorder {
    private int hDepth;
    private int vDepth;
    private int borderWidth;
    private Color shadowColor = ColorConstants.black;
    private Color borderColor = ColorConstants.black;
    private int shadowAlpha = 128;
    private boolean hideShadow = false;

    public ShadowBorder() {
        this(1, 3, 3);
    }

    public ShadowBorder(int borderWidth, int horizontalDepth, int verticalDepth) {
        this.borderWidth = borderWidth;
        this.hDepth = horizontalDepth;
        this.vDepth = verticalDepth;
    }

    public int getHorizontalDepth() {
        return this.hDepth;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setShadowDepths(int depth) {
        this.setHorizontalShadowDepth(depth);
        this.setVerticalShadowDepth(depth);
    }

    public void setShadowDepths(Dimension depths) {
        this.setHorizontalShadowDepth(depths.width);
        this.setVerticalShadowDepth(depths.height);
    }

    public Dimension getDepths() {
        return new Dimension(this.getHorizontalDepth(), this.getVerticalDepth());
    }

    public int getVerticalDepth() {
        return this.vDepth;
    }

    public void setHorizontalShadowDepth(int depth) {
        this.hDepth = depth;
    }

    public void setBorderWidth(int lineWidth) {
        this.borderWidth = lineWidth;
    }

    public void setVerticalShadowDepth(int depth) {
        this.vDepth = depth;
    }

    public Color getShadowColor() {
        return this.shadowColor;
    }

    public void setShadowColor(Color backColor) {
        this.shadowColor = backColor;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public int getShadowAlpha() {
        return this.shadowAlpha;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public void setShadowAlpha(int shadowAlpha) {
        this.shadowAlpha = shadowAlpha;
    }

    public void reverseShadow() {
        this.hDepth = -this.hDepth;
        this.vDepth = -this.vDepth;
    }

    public boolean isShadowVisible() {
        return !this.hideShadow;
    }

    public void setShadowVisible(boolean visible) {
        this.hideShadow = !visible;
    }

    public void hideShadow() {
        this.hideShadow = true;
    }

    public void showShadow() {
        this.hideShadow = false;
    }

    public Insets getInsets(IFigure figure) {
        Insets ins = new Insets(this.getBorderWidth());
        int hd = this.getHorizontalDepth();
        if (hd > 0) {
            ins.right += hd;
        } else {
            ins.left -= hd;
        }
        int vd = this.getVerticalDepth();
        if (vd > 0) {
            ins.bottom += vd;
        } else {
            ins.top -= vd;
        }
        return ins;
    }

    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        Rectangle r = ShadowBorder.getPaintRectangle((IFigure)figure, (Insets)insets);
        Rectangle c = r.getCropped(this.getInsets(figure));
        int left = c.x;
        int right = c.right();
        int top = c.y;
        int bottom = c.bottom();
        int hd = this.getHorizontalDepth();
        int vd = this.getVerticalDepth();
        int bw = this.getBorderWidth();
        int height = c.height + bw * 2;
        int width = c.width + bw * 2;
        if (this.isShadowVisible() && (hd != 0 || vd != 0)) {
            Rectangle r1 = new Rectangle(left - bw + hd, 0, width - Math.abs(hd), Math.min(height, Math.abs(vd)));
            Rectangle r2 = new Rectangle(0, top - bw + vd, Math.min(width, Math.abs(hd)), height);
            if (hd < 0) {
                r1.x -= hd;
            }
            r1.y = vd > 0 ? bottom + bw : top - bw + vd;
            int n = r2.x = hd > 0 ? right + bw : left - bw + hd;
            if (figure.isEnabled()) {
                graphics.setBackgroundColor(this.shadowColor);
            } else {
                graphics.setBackgroundColor(ColorConstants.buttonLightest);
            }
            graphics.setAlpha(this.shadowAlpha);
            if (!r1.isEmpty()) {
                graphics.fillRectangle(r1);
            }
            graphics.fillRectangle(r2);
        }
        if (bw != 0) {
            int x = left + bw / 2 - bw;
            int y = top + bw / 2 - bw;
            int w = width - Math.max(1, bw);
            int h = height - Math.max(1, bw);
            if (figure.isEnabled()) {
                graphics.setForegroundColor(this.borderColor);
            } else {
                graphics.setForegroundColor(ColorConstants.buttonDarker);
            }
            graphics.setAlpha(255);
            graphics.setLineStyle(1);
            graphics.setLineWidth(this.borderWidth);
            graphics.drawRectangle(x, y, w, h);
        }
    }
}

