/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gallery;

import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.Request;
import org.xmind.gef.part.IPart;
import org.xmind.gef.policy.NavigablePolicy;
import org.xmind.ui.gallery.FramePart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GalleryNavigablePolicy
extends NavigablePolicy {
    protected void findNavParts(Request request, String navType, List<IPart> sources, List<IPart> result) {
        IPart p;
        FramePart sourceFrame = this.findSourceFrame(sources, navType);
        if (sourceFrame != null && (p = this.findNavFrame(request, navType, sourceFrame)) != null) {
            result.add(p);
            return;
        }
        super.findNavParts(request, navType, sources, result);
    }

    protected IPart findNavFrame(Request request, String navType, FramePart sourceFrame) {
        IPart parent = sourceFrame.getParent();
        if (parent == null) {
            return null;
        }
        if ("navigate beginning".equals(navType)) {
            return this.findFirstFrameChild(parent);
        }
        if ("navigate end".equals(navType)) {
            return this.findLastFrameChild(parent);
        }
        int index = parent.getChildren().indexOf((Object)sourceFrame);
        if ("navigate up".equals(navType) || "navigate left".equals(navType)) {
            IPart p = this.findFrameChildBackwards(navType, parent, index, sourceFrame);
            if (p != null) {
                return p;
            }
            return this.findFrameChildForwards(navType, parent, index, sourceFrame);
        }
        if ("navigate down".equals(navType) || "navigate right".equals(navType)) {
            IPart p = this.findFrameChildForwards(navType, parent, index, sourceFrame);
            if (p != null) {
                return p;
            }
            return this.findFrameChildBackwards(navType, parent, index, sourceFrame);
        }
        return null;
    }

    private IPart findFrameChildForwards(String navType, IPart parent, int index, FramePart sourceFrame) {
        List children = parent.getChildren();
        int i = index + 1;
        while (i < children.size()) {
            FramePart frame;
            IPart p = (IPart)children.get(i);
            if (p instanceof FramePart && this.isNavFrame(navType, frame = (FramePart)p, sourceFrame)) {
                return frame;
            }
            ++i;
        }
        return null;
    }

    private IPart findFrameChildBackwards(String navType, IPart parent, int index, FramePart sourceFrame) {
        List children = parent.getChildren();
        int i = index - 1;
        while (i >= 0) {
            FramePart frame;
            IPart p = (IPart)children.get(i);
            if (p instanceof FramePart && this.isNavFrame(navType, frame = (FramePart)p, sourceFrame)) {
                return frame;
            }
            --i;
        }
        return null;
    }

    private boolean isNavFrame(String navType, FramePart frame, FramePart sourceFrame) {
        Rectangle bounds = frame.getFigure().getBounds();
        Rectangle sourceBounds = sourceFrame.getFigure().getBounds();
        if ("navigate up".equals(navType)) {
            int x = sourceBounds.x + sourceBounds.width / 2;
            return bounds.y < sourceBounds.y && bounds.bottom() < sourceBounds.bottom() && bounds.x < x && bounds.right() > x;
        }
        if ("navigate down".equals(navType)) {
            int x = sourceBounds.x + sourceBounds.width / 2;
            return bounds.y > sourceBounds.y && bounds.bottom() > sourceBounds.bottom() && bounds.x < x && bounds.right() > x;
        }
        if ("navigate left".equals(navType)) {
            int y = sourceBounds.y + sourceBounds.height / 2;
            return bounds.x < sourceBounds.x && bounds.right() < sourceBounds.right() && bounds.y < y && bounds.bottom() > y;
        }
        if ("navigate right".equals(navType)) {
            int y = sourceBounds.y + sourceBounds.height / 2;
            return bounds.x > sourceBounds.x && bounds.right() > sourceBounds.right() && bounds.y < y && bounds.bottom() > y;
        }
        return false;
    }

    private IPart findLastFrameChild(IPart parent) {
        List children = parent.getChildren();
        int i = children.size() - 1;
        while (i >= 0) {
            IPart p = (IPart)children.get(i);
            if (p instanceof FramePart) {
                return p;
            }
            --i;
        }
        return null;
    }

    private IPart findFirstFrameChild(IPart parent) {
        List children = parent.getChildren();
        int i = 0;
        while (i < children.size()) {
            IPart p = (IPart)children.get(i);
            if (p instanceof FramePart) {
                return p;
            }
            ++i;
        }
        return null;
    }

    private FramePart findSourceFrame(List<IPart> sources, String navType) {
        if (sources.isEmpty()) {
            return null;
        }
        IPart source = sources.get(0);
        return source instanceof FramePart ? (FramePart)source : null;
    }
}

