/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.ui.properties;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.properties.IPropertyPartContainer;
import org.xmind.gef.ui.properties.IPropertySectionPart;
import org.xmind.ui.forms.WidgetFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GraphicalPropertySheetPage
extends Page
implements IPropertySheetPage,
IPropertyPartContainer {
    private static final int DEFAULT_SECTION_WIDTH = 200;
    private final IGraphicalEditor editor;
    private List<SectionRec> sections = new ArrayList<SectionRec>();
    private Composite composite;
    private WidgetFactory widgetFactory;
    private ScrolledForm form;
    private Label titleBar;
    private Control titleSeparator;
    private String title;

    public GraphicalPropertySheetPage(IGraphicalEditor editor) {
        this.editor = editor;
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        for (SectionRec rec : this.sections) {
            rec.section.init(this, this.getContributedEditor());
        }
    }

    public IGraphicalEditor getContributedEditor() {
        return this.editor;
    }

    protected void addSection(String id, IPropertySectionPart section) {
        Assert.isNotNull((Object)id);
        Assert.isNotNull((Object)section);
        this.removeSection(id);
        SectionRec rec = new SectionRec(id, section);
        this.sections.add(rec);
        section.init(this, this.editor);
        if (this.form != null && !this.form.isDisposed()) {
            this.createSectionControl(this.form.getBody(), rec);
        }
    }

    protected void removeSection(String id) {
        SectionRec rec = this.getRec(id);
        if (rec == null) {
            return;
        }
        if (this.sections.remove(rec)) {
            rec.section.dispose();
            if (rec.control != null && !rec.control.isDisposed()) {
                rec.control.dispose();
            }
        }
    }

    protected boolean hasSection(String id) {
        return this.getRec(id) != null;
    }

    protected IPropertySectionPart getSection(String id) {
        SectionRec rec = this.getRec(id);
        return rec == null ? null : rec.section;
    }

    protected List<String> getSectionIds() {
        ArrayList<String> list = new ArrayList<String>(this.sections.size());
        for (SectionRec rec : this.sections) {
            list.add(rec.id);
        }
        return list;
    }

    protected List<String> getVisibleSectionIds() {
        ArrayList<String> list = new ArrayList<String>(this.sections.size());
        for (SectionRec rec : this.sections) {
            if (!rec.visible) continue;
            list.add(rec.id);
        }
        return list;
    }

    protected boolean isSectionVisible(String id) {
        SectionRec rec = this.getRec(id);
        return rec != null && rec.visible;
    }

    protected void setSectionVisible(String id, boolean visible) {
        SectionRec rec = this.getRec(id);
        if (rec == null || rec.visible == visible) {
            return;
        }
        rec.visible = visible;
        if (rec.control != null && !rec.control.isDisposed()) {
            GridData gd = (GridData)rec.control.getLayoutData();
            gd.exclude = !visible;
            rec.control.setVisible(visible);
        }
    }

    protected void reflow() {
        if (this.form != null && !this.form.isDisposed()) {
            this.form.reflow(true);
            this.form.getParent().layout();
        }
    }

    protected void moveSectionFirst(String id) {
        SectionRec rec = this.getRec(id);
        if (rec == null) {
            return;
        }
        this.moveSectionFirst(rec);
    }

    private void moveSectionFirst(SectionRec rec) {
        if (rec.control != null && !rec.control.isDisposed()) {
            rec.control.moveAbove(null);
            rec.control.getParent().layout();
        }
    }

    protected void moveSectionAfter(String id, String lastId) {
        SectionRec rec = this.getRec(id);
        if (rec == null) {
            return;
        }
        SectionRec lastRec = this.getRec(lastId);
        if (lastRec == null) {
            this.moveSectionFirst(rec);
        } else if (rec.control != null && !rec.control.isDisposed() && lastRec.control != null && !lastRec.control.isDisposed()) {
            rec.control.moveBelow((Control)lastRec.control);
            rec.control.getParent().layout();
        }
    }

    private SectionRec getRec(String id) {
        if (id == null) {
            return null;
        }
        for (SectionRec rec : this.sections) {
            if (!id.equals(rec.id)) continue;
            return rec;
        }
        return null;
    }

    public void createControl(Composite parent) {
        this.composite = new Composite(parent, 524288);
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        this.composite.setLayout((Layout)layout);
        this.titleBar = new Label(this.composite, 0);
        this.titleBar.setLayoutData((Object)new GridData(768));
        this.titleSeparator = new Label(this.composite, 258);
        this.titleSeparator.setLayoutData((Object)new GridData(768));
        this.widgetFactory = new WidgetFactory(this.composite.getDisplay());
        this.form = this.widgetFactory.createScrolledForm(this.composite);
        this.form.setLayoutData((Object)new GridData(1808));
        this.form.setMinWidth(200);
        this.form.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (GraphicalPropertySheetPage.this.widgetFactory != null) {
                    GraphicalPropertySheetPage.this.widgetFactory.dispose();
                    GraphicalPropertySheetPage.this.widgetFactory = null;
                }
            }
        });
        this.createSectionControls(this.form, this.form.getBody());
        this.form.reflow(true);
    }

    protected void createSectionControls(final ScrolledForm form, final Composite formBody) {
        GridLayout layout = new GridLayout(1, true);
        formBody.setLayout((Layout)layout);
        for (SectionRec rec : this.sections) {
            this.createSectionControl(formBody, rec);
        }
        form.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                GraphicalPropertySheetPage.this.relayout(form, formBody);
            }

            public void controlMoved(ControlEvent e) {
            }
        });
    }

    private void relayout(ScrolledForm form, Composite formBody) {
        boolean change;
        Rectangle area = form.getClientArea();
        GridLayout layout = (GridLayout)formBody.getLayout();
        int newNumColumns = Math.max(1, area.width / 200);
        boolean bl = change = newNumColumns != layout.numColumns && newNumColumns >= 0 && newNumColumns <= formBody.getChildren().length;
        if (change) {
            layout.numColumns = newNumColumns;
            formBody.layout();
        }
    }

    private void createSectionControl(Composite parent, SectionRec rec) {
        rec.control = this.widgetFactory.createSection(parent, 2370);
        Composite client = this.widgetFactory.createComposite((Composite)rec.control, 524352);
        rec.control.setClient((Control)client);
        GridData data = new GridData(768);
        data.verticalAlignment = 1;
        data.widthHint = 200;
        rec.control.setLayoutData((Object)data);
        rec.section.createControl(client);
        rec.visible = true;
        this.updateSectionTitle(rec);
    }

    @Override
    public void updateSectionTitle(IPropertySectionPart section) {
        SectionRec rec = this.findRecord(section);
        if (rec != null) {
            this.updateSectionTitle(rec);
        }
    }

    private SectionRec findRecord(IPropertySectionPart section) {
        for (SectionRec rec : this.sections) {
            if (rec.section != section) continue;
            return rec;
        }
        return null;
    }

    private void updateSectionTitle(SectionRec rec) {
        if (rec.control == null || rec.control.isDisposed()) {
            return;
        }
        String title = rec.section.getTitle();
        if (title == null) {
            title = "";
        }
        rec.control.setText(title);
    }

    public Control getControl() {
        return this.composite;
    }

    public void setFocus() {
        if (this.sections.isEmpty()) {
            if (this.form != null && !this.form.isDisposed()) {
                this.form.setFocus();
            } else if (this.composite != null && !this.composite.isDisposed()) {
                this.composite.setFocus();
            }
        } else {
            this.sections.get((int)0).section.setFocus();
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part != this.editor) {
            return;
        }
        this.selectionChanged(selection);
        if (this.composite != null && !this.composite.isDisposed()) {
            this.composite.setRedraw(false);
        }
        this.setSelectionToSections(selection);
        if (this.form != null && !this.form.isDisposed()) {
            this.refresh();
        }
        if (this.composite != null && !this.composite.isDisposed()) {
            this.composite.setRedraw(true);
        }
    }

    protected abstract void selectionChanged(ISelection var1);

    private void setSelectionToSections(ISelection selection) {
        for (SectionRec rec : this.sections) {
            if (!rec.visible) continue;
            rec.section.setSelection(selection);
            this.updateSectionTitle(rec);
        }
    }

    private void updateTitleBar() {
        if (this.titleBar == null || this.titleBar.isDisposed()) {
            return;
        }
        String title = this.getTitle();
        this.titleBar.setText(title == null ? "" : title);
        this.setTitleVisible(title != null);
    }

    private void setTitleVisible(boolean visible) {
        if (this.titleBar == null || this.titleBar.isDisposed()) {
            return;
        }
        if (this.titleBar.getVisible() == visible) {
            return;
        }
        this.titleBar.setVisible(visible);
        ((GridData)this.titleBar.getLayoutData()).exclude = !visible;
        this.titleSeparator.setVisible(visible);
        ((GridData)this.titleSeparator.getLayoutData()).exclude = !visible;
        this.titleBar.getParent().layout();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        if (title == this.title || title != null && title.equals(this.title)) {
            return;
        }
        this.title = title;
        this.updateTitleBar();
    }

    @Override
    public IPageSite getContainerSite() {
        return this.getSite();
    }

    @Override
    public void refresh() {
        for (SectionRec rec : this.sections) {
            if (!rec.visible) continue;
            rec.section.refresh();
        }
        if (this.form != null && !this.form.isDisposed()) {
            this.form.reflow(true);
        }
    }

    public void dispose() {
        for (SectionRec rec : this.sections) {
            rec.section.dispose();
            rec.visible = false;
            rec.control = null;
        }
        if (this.composite != null) {
            this.composite.dispose();
            this.composite = null;
        }
        this.form = null;
        this.title = null;
        this.titleBar = null;
        this.titleSeparator = null;
        super.dispose();
    }

    protected static class SectionRec {
        String id;
        IPropertySectionPart section;
        Section control;
        boolean visible;

        public SectionRec(String id, IPropertySectionPart section) {
            this.id = id;
            this.section = section;
        }
    }
}

