/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.ui.editor;

import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.xmind.gef.ui.editor.PageContainerPresentationBase;

public class TabFolderContainerPresentation
extends PageContainerPresentationBase
implements SelectionListener {
    private CTabFolder container = null;

    public void addPage(Composite container, int index, Control pageControl) {
        CTabFolder tabFolder = (CTabFolder)container;
        CTabItem item = new CTabItem(tabFolder, 0, index);
        item.setControl(pageControl);
    }

    public Composite createContainer(Composite parent) {
        if (this.container != null && !this.container.isDisposed()) {
            return this.container;
        }
        parent.setLayout((Layout)new FillLayout());
        this.container = new CTabFolder(parent, 0x800400);
        if (this.hasListener()) {
            this.container.addSelectionListener((SelectionListener)this);
        }
        return this.container;
    }

    public void disposePage(Composite container, int pageIndex) {
        CTabItem item = this.getItem(container, pageIndex);
        Control pageControl = item.getControl();
        item.dispose();
        if (pageControl != null) {
            pageControl.dispose();
        }
    }

    private CTabItem getItem(Composite container, int pageIndex) {
        return ((CTabFolder)container).getItem(pageIndex);
    }

    public int getActivePage(Composite container) {
        CTabFolder tabFolder = (CTabFolder)container;
        if (tabFolder != null && !tabFolder.isDisposed()) {
            return tabFolder.getSelectionIndex();
        }
        return -1;
    }

    public Control getPageControl(Composite container, int pageIndex) {
        return this.getItem(container, pageIndex).getControl();
    }

    public int getPageCount(Composite container) {
        CTabFolder tabFolder = (CTabFolder)container;
        return tabFolder.getItemCount();
    }

    public Image getPageImage(Composite container, int pageIndex) {
        return this.getItem(container, pageIndex).getImage();
    }

    public String getPageText(Composite container, int pageIndex) {
        return this.getItem(container, pageIndex).getText();
    }

    public void setActivePage(Composite container, int pageIndex) {
        ((CTabFolder)container).setSelection(pageIndex);
    }

    public void setPageControl(Composite container, int pageIndex, Control pageControl) {
        this.getItem(container, pageIndex).setControl(pageControl);
    }

    public void setPageImage(Composite container, int pageIndex, Image image) {
        this.getItem(container, pageIndex).setImage(image);
    }

    public void setPageText(Composite container, int pageIndex, String text) {
        this.getItem(container, pageIndex).setText(text);
    }

    public Object getSelectedPage() {
        return this.getActivePage((Composite)this.container);
    }

    public void addPageChangedListener(IPageChangedListener listener) {
        boolean hadListener = this.hasListener();
        super.addPageChangedListener(listener);
        boolean hasListener = this.hasListener();
        if (!hadListener && hasListener && this.container != null && !this.container.isDisposed()) {
            this.container.addSelectionListener((SelectionListener)this);
        }
    }

    public void removePageChangedListener(IPageChangedListener listener) {
        boolean hadListener = this.hasListener();
        super.removePageChangedListener(listener);
        boolean hasListener = this.hasListener();
        if (hadListener && !hasListener && this.container != null && !this.container.isDisposed()) {
            this.container.removeSelectionListener((SelectionListener)this);
        }
    }

    public int findPage(Composite container, int x, int y) {
        CTabItem item = ((CTabFolder)container).getItem(new Point(x, y));
        if (item != null) {
            return ((CTabFolder)container).indexOf(item);
        }
        return -1;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        this.firePageChangedEvent();
    }
}

