/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.ui.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiGraphicalPageSelectionProvider
implements IPostSelectionProvider,
ISelectionChangedListener {
    private List<ISelectionChangedListener> listeners = new ArrayList<ISelectionChangedListener>();
    private List<ISelectionChangedListener> postListeners = new ArrayList<ISelectionChangedListener>();
    private IGraphicalEditorPage activePage = null;

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        this.postListeners.add(listener);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        this.postListeners.remove(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void setActivePage(IGraphicalEditorPage page) {
        ISelectionProvider selectionProvider;
        if (page == this.activePage) {
            return;
        }
        if (this.activePage != null && (selectionProvider = this.activePage.getSelectionProvider()) != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        this.activePage = page;
        if (page != null && (selectionProvider = page.getSelectionProvider()) != null) {
            selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
        }
        this.fireSelectionChangedEvent(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
    }

    protected void fireSelectionChangedEvent(SelectionChangedEvent event) {
        this.fireSelectionChangedEvent(new SelectionChangedEvent((ISelectionProvider)this, event.getSelection()), this.listeners);
    }

    protected void firePostSelectionChangedEvent(SelectionChangedEvent event) {
        this.fireSelectionChangedEvent(new SelectionChangedEvent((ISelectionProvider)this, event.getSelection()), this.postListeners);
    }

    private void fireSelectionChangedEvent(SelectionChangedEvent event, List<ISelectionChangedListener> listeners) {
        Object[] objectArray = listeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ISelectionChangedListener)listener).selectionChanged(event);
            ++n2;
        }
    }

    public ISelection getSelection() {
        ISelectionProvider selectionProvider;
        if (this.activePage != null && (selectionProvider = this.activePage.getSelectionProvider()) != null) {
            return selectionProvider.getSelection();
        }
        return StructuredSelection.EMPTY;
    }

    public void setSelection(ISelection selection) {
        ISelectionProvider selectionProvider;
        if (this.activePage != null && (selectionProvider = this.activePage.getSelectionProvider()) != null) {
            selectionProvider.setSelection(selection);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        event = new SelectionChangedEvent((ISelectionProvider)this, event.getSelection());
        this.fireSelectionChangedEvent(event);
    }
}

