/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.ui.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.actions.RetargetAction;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.xmind.gef.ui.actions.ActionRegistry;
import org.xmind.gef.ui.actions.IActionRegistry;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;

public abstract class GraphicalEditorActionBarContributor
extends EditorActionBarContributor {
    private IActionRegistry actionRegistry = new ActionRegistry();
    private List<RetargetAction> retargetActions = new ArrayList<RetargetAction>();
    private List<String> globalActionIds = new ArrayList<String>();

    public void init(IActionBars bars) {
        this.makeActions();
        this.declareGlobalActionIds();
        super.init(bars);
    }

    protected abstract void makeActions();

    protected abstract void declareGlobalActionIds();

    protected void addAction(IAction action) {
        this.actionRegistry.addAction(action);
    }

    protected void addRetargetAction(RetargetAction action) {
        String actionId = action.getId();
        Assert.isNotNull((Object)actionId, (String)("Retarget action must have an ID before added: " + action.toString()));
        this.addAction((IAction)action);
        this.retargetActions.add(action);
        this.getPage().addPartListener((IPartListener)action);
        this.addGlobalActionId(actionId);
    }

    protected void addGlobalActionId(String actionId) {
        this.globalActionIds.add(actionId);
    }

    public void setActiveEditor(IEditorPart targetEditor) {
        IGraphicalEditorPage activePage = null;
        if (targetEditor instanceof IGraphicalEditor) {
            activePage = ((IGraphicalEditor)targetEditor).getActivePageInstance();
        }
        this.activePageChanged(activePage);
        this.updateActionBars(targetEditor, activePage);
    }

    private void updateActionBars(IEditorPart editor, IGraphicalEditorPage page) {
        IActionRegistry editorActions = GraphicalEditorActionBarContributor.getActionRegistry((IAdaptable)editor);
        IActionRegistry pageActions = GraphicalEditorActionBarContributor.getActionRegistry(page);
        IActionBars bars = this.getActionBars();
        for (String actionId : this.globalActionIds) {
            IAction handler = this.findHandler(actionId, pageActions, editorActions);
            bars.setGlobalActionHandler(actionId, handler);
        }
        bars.updateActionBars();
    }

    private static IActionRegistry getActionRegistry(IAdaptable adaptable) {
        if (adaptable != null) {
            return (IActionRegistry)adaptable.getAdapter(IActionRegistry.class);
        }
        return null;
    }

    private IAction findHandler(String actionId, IActionRegistry pageActions, IActionRegistry editorActions) {
        IAction action;
        if (pageActions != null && (action = pageActions.getAction(actionId)) != null) {
            return action;
        }
        if (editorActions != null && (action = editorActions.getAction(actionId)) != null) {
            return action;
        }
        return null;
    }

    public void setActivePage(IGraphicalEditorPage page) {
        this.activePageChanged(page);
        IGraphicalEditor editor = page == null ? null : page.getParentEditor();
        this.updateActionBars(editor, page);
    }

    protected abstract void activePageChanged(IGraphicalEditorPage var1);

    protected void setGlobalHandlers(IActionRegistry actionRegistry) {
        IActionBars bars = this.getActionBars();
        for (String id : this.globalActionIds) {
            IAction action = actionRegistry.getAction(id);
            if (action == null) continue;
            bars.setGlobalActionHandler(id, action);
        }
    }

    protected IActionRegistry getActionRegistry() {
        return this.actionRegistry;
    }

    public IAction getAction(String actionId) {
        return this.getActionRegistry().getAction(actionId);
    }

    public void contributeToContentPopupMenu(IMenuManager menu) {
        menu.add((IContributionItem)new GroupMarker("additions"));
    }

    public void contributeToPagePopupMenu(IMenuManager menu) {
        menu.add((IContributionItem)new GroupMarker("additions"));
    }

    public void dispose() {
        if (this.retargetActions != null) {
            for (RetargetAction action : this.retargetActions) {
                this.getPage().removePartListener((IPartListener)action);
                action.dispose();
            }
            this.retargetActions = null;
        }
        if (this.actionRegistry != null) {
            this.actionRegistry.dispose();
            this.actionRegistry = null;
        }
        super.dispose();
    }
}

