/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.ui.actions;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.actions.ActionFactory;
import org.xmind.gef.IDisposable;
import org.xmind.gef.ui.actions.IActionRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionRegistry
implements IActionRegistry {
    private Map<Object, IAction> actions = new HashMap<Object, IAction>();
    private IActionRegistry parent;

    public ActionRegistry() {
    }

    public ActionRegistry(IActionRegistry parent) {
        this.setParent(parent);
    }

    public void dispose() {
        for (IAction action : this.getActions()) {
            if (action instanceof IDisposable) {
                ((IDisposable)action).dispose();
                continue;
            }
            if (!(action instanceof ActionFactory.IWorkbenchAction)) continue;
            ((ActionFactory.IWorkbenchAction)action).dispose();
        }
    }

    @Override
    public IAction getAction(String id) {
        IAction action = this.actions.get(id);
        if (action == null && this.parent != null) {
            action = this.parent.getAction(id);
        }
        return action;
    }

    @Override
    public Collection<IAction> getActions() {
        return this.actions.values();
    }

    @Override
    public void addAction(IAction action) {
        String id = action.getId();
        Assert.isNotNull((Object)id, (String)("Action must have an ID before registering: " + action.toString()));
        this.setAction(id, action);
    }

    public void setAction(String actionId, IAction action) {
        if (action == null) {
            this.actions.remove(actionId);
        } else {
            this.actions.put(actionId, action);
        }
    }

    @Override
    public void removeAction(IAction action) {
        this.removeAction(action.getId());
    }

    @Override
    public void removeAction(String actionId) {
        this.actions.remove(actionId);
    }

    @Override
    public IActionRegistry getParent() {
        return this.parent;
    }

    @Override
    public void setParent(IActionRegistry parent) {
        this.parent = parent;
    }
}

