/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.browser;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.xmind.ui.internal.browser.BrowserMessages;
import org.xmind.ui.internal.browser.BrowserSupportImpl;
import org.xmind.ui.internal.browser.BrowserUtil;
import org.xmind.ui.internal.browser.InternalBrowser;

public class DefaultBrowser
extends InternalBrowser {
    private IWebBrowser externalWorkbenchBrowser = null;

    public DefaultBrowser(BrowserSupportImpl support, String clientId) {
        super(support, clientId, false);
    }

    public void openURL(String url) throws PartInitException {
        try {
            this.doOpenURL(url);
        }
        catch (PartInitException partInitException) {
            try {
                this.doOpenURLByWorkbenchBrowser(url);
            }
            catch (PartInitException partInitException2) {
                this.openExternal(url);
            }
        }
    }

    private void openExternal(String url) {
        try {
            this.doOpenURLByExternalWorkbenchBrowser(url);
        }
        catch (PartInitException partInitException) {
            this.doOpenURLByDefault(url);
        }
    }

    private void doOpenURLByExternalWorkbenchBrowser(String url) throws PartInitException {
        try {
            URL theURL = new URL(url);
            this.getExternalWorkbenchBrowser().openURL(theURL);
        }
        catch (MalformedURLException malformedURLException) {
            throw new PartInitException(BrowserMessages.InternalWebBrowser_ErrorCouldNotLaunchWebBrowser_message);
        }
    }

    private IWebBrowser getExternalWorkbenchBrowser() throws PartInitException {
        if (this.externalWorkbenchBrowser == null) {
            this.externalWorkbenchBrowser = this.createExternalWorkbenchBrowser();
        }
        return this.externalWorkbenchBrowser;
    }

    protected IWebBrowser createExternalWorkbenchBrowser() throws PartInitException {
        return PlatformUI.getWorkbench().getBrowserSupport().createBrowser(134, this.getClientId(), this.getName(), this.getTooltip());
    }

    protected void doOpenURLByDefault(String url) {
        BrowserUtil.gotoUrl(url);
    }
}

