/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.browser;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.xmind.ui.internal.browser.BrowserPlugin;
import org.xmind.ui.internal.browser.BrowserUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserPref {
    protected static final String PREF_INTERNAL_WEB_BROWSER_HISTORY = "internalWebBrowserHistory";
    protected static final String PREF_BROWSER_CHOICE = "browserChoice";
    public static final int INTERNAL = 0;
    public static final int EXTERNAL = 1;

    private BrowserPref() {
    }

    protected static IPreferenceStore getPreferenceStore() {
        return BrowserPlugin.getDefault().getPreferenceStore();
    }

    public static List<String> getInternalWebBrowserHistory() {
        String temp = BrowserPref.getPreferenceStore().getString(PREF_INTERNAL_WEB_BROWSER_HISTORY);
        StringTokenizer st = new StringTokenizer(temp, "|*|");
        ArrayList<String> l = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            l.add(s);
        }
        return l;
    }

    public static void setInternalWebBrowserHistory(List<String> list) {
        StringBuffer sb = new StringBuffer();
        if (list != null) {
            for (String s : list) {
                sb.append(s);
                sb.append("|*|");
            }
        }
        BrowserPref.getPreferenceStore().setValue(PREF_INTERNAL_WEB_BROWSER_HISTORY, sb.toString());
        BrowserPlugin.getDefault().savePluginPreferences();
    }

    public static boolean isDefaultUseInternalBrowser() {
        return BrowserUtil.canUseInternalWebBrowser();
    }

    public static boolean isDefaultUseSystemBrowser() {
        return BrowserUtil.canUseSystemBrowser();
    }

    public static int getBrowserChoice() {
        int choice = BrowserPref.getPreferenceStore().getInt(PREF_BROWSER_CHOICE);
        if (choice == 2) {
            return 1;
        }
        if (choice == 0 && !BrowserUtil.canUseInternalWebBrowser()) {
            return 1;
        }
        return choice;
    }

    public static void setBrowserChoice(int choice) {
        BrowserPref.getPreferenceStore().setValue(PREF_BROWSER_CHOICE, choice);
        BrowserPlugin.getDefault().savePluginPreferences();
    }
}

