/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.browser;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.xmind.ui.internal.browser.BrowserImages;
import org.xmind.ui.internal.browser.BrowserMessages;

public class BrowserEditorInput
implements IEditorInput,
IPersistableElement,
IElementFactory {
    private static final String ELEMENT_FACTORY_ID = "org.xmind.ui.browser.elementFactory";
    private static final String TAG_URL = "url";
    private static final String TAG_NAME = "name";
    private static final String TAG_TOOLTIP = "tooltip";
    private static final String TAG_CLIENT_ID = "clientId";
    private String url;
    private String name;
    private String tooltip;
    private String clientId;

    public BrowserEditorInput(String url) {
        this(url, null);
    }

    public BrowserEditorInput(String url, String clientId) {
        this.url = url;
        this.clientId = clientId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getURL() {
        return this.url;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setToolTipText(String tooltip) {
        this.tooltip = tooltip;
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return BrowserImages.getImageDescriptor("icons/browser.gif");
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return BrowserMessages.BrowserEditor_title;
    }

    boolean isNameLocked() {
        return this.name != null;
    }

    public IPersistableElement getPersistable() {
        return this;
    }

    public String getToolTipText() {
        if (this.tooltip != null) {
            return this.tooltip;
        }
        if (this.url != null) {
            return this.url;
        }
        return BrowserMessages.BrowserEditor_title;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public String getFactoryId() {
        return ELEMENT_FACTORY_ID;
    }

    public void saveState(IMemento memento) {
        if (this.url != null) {
            memento.putString(TAG_URL, this.url);
        }
        if (this.name != null) {
            memento.putString(TAG_NAME, this.name);
        }
        if (this.tooltip != null) {
            memento.putString(TAG_TOOLTIP, this.tooltip);
        }
        if (this.clientId != null) {
            memento.putString(TAG_CLIENT_ID, this.clientId);
        }
    }

    public IAdaptable createElement(IMemento memento) {
        String url = memento.getString(TAG_URL);
        String name = memento.getString(TAG_NAME);
        String tooltip = memento.getString(TAG_TOOLTIP);
        String clientId = memento.getString(TAG_CLIENT_ID);
        BrowserEditorInput input = new BrowserEditorInput(url, clientId);
        input.setName(name);
        input.setToolTipText(tooltip);
        return input;
    }

    public String toString() {
        return "BrowserEditorInput[" + this.url + "]";
    }

    public boolean canReplaceInput(BrowserEditorInput input) {
        return this.clientId != null && this.clientId.equals(input.clientId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof BrowserEditorInput)) {
            return false;
        }
        BrowserEditorInput that = (BrowserEditorInput)obj;
        if (this.url != null && !this.url.equals(that.url)) {
            return false;
        }
        return this.canReplaceInput(that);
    }
}

