/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.tool;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.xmind.gef.part.IPart;

public class PartTextSelection
extends TextSelection {
    private IPart part;
    private IDocument cachedDocument;

    public PartTextSelection(int offset, int length) {
        this(null, null, offset, length);
        this.cachedDocument = null;
    }

    public PartTextSelection(IPart part, int offset, int length) {
        this(part, null, offset, length);
        this.cachedDocument = null;
    }

    public PartTextSelection(IDocument document, int offset, int length) {
        this(null, document, offset, length);
        this.cachedDocument = document;
    }

    public PartTextSelection(IPart part, IDocument document, int offset, int length) {
        super(document, offset, length);
        this.part = part;
        this.cachedDocument = document;
    }

    public IPart getPart() {
        return this.part;
    }

    public IDocument getDocument() {
        return this.cachedDocument;
    }

    public boolean equals(Object obj) {
        boolean sameRange;
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PartTextSelection)) {
            return false;
        }
        PartTextSelection that = (PartTextSelection)((Object)obj);
        if (this.part != that.part) {
            return false;
        }
        boolean bl = sameRange = this.getOffset() == that.getOffset() && this.getLength() == that.getLength();
        if (sameRange) {
            if (that.cachedDocument == null && this.cachedDocument == null) {
                return true;
            }
            if (that.cachedDocument == null || this.cachedDocument == null) {
                return false;
            }
            try {
                String sContent = that.cachedDocument.get(that.getOffset(), that.getLength());
                String content = this.cachedDocument.get(this.getOffset(), this.getLength());
                return sContent.equals(content);
            }
            catch (BadLocationException badLocationException) {}
        }
        return false;
    }

    public int hashCode() {
        int low = this.cachedDocument != null ? this.cachedDocument.hashCode() : 0;
        return this.getOffset() << 24 | this.getLength() << 16 | (low ^= this.part != null ? this.part.hashCode() : 0);
    }

    public String toString() {
        return "[part=" + this.part + ", <" + this.getOffset() + "," + this.getLength() + ">=" + this.getText() + "]";
    }
}

