/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.service;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Display;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.draw2d.geometry.Geometry;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.service.GraphicalViewerService;
import org.xmind.gef.service.IRevealService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ZoomingAndPanningRevealService
extends GraphicalViewerService
implements IRevealService {
    private static final int INTERVALS = 30;
    private boolean autoRevealSelection;
    private ISelectionChangedListener selectionChangedListener;
    private int duration = 200;
    private int delay = 100;
    private RevealJob job = null;

    protected ZoomingAndPanningRevealService(IGraphicalViewer viewer, boolean autoRevealSelection) {
        super(viewer);
        this.autoRevealSelection = autoRevealSelection;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    protected boolean isAnimationEnabled() {
        return true;
    }

    @Override
    protected void activate() {
        if (this.autoRevealSelection) {
            if (this.selectionChangedListener == null) {
                this.selectionChangedListener = new ViewerSelectionChangedListener();
            }
            this.getViewer().addSelectionChangedListener(this.selectionChangedListener);
        }
    }

    @Override
    protected void deactivate() {
        if (this.selectionChangedListener != null) {
            this.getViewer().removeSelectionChangedListener(this.selectionChangedListener);
        }
    }

    @Override
    public void reveal(ISelection selection) {
        if (!this.isActive()) {
            return;
        }
        this.startReveal(selection);
    }

    protected void startReveal(ISelection selection) {
        List<IGraphicalPart> toReveal;
        if (this.job != null) {
            this.job.cancel();
            this.job = null;
        }
        if ((toReveal = this.collectPartsToReveal(selection)) != null && !toReveal.isEmpty()) {
            Display display = Display.getCurrent();
            this.job = new RevealJob(display, toReveal);
            display.timerExec(this.delay, (Runnable)this.job);
            this.revealJobStarted(toReveal);
        }
    }

    protected abstract double calcTargetScale(List<IGraphicalPart> var1, Rectangle var2);

    protected abstract PrecisionPoint calcTargetCenter(List<IGraphicalPart> var1, Rectangle var2, double var3);

    protected Rectangle getRevealBounds(List<IGraphicalPart> parts) {
        Rectangle r = null;
        for (IGraphicalPart p : parts) {
            r = Geometry.union(r, this.getRevealBounds(p));
        }
        return r;
    }

    protected Rectangle getRevealBounds(IGraphicalPart p) {
        return p.getFigure().getBounds();
    }

    protected double getViewerScale() {
        return this.getViewer().getZoomManager().getScale();
    }

    protected PrecisionPoint getViewerCenterPoint(double scale) {
        return new PrecisionPoint(this.getViewer().getCenterPoint()).scale(1.0 / scale);
    }

    private List<IGraphicalPart> collectPartsToReveal(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            ArrayList<IGraphicalPart> list = new ArrayList<IGraphicalPart>(ss.size());
            for (Object o : ss.toList()) {
                IGraphicalPart p = this.getViewer().findGraphicalPart(o);
                if (p == null || this.exclude(p)) continue;
                list.add(p);
            }
            return list;
        }
        return null;
    }

    protected boolean exclude(IGraphicalPart part) {
        return false;
    }

    private void handleViewerSelectionChanged(ISelection selection) {
        this.reveal(selection);
    }

    protected void finishCurrentJob() {
        if (this.job != null) {
            this.job.finish();
            this.job = null;
        }
    }

    protected void cancelCurrentJob() {
        if (this.job != null) {
            this.job.cancel();
            this.job = null;
        }
    }

    protected void revealJobStarted(List<IGraphicalPart> toReveal) {
    }

    protected void revealJobCanceled(List<IGraphicalPart> toReveal) {
    }

    protected void revealJobFinished(List<IGraphicalPart> toReveal) {
        Rectangle revealBounds = this.getRevealBounds(toReveal);
        if (revealBounds == null) {
            return;
        }
        double targetScale = this.calcTargetScale(toReveal, revealBounds);
        PrecisionPoint targetCenter = this.calcTargetCenter(toReveal, revealBounds, targetScale);
        if (targetScale > 0.0) {
            this.getViewer().getZoomManager().setScale(targetScale);
        }
        if (targetCenter != null) {
            this.getViewer().center(targetCenter.getScaled(this.getViewerScale()).toRoundedDraw2DPoint());
        }
    }

    protected void doStep(List<IGraphicalPart> toReveal, Rectangle revealBounds, int remainingSteps) {
        double scale = this.getViewerScale();
        PrecisionPoint center = this.getViewerCenterPoint(scale);
        double targetScale = this.calcTargetScale(toReveal, revealBounds);
        PrecisionPoint targetCenter = this.calcTargetCenter(toReveal, revealBounds, targetScale);
        if (targetScale > 0.0) {
            double remainingScale = targetScale - scale;
            double stepScale = remainingScale / (double)remainingSteps;
            scale += stepScale;
        }
        if (targetCenter != null) {
            double horizontalOffset = targetCenter.x - center.x;
            double verticalOffset = targetCenter.y - center.y;
            double stepX = horizontalOffset / (double)remainingSteps;
            double stepY = verticalOffset / (double)remainingSteps;
            center.x += stepX;
            center.y += stepY;
        }
        if (targetScale > 0.0) {
            this.getViewer().getZoomManager().setScale(scale);
        }
        if (targetCenter != null) {
            this.getViewer().center(center.getScaled(this.getViewerScale()).toRoundedDraw2DPoint());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RevealJob
    implements Runnable {
        private Display display;
        private List<IGraphicalPart> toReveal;
        private long startTime = -1L;
        private boolean canceled = false;
        private int elapsedSteps = -1;

        public RevealJob(Display display, List<IGraphicalPart> toReveal) {
            this.display = display;
            this.toReveal = toReveal;
        }

        public void cancel() {
            boolean oldCanceled = this.canceled;
            this.setCanceled();
            if (!oldCanceled) {
                ZoomingAndPanningRevealService.this.revealJobCanceled(this.toReveal);
            }
        }

        private void setCanceled() {
            this.canceled = true;
        }

        @Override
        public void run() {
            if (this.canceled) {
                return;
            }
            if (ZoomingAndPanningRevealService.this.getViewer().getControl() == null || ZoomingAndPanningRevealService.this.getViewer().getControl().isDisposed()) {
                this.setCanceled();
                return;
            }
            if (!ZoomingAndPanningRevealService.this.isAnimationEnabled()) {
                this.finish();
                return;
            }
            long currentTime = System.currentTimeMillis();
            if (this.startTime < 0L) {
                this.startTime = currentTime;
            }
            int elapsedTime = (int)(currentTime - this.startTime);
            int remainingTime = ZoomingAndPanningRevealService.this.getDuration() - elapsedTime;
            if (remainingTime <= 0) {
                this.finish();
                return;
            }
            double intervals = 30.0;
            if (this.elapsedSteps < 0) {
                this.elapsedSteps = 0;
                intervals += 20.0;
            } else {
                intervals += (double)(currentTime - this.startTime - (long)(30 * this.elapsedSteps)) / (double)this.elapsedSteps;
            }
            int remainingSteps = (int)(((double)remainingTime + intervals - 1.0) / intervals);
            if (remainingSteps <= 0) {
                this.finish();
                return;
            }
            Rectangle revealBounds = ZoomingAndPanningRevealService.this.getRevealBounds(this.toReveal);
            if (revealBounds == null) {
                this.cancel();
                return;
            }
            ZoomingAndPanningRevealService.this.doStep(this.toReveal, revealBounds, remainingSteps);
            this.display.timerExec(30, (Runnable)this);
            ++this.elapsedSteps;
        }

        public void finish() {
            this.setCanceled();
            ZoomingAndPanningRevealService.this.revealJobFinished(this.toReveal);
        }
    }

    private class ViewerSelectionChangedListener
    implements ISelectionChangedListener {
        private ViewerSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ZoomingAndPanningRevealService.this.handleViewerSelectionChanged(event.getSelection());
        }
    }
}

