/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.image;

import org.eclipse.draw2d.FreeformFigure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.image.IExportAreaProvider;

public class ExportAreaProvider
implements IExportAreaProvider {
    protected final IFigure figure;
    protected final Rectangle sourceArea;
    protected final int constrainedWidth;
    protected final int constrainedHeight;
    protected final Insets margins;
    protected Rectangle exportArea = null;
    protected double scale = -1.0;

    public ExportAreaProvider(IFigure figure, Rectangle sourceArea, int constrainedWidth, int constrainedHeight, Insets margins) {
        this.figure = figure;
        this.sourceArea = sourceArea == null ? null : new Rectangle(sourceArea);
        this.constrainedWidth = constrainedWidth;
        this.constrainedHeight = constrainedHeight;
        this.margins = margins == null ? new Insets() : new Insets(margins);
    }

    public IFigure getFigure() {
        return this.figure;
    }

    public Insets getMargins() {
        return this.margins;
    }

    public Rectangle getExportArea() {
        if (this.exportArea == null) {
            this.exportArea = new Rectangle(this.getSourceArea(this.figure));
            this.adjustExportArea();
        }
        return this.exportArea;
    }

    public double getScale() {
        this.getExportArea();
        return this.scale;
    }

    protected Rectangle getSourceArea(IFigure figure) {
        if (this.sourceArea != null) {
            return this.sourceArea;
        }
        if (figure instanceof FreeformFigure) {
            return ((FreeformFigure)figure).getFreeformExtent();
        }
        return figure.getBounds();
    }

    protected void adjustExportArea() {
        this.exportArea.expand(this.margins);
    }
}

