/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.draw2d.graphics;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.PathData;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.TextLayout;
import org.xmind.gef.draw2d.graphics.GradientPattern;
import org.xmind.gef.draw2d.graphics.ImagePattern;

public class Rotate90Graphics
extends Graphics {
    private Graphics real;
    private Pattern lastBgPattern = null;
    private Pattern lastFgPattern = null;

    public Rotate90Graphics(Graphics realGraphics) {
        this.real = realGraphics;
    }

    protected Graphics getGraphics() {
        return this.real;
    }

    protected float[] rotate(float x, float y) {
        return new float[]{-y, x};
    }

    protected int[] rotate(int x, int y) {
        return new int[]{-y, x};
    }

    protected Rectangle rotate(Rectangle r) {
        return new Rectangle(-r.y - r.height, r.x, r.height, r.width);
    }

    protected Point rotate(Point p) {
        return new Point(-p.y, p.x);
    }

    protected Path rotate(Path path) {
        PathData data = path.getPathData();
        Path newPath = new Path(path.getDevice());
        int index = 0;
        float[] points = data.points;
        byte[] byArray = data.types;
        int n = data.types.length;
        int n2 = 0;
        while (n2 < n) {
            byte type = byArray[n2];
            switch (type) {
                case 1: {
                    float x = points[index++];
                    float y = points[index++];
                    newPath.moveTo(-y, x);
                    break;
                }
                case 2: {
                    float x = points[index++];
                    float y = points[index++];
                    newPath.lineTo(-y, x);
                    break;
                }
                case 4: {
                    float x = points[index++];
                    float y = points[index++];
                    float cx1 = points[index++];
                    float cy1 = points[index++];
                    float cx2 = points[index++];
                    float cy2 = points[index++];
                    newPath.cubicTo(-y, x, -cy1, cx1, -cy2, cx2);
                    break;
                }
                case 3: {
                    float x = points[index++];
                    float y = points[index++];
                    float cx1 = points[index++];
                    float cy1 = points[index++];
                    newPath.quadTo(-y, x, -cy1, cx1);
                    break;
                }
                case 5: {
                    newPath.close();
                }
            }
            ++n2;
        }
        return newPath;
    }

    protected int[] rotate(int[] points) {
        int[] newPoints = new int[points.length];
        int i = 0;
        while (i < points.length) {
            newPoints[i] = -points[i + 1];
            newPoints[i + 1] = points[i];
            i += 2;
        }
        return newPoints;
    }

    protected PointList rotate(PointList points) {
        int size = points.size();
        PointList newPoints = new PointList(size);
        int i = 0;
        while (i < size) {
            Point p = points.getPoint(i);
            newPoints.setPoint(this.rotate(p), i);
            ++i;
        }
        return newPoints;
    }

    private Pattern rotate(GradientPattern p) {
        GradientPattern p2 = new GradientPattern(p.getDevice(), -p.y1, p.x1, -p.y2, p.x2, p.color1, p.alpha1, p.color2, p.alpha2);
        return p2;
    }

    private Pattern rotate(ImagePattern p) {
        ImagePattern p2 = new ImagePattern(p.getDevice(), this.rotate(p.image));
        return p2;
    }

    private Image rotate(Image image) {
        return image;
    }

    public void clipRect(Rectangle r) {
        this.real.clipRect(this.rotate(r));
    }

    public void dispose() {
        if (this.lastBgPattern != null) {
            this.lastBgPattern.dispose();
            this.lastBgPattern = null;
        }
        if (this.lastFgPattern != null) {
            this.lastFgPattern.dispose();
            this.lastFgPattern = null;
        }
    }

    public void drawArc(int x, int y, int w, int h, int offset, int length) {
        this.real.drawArc(-y - h, x, h, w, offset, length);
    }

    public void drawFocus(int x, int y, int w, int h) {
        this.real.drawFocus(-y - h, x, h, w);
    }

    public void drawImage(Image srcImage, int x1, int y1, int w1, int h1, int x2, int y2, int w2, int h2) {
        boolean statePushed = false;
        try {
            this.real.pushState();
            statePushed = true;
        }
        catch (Throwable throwable) {
            statePushed = false;
        }
        this.real.rotate(90.0f);
        this.real.drawImage(srcImage, x1, y1, w1, h1, x2, y2, w2, h2);
        this.real.rotate(-90.0f);
        if (statePushed) {
            try {
                this.real.restoreState();
                this.real.popState();
            }
            catch (Throwable throwable) {}
        }
    }

    public void drawImage(Image srcImage, int x, int y) {
        boolean statePushed = false;
        try {
            this.real.pushState();
            statePushed = true;
        }
        catch (Throwable throwable) {
            statePushed = false;
        }
        this.real.rotate(90.0f);
        this.real.drawImage(srcImage, x, y);
        this.real.rotate(-90.0f);
        if (statePushed) {
            try {
                this.real.restoreState();
                this.real.popState();
            }
            catch (Throwable throwable) {}
        }
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.real.drawLine(-y1, x1, -y2, x2);
    }

    public void drawOval(int x, int y, int w, int h) {
        this.real.drawOval(-y - h, x, h, w);
    }

    public void drawPath(Path path) {
        Path p2 = this.rotate(path);
        this.real.drawPath(p2);
        p2.dispose();
    }

    public void drawPoint(int x, int y) {
        this.real.drawPoint(-y, x);
    }

    public void drawPolygon(int[] points) {
        this.real.drawPolygon(this.rotate(points));
    }

    public void drawPolygon(PointList points) {
        this.real.drawPolygon(this.rotate(points));
    }

    public void drawPolyline(int[] points) {
        this.real.drawPolyline(this.rotate(points));
    }

    public void drawPolyline(PointList points) {
        this.real.drawPolyline(this.rotate(points));
    }

    public void drawRectangle(int x, int y, int width, int height) {
        this.real.drawRectangle(-y - height, x, height, width);
    }

    public void drawRoundRectangle(Rectangle r, int arcWidth, int arcHeight) {
        this.real.drawRoundRectangle(this.rotate(r), arcHeight, arcWidth);
    }

    public void drawString(String s, int x, int y) {
        boolean statePushed = false;
        try {
            this.real.pushState();
            statePushed = true;
        }
        catch (Throwable throwable) {
            statePushed = false;
        }
        this.real.rotate(90.0f);
        this.real.drawString(s, x, y);
        this.real.rotate(-90.0f);
        if (statePushed) {
            try {
                this.real.restoreState();
                this.real.popState();
            }
            catch (Throwable throwable) {}
        }
    }

    public void drawText(String s, int x, int y, int style) {
        boolean statePushed = false;
        try {
            this.real.pushState();
            statePushed = true;
        }
        catch (Throwable throwable) {
            statePushed = false;
        }
        this.real.rotate(90.0f);
        this.real.drawText(s, x, y, style);
        this.real.rotate(-90.0f);
        if (statePushed) {
            try {
                this.real.restoreState();
                this.real.popState();
            }
            catch (Throwable throwable) {}
        }
    }

    public void drawText(String s, int x, int y) {
        boolean statePushed = false;
        try {
            this.real.pushState();
            statePushed = true;
        }
        catch (Throwable throwable) {
            statePushed = false;
        }
        this.real.rotate(90.0f);
        this.real.drawText(s, x, y);
        this.real.rotate(-90.0f);
        if (statePushed) {
            try {
                this.real.restoreState();
                this.real.popState();
            }
            catch (Throwable throwable) {}
        }
    }

    public void drawTextLayout(TextLayout layout, int x, int y, int selectionStart, int selectionEnd, Color selectionForeground, Color selectionBackground) {
        boolean statePushed = false;
        try {
            this.real.pushState();
            statePushed = true;
        }
        catch (Throwable throwable) {
            statePushed = false;
        }
        this.real.rotate(90.0f);
        this.real.drawTextLayout(layout, x, y, selectionStart, selectionEnd, selectionForeground, selectionBackground);
        this.real.rotate(-90.0f);
        if (statePushed) {
            try {
                this.real.restoreState();
                this.real.popState();
            }
            catch (Throwable throwable) {}
        }
    }

    public void fillArc(int x, int y, int w, int h, int offset, int length) {
        this.real.fillArc(-y - h, x, h, w, offset, length);
    }

    public void fillGradient(int x, int y, int w, int h, boolean vertical) {
        this.real.fillGradient(-y - h, x, h, w, !vertical);
    }

    public void fillOval(int x, int y, int w, int h) {
        this.real.fillOval(-y - h, x, h, w);
    }

    public void fillPath(Path path) {
        Path p2 = this.rotate(path);
        this.real.fillPath(p2);
        p2.dispose();
    }

    public void fillPolygon(int[] points) {
        this.real.fillPolygon(this.rotate(points));
    }

    public void fillPolygon(PointList points) {
        this.real.fillPolygon(this.rotate(points));
    }

    public void fillRectangle(int x, int y, int width, int height) {
        this.real.fillRectangle(-y - height, x, height, width);
    }

    public void fillRoundRectangle(Rectangle r, int arcWidth, int arcHeight) {
        this.real.fillRoundRectangle(this.rotate(r), arcHeight, arcWidth);
    }

    public void fillString(String s, int x, int y) {
        boolean statePushed = false;
        try {
            this.real.pushState();
            statePushed = true;
        }
        catch (Throwable throwable) {
            statePushed = false;
        }
        this.real.rotate(90.0f);
        this.real.fillString(s, x, y);
        this.real.rotate(-90.0f);
        if (statePushed) {
            try {
                this.real.restoreState();
                this.real.popState();
            }
            catch (Throwable throwable) {}
        }
    }

    public void fillText(String s, int x, int y) {
        boolean statePushed = false;
        try {
            this.real.pushState();
            statePushed = true;
        }
        catch (Throwable throwable) {
            statePushed = false;
        }
        this.real.rotate(90.0f);
        this.real.fillText(s, x, y);
        this.real.rotate(-90.0f);
        if (statePushed) {
            try {
                this.real.restoreState();
                this.real.popState();
            }
            catch (Throwable throwable) {}
        }
    }

    public double getAbsoluteScale() {
        return this.real.getAbsoluteScale();
    }

    public int getAlpha() {
        return this.real.getAlpha();
    }

    public int getAntialias() {
        return this.real.getAntialias();
    }

    public Color getBackgroundColor() {
        return this.real.getBackgroundColor();
    }

    public Rectangle getClip(Rectangle rect) {
        rect = this.real.getClip(rect);
        int rx = rect.y;
        int ry = -rect.x - rect.width;
        int rw = rect.height;
        int rh = rect.width;
        rect.x = rx;
        rect.y = ry;
        rect.width = rw;
        rect.height = rh;
        return rect;
    }

    public int getFillRule() {
        return this.real.getFillRule();
    }

    public Font getFont() {
        return this.real.getFont();
    }

    public FontMetrics getFontMetrics() {
        return this.real.getFontMetrics();
    }

    public Color getForegroundColor() {
        return this.real.getForegroundColor();
    }

    public int getInterpolation() {
        return this.real.getInterpolation();
    }

    public int getLineCap() {
        return this.real.getLineCap();
    }

    public int getLineJoin() {
        return this.real.getLineJoin();
    }

    public int getLineStyle() {
        return this.real.getLineStyle();
    }

    public int getLineWidth() {
        return this.real.getLineWidth();
    }

    public int getTextAntialias() {
        return this.real.getTextAntialias();
    }

    public boolean getXORMode() {
        return this.real.getXORMode();
    }

    public void popState() {
        this.real.popState();
    }

    public void pushState() {
        this.real.pushState();
    }

    public void restoreState() {
        this.real.restoreState();
    }

    public void rotate(float degrees) {
        this.real.rotate(degrees);
    }

    public void scale(double amount) {
        this.real.scale(amount);
    }

    public void scale(float horizontal, float vertical) {
        this.real.scale(horizontal, vertical);
    }

    public void setAlpha(int alpha) {
        this.real.setAlpha(alpha);
    }

    public void setAntialias(int value) {
        this.real.setAntialias(value);
    }

    public void setBackgroundColor(Color rgb) {
        this.real.setBackgroundColor(rgb);
    }

    public void setBackgroundPattern(Pattern pattern) {
        if (this.lastBgPattern != null) {
            this.lastBgPattern.dispose();
            this.lastBgPattern = null;
        }
        if (pattern instanceof GradientPattern) {
            Pattern p = this.rotate((GradientPattern)pattern);
            this.real.setBackgroundPattern(p);
            this.lastBgPattern = p;
        } else if (pattern instanceof ImagePattern) {
            Pattern p = this.rotate((ImagePattern)pattern);
            this.real.setBackgroundPattern(p);
            this.lastBgPattern = p;
        } else {
            this.real.setBackgroundPattern(pattern);
        }
    }

    public void setClip(Path path) {
        Path p2 = this.rotate(path);
        this.real.setClip(p2);
        p2.dispose();
    }

    public void setClip(Rectangle r) {
        this.real.setClip(this.rotate(r));
    }

    public void setFillRule(int rule) {
        this.real.setFillRule(rule);
    }

    public void setFont(Font f) {
        this.real.setFont(f);
    }

    public void setForegroundColor(Color rgb) {
        this.real.setForegroundColor(rgb);
    }

    public void setForegroundPattern(Pattern pattern) {
        if (this.lastFgPattern != null) {
            this.lastFgPattern.dispose();
            this.lastFgPattern = null;
        }
        if (pattern instanceof GradientPattern) {
            Pattern p = this.rotate((GradientPattern)pattern);
            this.real.setForegroundPattern(p);
            this.lastFgPattern = p;
        } else if (pattern instanceof ImagePattern) {
            Pattern p = this.rotate((ImagePattern)pattern);
            this.real.setForegroundPattern(p);
            this.lastFgPattern = p;
        } else {
            this.real.setForegroundPattern(pattern);
        }
    }

    public void setInterpolation(int interpolation) {
        this.real.setInterpolation(interpolation);
    }

    public void setLineCap(int cap) {
        this.real.setLineCap(cap);
    }

    public void setLineDash(int[] dash) {
        this.real.setLineDash(dash);
    }

    public void setLineJoin(int join) {
        this.real.setLineJoin(join);
    }

    public void setLineStyle(int style) {
        this.real.setLineStyle(style);
    }

    public void setLineWidth(int width) {
        this.real.setLineWidth(width);
    }

    public void setTextAntialias(int value) {
        this.real.setTextAntialias(value);
    }

    public void setXORMode(boolean b) {
        this.real.setXORMode(b);
    }

    public void shear(float horz, float vert) {
        this.real.shear(horz, vert);
    }

    public void translate(float dx, float dy) {
        this.real.translate(-dy, dx);
    }

    public void translate(int dx, int dy) {
        this.real.translate(-dy, dx);
    }
}

