/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.draw2d;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;

public class AdvancedToolbarLayout
extends ToolbarLayout {
    private int majorAlignment = 0;
    private boolean stretchMajorAxis = false;
    private int innerMinorAlignment = 0;

    public AdvancedToolbarLayout() {
        this(false);
    }

    public AdvancedToolbarLayout(boolean isHorizontal) {
        super(isHorizontal);
        this.setMinorAlignment(0);
    }

    public void setMajorAlignment(int majorAlignment) {
        this.majorAlignment = majorAlignment;
    }

    public int getMajorAlignment() {
        return this.majorAlignment;
    }

    public boolean isStretchMajorAxis() {
        return this.stretchMajorAxis;
    }

    public void setStretchMajorAxis(boolean stretchMajorAxis) {
        this.stretchMajorAxis = stretchMajorAxis;
    }

    public int getInnerMinorAlignment() {
        return this.innerMinorAlignment;
    }

    public void setInnerMinorAlignment(int innerMinorAlignment) {
        this.innerMinorAlignment = innerMinorAlignment;
    }

    public void layout(IFigure parent) {
        int prefSpacing;
        IFigure child;
        List children = parent.getChildren();
        int numChildren = children.size();
        Rectangle clientArea = this.transposer.t(parent.getClientArea());
        int x = clientArea.x;
        int y = clientArea.y;
        Dimension[] prefSizes = new Dimension[numChildren];
        Dimension[] minSizes = new Dimension[numChildren];
        int wHint = -1;
        int hHint = -1;
        if (this.isHorizontal()) {
            hHint = parent.getClientArea((Rectangle)Rectangle.SINGLETON).height;
        } else {
            wHint = parent.getClientArea((Rectangle)Rectangle.SINGLETON).width;
        }
        int totalHeight = 0;
        int totalWidth = 0;
        int i = 0;
        while (i < numChildren) {
            child = (IFigure)children.get(i);
            prefSizes[i] = this.transposer.t(child.getPreferredSize(wHint, hHint));
            minSizes[i] = this.transposer.t(child.getMinimumSize(wHint, hHint));
            totalHeight += prefSizes[i].height;
            totalWidth = Math.max(totalWidth, prefSizes[i].width);
            ++i;
        }
        if (this.stretchMajorAxis && numChildren > 1) {
            prefSpacing = (clientArea.height - totalHeight) / (numChildren - 1);
            totalHeight = clientArea.height;
        } else {
            prefSpacing = this.spacing;
            totalHeight += (numChildren - 1) * this.spacing;
        }
        if (this.majorAlignment == 0) {
            y += (clientArea.height - totalHeight) / 2;
        } else if (this.majorAlignment == 2) {
            y += clientArea.height - totalHeight;
        }
        if (this.matchWidth) {
            totalWidth = Integer.MAX_VALUE;
        }
        totalWidth = Math.max(0, Math.min(clientArea.width, totalWidth));
        int adjust = clientArea.width - totalWidth;
        switch (this.minorAlignment) {
            case 1: {
                adjust = 0;
                break;
            }
            case 0: {
                adjust /= 2;
                break;
            }
        }
        int i2 = 0;
        while (i2 < numChildren) {
            int prefHeight = prefSizes[i2].height;
            int prefWidth = prefSizes[i2].width;
            int minWidth = minSizes[i2].width;
            Rectangle newBounds = new Rectangle(x, y, prefWidth, prefHeight);
            child = (IFigure)children.get(i2);
            int width = Math.min(prefWidth, this.transposer.t((Dimension)child.getMaximumSize()).width);
            if (this.matchWidth) {
                width = this.transposer.t((Dimension)child.getMaximumSize()).width;
            }
            newBounds.width = width = Math.max(minWidth, Math.min(clientArea.width, width));
            int adjust2 = totalWidth - width;
            switch (this.innerMinorAlignment) {
                case 2: {
                    adjust2 = 0;
                    break;
                }
                case 0: {
                    adjust2 /= 2;
                    break;
                }
            }
            newBounds.x += adjust + adjust2;
            child.setBounds(this.transposer.t(newBounds));
            y += newBounds.height + prefSpacing;
            ++i2;
        }
    }
}

