/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IViewer;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.part.IPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Request {
    private static final List<IPart> EMPTY_SOURCES = Collections.emptyList();
    private static final Map<String, Object> EMPTY_PARAMETERS = Collections.emptyMap();
    private static final Map<String, Object> EMPTY_RESULTS = Collections.emptyMap();
    private static final Collection<String> EMPTY_NAMES = Collections.emptyList();
    private String type;
    private EditDomain domain;
    private IViewer viewer;
    private List<IPart> targets;
    private Map<String, Object> parameters = null;
    private Map<String, Object> results = null;

    public Request(String type) {
        if (type == null) {
            throw new IllegalArgumentException("A request's type must not be null.");
        }
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public EditDomain getDomain() {
        return this.domain;
    }

    public EditDomain getTargetDomain() {
        if (this.domain != null) {
            return this.domain;
        }
        if (this.viewer != null) {
            return this.viewer.getEditDomain();
        }
        return null;
    }

    public ICommandStack getTargetCommandStack() {
        EditDomain targetDomain = this.getTargetDomain();
        if (targetDomain != null) {
            return targetDomain.getCommandStack();
        }
        return null;
    }

    public Request setDomain(EditDomain domain) {
        this.domain = domain;
        return this;
    }

    public Request setViewer(IViewer viewer) {
        this.viewer = viewer;
        return this;
    }

    public IViewer getTargetViewer() {
        return this.viewer;
    }

    public List<IPart> getTargets() {
        return this.targets == null ? EMPTY_SOURCES : this.targets;
    }

    public boolean hasTargets() {
        return this.targets != null && !this.targets.isEmpty();
    }

    public Request setTargets(List<? extends IPart> parts) {
        if (this.targets == null) {
            if (!parts.isEmpty()) {
                this.targets = new ArrayList<IPart>(parts);
            }
        } else {
            this.targets.clear();
            this.targets.addAll(parts);
        }
        return this;
    }

    public IPart getPrimaryTarget() {
        return this.targets == null || this.targets.isEmpty() ? null : this.targets.get(0);
    }

    public Request setPrimaryTarget(IPart part) {
        if (part != null) {
            if (this.targets == null) {
                this.targets = new ArrayList<IPart>(1);
                this.targets.add(part);
            } else {
                this.targets.remove(part);
                this.targets.add(0, part);
            }
        }
        return this;
    }

    public Map<String, Object> getParameters() {
        return this.parameters == null ? EMPTY_PARAMETERS : Collections.unmodifiableMap(this.parameters);
    }

    public Request setParameter(String paramName, Object paramValue) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, Object>();
        }
        this.parameters.put(paramName, paramValue);
        return this;
    }

    public Request removeParameter(String paramName) {
        if (this.parameters != null) {
            this.parameters.remove(paramName);
            if (this.parameters.isEmpty()) {
                this.parameters = null;
            }
        }
        return this;
    }

    public Request removeAllParameters() {
        this.parameters = null;
        return this;
    }

    public Collection<String> getParameterNames() {
        if (this.parameters != null) {
            return this.parameters.keySet();
        }
        return EMPTY_NAMES;
    }

    public Request setParameters(Map<String, Object> parameters) {
        if (parameters.isEmpty()) {
            this.parameters = null;
        } else if (this.parameters == null) {
            this.parameters = new HashMap<String, Object>(parameters);
        } else {
            this.parameters.putAll(parameters);
        }
        return this;
    }

    public Object getParameter(String paramName) {
        return this.parameters == null ? null : this.parameters.get(paramName);
    }

    public boolean isParameter(String paramName) {
        if (this.parameters == null) {
            return false;
        }
        return Boolean.TRUE.equals(this.parameters.get(paramName));
    }

    public int getIntParameter(String paramName, int defaultValue) {
        Object param = this.getParameter(paramName);
        if (param instanceof Integer) {
            return (Integer)param;
        }
        return defaultValue;
    }

    public double getDoubleParameter(String paramName, double defaultValue) {
        Object param = this.getParameter(paramName);
        if (param instanceof Double) {
            return (Double)param;
        }
        return defaultValue;
    }

    public boolean hasParameter(String paramName) {
        return this.parameters != null && this.parameters.containsKey(paramName);
    }

    public Map<String, Object> getResults() {
        return this.results == null ? EMPTY_RESULTS : Collections.unmodifiableMap(this.results);
    }

    public Request setResult(String resultName, Object resultValue) {
        if (this.results == null) {
            this.results = new HashMap<String, Object>();
        }
        this.results.put(resultName, resultValue);
        return this;
    }

    public Request removeResult(String resultName) {
        if (this.results != null) {
            this.results.remove(resultName);
            if (this.results.isEmpty()) {
                this.results = null;
            }
        }
        return this;
    }

    public Request removeAllResults() {
        this.results = null;
        return this;
    }

    public Request setResults(Map<String, Object> results) {
        if (results.isEmpty()) {
            this.results = null;
        } else if (this.results == null) {
            this.results = new HashMap<String, Object>(results);
        } else {
            this.results.putAll(results);
        }
        return this;
    }

    public Object getResult(String resultName) {
        return this.results == null ? null : this.results.get(resultName);
    }

    public boolean hasResult(String resultName) {
        return this.results != null && this.results.containsKey(resultName);
    }
}

