/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gallery;

import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.xmind.gef.draw2d.ITextFigure;
import org.xmind.gef.part.Decorator;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.util.Properties;
import org.xmind.ui.gallery.FrameFigure;
import org.xmind.ui.gallery.GalleryViewer;

public class FrameDecorator
extends Decorator {
    public static final FrameDecorator DEFAULT = new FrameDecorator();

    public void decorate(IGraphicalPart part, IFigure figure) {
        super.decorate(part, figure);
        FrameFigure frame = (FrameFigure)part.getFigure();
        Object model = part.getModel();
        GalleryViewer viewer = (GalleryViewer)part.getSite().getViewer();
        Properties properties = viewer.getProperties();
        IBaseLabelProvider labelProvider = viewer.getLabelProvider();
        boolean hideTitle = properties.getBoolean("org.xmind.ui.gallery.hideTitle", false);
        frame.setHideTitle(hideTitle);
        boolean flat = properties.getBoolean("org.xmind.ui.gallery.flatFrames", false);
        frame.setFlat(flat);
        int titlePlacement = properties.getInteger("org.xmind.ui.gallery.titlePlacement", GalleryViewer.TITLE_TOP.intValue());
        frame.setTitlePlacement(titlePlacement);
        if (!hideTitle) {
            this.decorateTitle(frame.getTitle(), model, labelProvider);
        }
    }

    private String getText(Object element, IBaseLabelProvider labelProvider) {
        if (labelProvider instanceof ILabelProvider) {
            return ((ILabelProvider)labelProvider).getText(element);
        }
        return null;
    }

    protected void decorateTitle(ITextFigure titleFigure, Object model, IBaseLabelProvider labelProvider) {
        String text = this.getText(model, labelProvider);
        if (text == null) {
            text = "";
        }
        titleFigure.setText(text);
        if (labelProvider instanceof IFontProvider) {
            IFontProvider fontProvider = (IFontProvider)labelProvider;
            titleFigure.setFont(fontProvider.getFont(model));
        }
        if (labelProvider instanceof IColorProvider) {
            IColorProvider colorProvider = (IColorProvider)labelProvider;
            titleFigure.setForegroundColor(colorProvider.getForeground(model));
            titleFigure.setBackgroundColor(colorProvider.getBackground(model));
        }
    }
}

