/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gallery;

import org.eclipse.draw2d.AbstractHintLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;

public class FrameBorderLayout
extends AbstractHintLayout {
    public static final Integer CENTER = new Integer(2);
    public static final Integer TOP = new Integer(8);
    public static final Integer BOTTOM = new Integer(32);
    public static final Integer LEFT = new Integer(1);
    public static final Integer RIGHT = new Integer(4);
    private IFigure center;
    private IFigure left;
    private IFigure top;
    private IFigure bottom;
    private IFigure right;
    private int vGap = 0;
    private int hGap = 0;
    private boolean useCenterAsHint = false;

    public boolean isUseCenterAsHint() {
        return this.useCenterAsHint;
    }

    public void setUseCenterAsHint(boolean useCenterAsHint) {
        this.useCenterAsHint = useCenterAsHint;
    }

    protected Dimension calculateMinimumSize(IFigure container, int wHint, int hHint) {
        Insets border = container.getInsets();
        return new Dimension(border.getWidth(), border.getHeight());
    }

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        Dimension childSize;
        Insets border = container.getInsets();
        Dimension prefSize = new Dimension();
        if (this.center != null && this.center.isVisible()) {
            childSize = this.center.getPreferredSize();
            prefSize.setSize(childSize);
        }
        if (this.top != null && this.top.isVisible()) {
            childSize = this.top.getPreferredSize(prefSize.width, -1);
            prefSize.height += childSize.height + this.vGap;
        } else if (this.bottom != null && this.bottom.isVisible()) {
            childSize = this.bottom.getPreferredSize(prefSize.width, -1);
            prefSize.height += childSize.height + this.vGap;
        } else if (this.left != null && this.left.isVisible()) {
            childSize = this.left.getPreferredSize(-1, prefSize.height);
            prefSize.width += childSize.width + this.hGap;
        } else if (this.right != null && this.right.isVisible()) {
            childSize = this.right.getPreferredSize(-1, prefSize.height);
            prefSize.width += childSize.width + this.hGap;
        }
        prefSize.height += border.getHeight();
        prefSize.width += border.getHeight();
        return prefSize;
    }

    public void layout(IFigure container) {
        Rectangle area = container.getClientArea();
        Rectangle rect = new Rectangle();
        int wHint = area.width;
        int hHint = area.height;
        Dimension centerSize = this.center != null && this.center.isVisible() ? this.center.getPreferredSize(wHint, hHint) : new Dimension();
        if (this.top != null && this.top.isVisible()) {
            rect.setLocation(area.x, area.y);
            rect.setSize(area.width, Math.max(0, area.height - centerSize.height - this.vGap));
            this.top.setBounds(rect);
            area.y += rect.height + this.vGap;
            area.height -= rect.height + this.vGap;
        } else if (this.bottom != null && this.bottom.isVisible()) {
            rect.setLocation(area.x, area.y + centerSize.height + this.vGap);
            rect.setSize(area.width, Math.max(0, area.height - centerSize.height - this.vGap));
            this.bottom.setBounds(rect);
            area.height -= rect.height + this.vGap;
        } else if (this.left != null && this.left.isVisible()) {
            rect.setLocation(area.x, area.y);
            rect.setSize(Math.max(0, area.width - centerSize.width - this.hGap), area.height);
            this.left.setBounds(rect);
            area.x += rect.width + this.hGap;
            area.width -= rect.width + this.hGap;
        } else if (this.right != null && this.right.isVisible()) {
            rect.setLocation(area.x + centerSize.width + this.hGap, area.y);
            rect.setSize(Math.max(0, area.width - centerSize.width - this.hGap), area.height);
            this.right.setBounds(rect);
            area.width -= rect.width + this.hGap;
        }
        if (this.center != null && this.center.isVisible()) {
            if (area.width < 0) {
                area.width = 0;
            }
            if (area.height < 0) {
                area.height = 0;
            }
            this.center.setBounds(area);
        }
    }

    public void remove(IFigure child) {
        if (this.center == child) {
            this.center = null;
        } else if (this.top == child) {
            this.top = null;
        } else if (this.bottom == child) {
            this.bottom = null;
        } else if (this.right == child) {
            this.right = null;
        } else if (this.left == child) {
            this.left = null;
        }
    }

    public void setConstraint(IFigure child, Object constraint) {
        this.remove(child);
        super.setConstraint(child, constraint);
        if (constraint == null) {
            return;
        }
        switch ((Integer)constraint) {
            case 2: {
                this.center = child;
                break;
            }
            case 8: {
                this.top = child;
                break;
            }
            case 32: {
                this.bottom = child;
                break;
            }
            case 4: {
                this.right = child;
                break;
            }
            case 1: {
                this.left = child;
                break;
            }
        }
    }

    public void setHorizontalSpacing(int gap) {
        this.hGap = gap;
    }

    public void setVerticalSpacing(int gap) {
        this.vGap = gap;
    }
}

