/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.util.xml;

import java.util.Stack;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ContentHandlerToXMLStreamWriter
extends DefaultHandler {
    private final XMLStreamWriter staxWriter;
    private final Stack prefixBindings;

    public ContentHandlerToXMLStreamWriter(XMLStreamWriter xMLStreamWriter) {
        this.staxWriter = xMLStreamWriter;
        this.prefixBindings = new Stack();
    }

    public void endDocument() throws SAXException {
        try {
            this.staxWriter.writeEndDocument();
            this.staxWriter.flush();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SAXException(xMLStreamException);
        }
    }

    public void startDocument() throws SAXException {
        try {
            this.staxWriter.writeStartDocument();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SAXException(xMLStreamException);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        try {
            this.staxWriter.writeCharacters(cArray, n, n2);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SAXException(xMLStreamException);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.characters(cArray, n, n2);
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    public void skippedEntity(String string) throws SAXException {
        try {
            this.staxWriter.writeEntityRef(string);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SAXException(xMLStreamException);
        }
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        try {
            this.staxWriter.writeProcessingInstruction(string, string2);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SAXException(xMLStreamException);
        }
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        if (string.equals("xml")) {
            return;
        }
        if (string == null) {
            string = "";
        }
        this.prefixBindings.add(string);
        this.prefixBindings.add(string2);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        try {
            this.staxWriter.writeEndElement();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SAXException(xMLStreamException);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        try {
            this.staxWriter.writeStartElement(this.getPrefix(string3), string2, string);
            while (this.prefixBindings.size() != 0) {
                String string4 = (String)this.prefixBindings.pop();
                String string5 = (String)this.prefixBindings.pop();
                if (string5.length() == 0) {
                    this.staxWriter.setDefaultNamespace(string4);
                } else {
                    this.staxWriter.setPrefix(string5, string4);
                }
                this.staxWriter.writeNamespace(string5, string4);
            }
            this.writeAttributes(attributes);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SAXException(xMLStreamException);
        }
    }

    private void writeAttributes(Attributes attributes) throws XMLStreamException {
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string = this.getPrefix(attributes.getQName(i));
            if (string.equals("xmlns")) continue;
            this.staxWriter.writeAttribute(string, attributes.getURI(i), attributes.getLocalName(i), attributes.getValue(i));
        }
    }

    private String getPrefix(String string) {
        int n = string.indexOf(58);
        if (n == -1) {
            return "";
        }
        return string.substring(0, n);
    }
}

