/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xmind.core.CoreException;
import org.xmind.core.io.IInputSource;
import org.xmind.core.io.IOutputTarget;
import org.xmind.core.io.IStorage;

public class FileUtils {
    private static Pattern FileNamePattern = null;

    public static File ensureFileParent(File f) {
        FileUtils.ensureDirectory(f.getParentFile());
        return f;
    }

    public static File ensureDirectory(File dir) {
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public static void copy(String src, String dest) throws IOException {
        FileInputStream is = new FileInputStream(src);
        FileOutputStream os = new FileOutputStream(dest);
        FileUtils.transfer(is, os, true);
    }

    public static void copy(File src, File dest) throws IOException {
        FileInputStream is = new FileInputStream(src);
        FileOutputStream os = new FileOutputStream(dest);
        FileUtils.transfer(is, os, true);
    }

    public static void transfer(IStorage oldStorage, IStorage newStorage) throws IOException, CoreException {
        IInputSource inSource = oldStorage.getInputSource();
        IOutputTarget outTarget = newStorage.getOutputTarget();
        Iterator<String> entries = inSource.getEntries();
        while (entries.hasNext()) {
            OutputStream os;
            String stream = entries.next();
            InputStream is = inSource.getEntryStream(stream);
            if (is == null || (os = outTarget.getEntryStream(stream)) == null) continue;
            FileUtils.transfer(is, os);
        }
    }

    public static void transfer(InputStream is, OutputStream os) throws IOException {
        FileUtils.transfer(is, os, true, null);
    }

    public static void transfer(InputStream is, OutputStream os, boolean closeOnFinish) throws IOException {
        FileUtils.transfer(is, os, closeOnFinish, null);
    }

    public static void transfer(InputStream is, OutputStream os, boolean closeOnFinish, String taskName) throws IOException {
        try {
            int num;
            byte[] buffer = new byte[1024];
            while ((num = is.read(buffer)) > 0) {
                os.write(buffer, 0, num);
            }
        }
        finally {
            if (closeOnFinish) {
                try {
                    is.close();
                }
                finally {
                    os.close();
                }
            }
        }
    }

    public static boolean delete(File f) {
        if (f.isFile()) {
            return f.delete();
        }
        if (f.isDirectory()) {
            boolean b = FileUtils.clearDir(f);
            return b &= f.delete();
        }
        return false;
    }

    public static boolean clearDir(File dir) {
        if (!dir.isDirectory()) {
            return false;
        }
        File[] files = dir.listFiles();
        if (files == null || files.length == 0) {
            return true;
        }
        boolean cleared = true;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File sub = fileArray[n2];
            cleared &= FileUtils.delete(sub);
            ++n2;
        }
        return cleared;
    }

    public static String getMediaType(String path) {
        if (path != null) {
            String ext = FileUtils.getExtension(path);
            if (".jpg".equals(ext) || ".jpeg".equals(ext)) {
                return "image/jpeg";
            }
            if (".png".equals(ext)) {
                return "image/png";
            }
            if (".bmp".equals(ext)) {
                return "image/bmp";
            }
            if (".gif".equals(ext)) {
                return "image/gif";
            }
        }
        return "";
    }

    public static String getFileName(String fullPath) {
        Matcher m;
        if (FileNamePattern == null) {
            FileNamePattern = Pattern.compile("([^/\\\\]*)[/|\\\\]?$");
        }
        if ((m = FileNamePattern.matcher(fullPath)).find()) {
            return m.group(1);
        }
        return fullPath;
    }

    public static String getExtension(String fullPath) {
        String fileName = FileUtils.getFileName(fullPath);
        int i = fileName.lastIndexOf(46);
        if (i >= 0) {
            return fileName.substring(i);
        }
        return "";
    }

    public static String getNoExtensionFileName(String fullPath) {
        String fileName = FileUtils.getFileName(fullPath);
        int i = fileName.lastIndexOf(46);
        if (i >= 0) {
            return fileName.substring(0, i);
        }
        return fileName;
    }
}

