/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.xmind.core.Core;
import org.xmind.core.CoreException;
import org.xmind.core.io.IInputSource;
import org.xmind.core.io.IOutputTarget;
import org.xmind.core.io.IStorage;

public class ByteArrayStorage
implements IStorage {
    private Map<String, byte[]> dataTable;
    private Map<String, Long> timeTable;

    public String getFullPath() {
        return this.getName();
    }

    public IInputSource getInputSource() throws CoreException {
        return new ByteArrayInputSource();
    }

    public String getName() {
        return this.toString();
    }

    public IOutputTarget getOutputTarget() throws CoreException {
        return new ByteArrayOutputTarget();
    }

    public void clear() {
        this.dataTable = null;
        this.timeTable = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ByteArrayInputSource
    implements IInputSource {
        private ByteArrayInputSource() {
        }

        public void close() {
        }

        @Override
        public Iterator<String> getEntries() {
            return ByteArrayStorage.this.dataTable == null ? NO_ENTRIES : ByteArrayStorage.this.dataTable.keySet().iterator();
        }

        @Override
        public InputStream getEntryStream(String entryName) {
            byte[] bs;
            if (ByteArrayStorage.this.dataTable != null && entryName != null && (bs = (byte[])ByteArrayStorage.this.dataTable.get(entryName)) != null) {
                return new ByteArrayInputStream(bs);
            }
            return null;
        }

        @Override
        public long getEntrySize(String entryName) {
            byte[] bs;
            if (ByteArrayStorage.this.dataTable != null && entryName != null && (bs = (byte[])ByteArrayStorage.this.dataTable.get(entryName)) != null) {
                return bs.length;
            }
            return -1L;
        }

        @Override
        public long getEntryTime(String entryName) {
            Long time;
            if (ByteArrayStorage.this.timeTable != null && entryName != null && (time = (Long)ByteArrayStorage.this.timeTable.get(entryName)) != null) {
                return time;
            }
            return 0L;
        }

        public String getName() {
            return ByteArrayStorage.this.getName();
        }

        @Override
        public boolean hasEntry(String entryName) {
            return ByteArrayStorage.this.dataTable != null && ByteArrayStorage.this.dataTable.containsKey(entryName);
        }

        public boolean open() {
            return ByteArrayStorage.this.dataTable != null && !ByteArrayStorage.this.dataTable.isEmpty();
        }

        public boolean closeEntryStream(String entryPath, InputStream stream) {
            try {
                stream.close();
                return true;
            }
            catch (IOException e) {
                Core.getLogger().log(e);
                return false;
            }
        }
    }

    private class ByteArrayOutputTarget
    implements IOutputTarget {
        private ByteArrayOutputTarget() {
        }

        public void close() {
        }

        public OutputStream getEntryStream(String entryName) {
            if (entryName != null) {
                return new ByteArrayOutputStream2(entryName);
            }
            return null;
        }

        public boolean isEntryAvaialble(String entryName) {
            return entryName != null;
        }

        public boolean open() {
            return true;
        }

        public boolean closeEntryStream(String entryPath, OutputStream stream) {
            try {
                stream.close();
                return true;
            }
            catch (IOException e) {
                Core.getLogger().log(e);
                return false;
            }
        }

        public void setEntryTime(String entryName, long time) {
            if (ByteArrayStorage.this.timeTable == null) {
                ByteArrayStorage.this.timeTable = new HashMap();
            }
            ByteArrayStorage.this.timeTable.put(entryName, time);
        }

        private class ByteArrayOutputStream2
        extends ByteArrayOutputStream {
            private String entryName;

            public ByteArrayOutputStream2(String entryName) {
                this.entryName = entryName;
            }

            public void flush() throws IOException {
                super.flush();
                this.pushBytes();
            }

            public void close() throws IOException {
                super.close();
                this.pushBytes();
                ByteArrayOutputTarget.this.setEntryTime(this.entryName, System.currentTimeMillis());
            }

            private void pushBytes() {
                if (ByteArrayStorage.this.dataTable == null) {
                    ByteArrayStorage.this.dataTable = new HashMap();
                }
                ByteArrayStorage.this.dataTable.put(this.entryName, this.toByteArray());
            }
        }
    }
}

