/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xmind.core.Core;
import org.xmind.core.CoreException;
import org.xmind.core.IEncryptionHandler;
import org.xmind.core.IWorkbook;
import org.xmind.core.internal.AbstractWorkbookBuilder;
import org.xmind.core.internal.dom.WorkbookImpl;
import org.xmind.core.internal.dom.WorkbookLoader;
import org.xmind.core.internal.zip.ZipFileInputSource;
import org.xmind.core.io.DirectoryStorage;
import org.xmind.core.io.IInputSource;
import org.xmind.core.io.IOutputTarget;
import org.xmind.core.io.IStorage;
import org.xmind.core.util.FileUtils;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class WorkbookBuilderImpl
extends AbstractWorkbookBuilder
implements ErrorHandler {
    private DocumentBuilder documentCreator = null;
    private DocumentBuilder documentLoader = null;
    private IEncryptionHandler defaultEncryptionHandler = null;

    public void setDefaultEncryptionHandler(IEncryptionHandler encryptionHandler) {
        if (this.defaultEncryptionHandler != null) {
            return;
        }
        this.defaultEncryptionHandler = encryptionHandler;
    }

    private DocumentBuilder getDocumentCreator() {
        if (this.documentCreator == null) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                this.documentCreator = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new IllegalStateException(e);
            }
        }
        return this.documentCreator;
    }

    public DocumentBuilder getDocumentLoader() throws CoreException {
        if (this.documentLoader == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setAttribute("http://apache.org/xml/features/continue-after-fatal-error", Boolean.TRUE);
            factory.setNamespaceAware(true);
            try {
                this.documentLoader = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new CoreException(12, (Throwable)e);
            }
            this.documentLoader.setErrorHandler(this);
        }
        return this.documentLoader;
    }

    public IWorkbook createWorkbook() {
        return this.newWorkbook(null);
    }

    public IWorkbook createWorkbook(String targetPath) {
        return this.newWorkbook(targetPath);
    }

    public IWorkbook createWorkbook(IStorage storage) {
        WorkbookImpl wb = this.newWorkbook(null);
        wb.setTempStorage(storage);
        return wb;
    }

    private WorkbookImpl newWorkbook(String file) {
        Document impl = this.createDocument();
        return new WorkbookImpl(impl, file);
    }

    public IWorkbook createWorkbookOnTemp(String tempLocation) {
        if (tempLocation == null) {
            throw new IllegalArgumentException("Temp location is null");
        }
        File dir = new File(tempLocation);
        if (!dir.exists()) {
            throw new IllegalArgumentException("Temp location not exists: " + tempLocation);
        }
        return this.createWorkbook(new DirectoryStorage(dir));
    }

    public Document createDocument() {
        return this.getDocumentCreator().newDocument();
    }

    protected IWorkbook doLoadFromFile(File file, IStorage storage, IEncryptionHandler encryptionHandler) throws IOException, CoreException, FileNotFoundException {
        ZipFile zipFile = new ZipFile(file);
        try {
            IWorkbook iWorkbook = this.loadFromInputSource(new ZipFileInputSource(zipFile), storage, encryptionHandler);
            return iWorkbook;
        }
        finally {
            zipFile.close();
        }
    }

    protected IWorkbook doLoadFromSteam(InputStream in, IStorage storage, IEncryptionHandler encryptionHandler) throws IOException, CoreException {
        File tempDir = this.createTempDir();
        DirectoryStorage tempStorage = new DirectoryStorage(tempDir);
        try {
            IOutputTarget tempTarget = tempStorage.getOutputTarget();
            ZipInputStream zin = new ZipInputStream(in);
            try {
                this.copyAll(zin, tempTarget);
            }
            finally {
                zin.close();
            }
            IWorkbook iWorkbook = this.loadFromInputSource(tempStorage.getInputSource(), storage, encryptionHandler);
            return iWorkbook;
        }
        finally {
            FileUtils.delete(tempDir);
        }
    }

    private File createTempDir() {
        File tempDir = new File(Core.getWorkspace().getTempDir(Core.getIdFactory().createId()));
        return tempDir;
    }

    private void copyAll(ZipInputStream zin, IOutputTarget target) throws IOException {
        ZipEntry entry;
        while ((entry = zin.getNextEntry()) != null) {
            OutputStream out;
            String entryPath = entry.getName();
            if (entry.isDirectory() || !target.isEntryAvaialble(entryPath) || (out = target.getEntryStream(entryPath)) == null) continue;
            try {
                FileUtils.transfer(zin, out, false);
            }
            catch (Throwable throwable) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    public IWorkbook loadFromInputSource(IInputSource source, IStorage storage, IEncryptionHandler encryptionHandler) throws IOException, CoreException {
        if (encryptionHandler == null) {
            encryptionHandler = this.defaultEncryptionHandler;
        }
        return new WorkbookLoader(this, source, storage, encryptionHandler).load();
    }

    public void error(SAXParseException exception) throws SAXException {
        Core.getLogger().log(exception, "Error while loading workbook");
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        Core.getLogger().log(exception, "Fatal error while loading workbook");
    }

    public void warning(SAXParseException exception) throws SAXException {
        Core.getLogger().log(exception, "Warning while loading workbook");
    }
}

