/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmind.core.IAdaptable;
import org.xmind.core.IResourceRef;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicExtensionElement;
import org.xmind.core.IWorkbook;
import org.xmind.core.internal.TopicExtension;
import org.xmind.core.internal.dom.INodeAdaptableProvider;
import org.xmind.core.internal.dom.ResourceRefImpl;
import org.xmind.core.internal.dom.TopicExtensionElementImpl;
import org.xmind.core.internal.dom.TopicImpl;
import org.xmind.core.internal.dom.WorkbookImpl;
import org.xmind.core.util.DOMUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopicExtensionImpl
extends TopicExtension
implements INodeAdaptableProvider {
    private Element implementation;
    private TopicImpl topic;
    private TopicExtensionElementImpl content;
    private Map<Element, TopicExtensionElementImpl> eleMap = new HashMap<Element, TopicExtensionElementImpl>();

    public TopicExtensionImpl(Element implementation, TopicImpl topic) {
        this.implementation = implementation;
        this.topic = topic;
    }

    public Element getImplementation() {
        return this.implementation;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof TopicExtensionImpl)) {
            return false;
        }
        TopicExtensionImpl that = (TopicExtensionImpl)obj;
        return this.implementation == that.implementation;
    }

    public int hashCode() {
        return this.implementation.hashCode();
    }

    public String toString() {
        return "{topic-extension:" + this.getProviderName() + "}";
    }

    private Element getContentElement() {
        return DOMUtils.ensureChildElement(this.implementation, "content");
    }

    @Override
    public ITopicExtensionElement getContent() {
        if (this.content == null) {
            this.content = new TopicExtensionElementImpl(this.getContentElement(), this.topic, this);
            this.registerElement(this.content);
        }
        return this.content;
    }

    @Override
    public String getProviderName() {
        return this.implementation.getAttribute("provider");
    }

    @Override
    public ITopic getParent() {
        return this.topic;
    }

    @Override
    public ISheet getOwnedSheet() {
        return this.topic.getOwnedSheet();
    }

    @Override
    public IWorkbook getOwnedWorkbook() {
        return this.topic.getOwnedWorkbook();
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == Node.class || adapter == Element.class) {
            return this.implementation;
        }
        return super.getAdapter(adapter);
    }

    private Element getRefsElement() {
        return DOMUtils.getFirstChildElementByTag(this.implementation, "resource-refs");
    }

    @Override
    public void addResourceRef(IResourceRef ref) {
        Element refEle = ((ResourceRefImpl)ref).getImplementation();
        Element refsEle = DOMUtils.ensureChildElement(this.implementation, "resource-refs");
        Node n = refsEle.appendChild(refEle);
        if (n != null) {
            ((ResourceRefImpl)ref).addNotify(this.topic.getRealizedWorkbook());
        }
    }

    @Override
    public List<IResourceRef> getResourceRefs() {
        Element refsEle = this.getRefsElement();
        if (refsEle != null) {
            return DOMUtils.getChildList(refsEle, "resource-ref", ((WorkbookImpl)this.topic.getOwnedWorkbook()).getAdaptableProvider());
        }
        return EMPTY_REFS;
    }

    @Override
    public void removeResourceRef(IResourceRef ref) {
        Element refsEle = this.getRefsElement();
        if (refsEle == null) {
            return;
        }
        Element refEle = ((ResourceRefImpl)ref).getImplementation();
        if (refEle.getParentNode() == refsEle) {
            ((ResourceRefImpl)ref).removeNotify(this.topic.getRealizedWorkbook());
            Node n = refsEle.removeChild(refEle);
            if (!refsEle.hasChildNodes()) {
                this.implementation.removeChild(refsEle);
            }
        }
    }

    protected void addNotify(WorkbookImpl workbook) {
        for (IResourceRef ref : this.getResourceRefs()) {
            ((ResourceRefImpl)ref).addNotify(workbook);
        }
    }

    protected void removeNotify(WorkbookImpl workbook) {
        for (IResourceRef ref : this.getResourceRefs()) {
            ((ResourceRefImpl)ref).removeNotify(workbook);
        }
    }

    protected void registerElement(TopicExtensionElementImpl element) {
        this.eleMap.put(element.getImplementation(), element);
    }

    protected void unregisterElement(TopicExtensionElementImpl element) {
        this.eleMap.remove(element.getImplementation());
    }

    protected TopicExtensionElementImpl getElement(Element impl) {
        if (impl == this.implementation) {
            return null;
        }
        TopicExtensionElementImpl ele = this.eleMap.get(impl);
        if (ele == null) {
            ele = new TopicExtensionElementImpl(impl, this.topic, this);
            this.registerElement(ele);
        }
        return ele;
    }

    @Override
    public IAdaptable getAdaptable(Node node) {
        if (node instanceof Element) {
            return this.getElement((Element)node);
        }
        return null;
    }
}

