/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.util.ArrayList;
import java.util.Iterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmind.core.IMetaData;
import org.xmind.core.IWorkbook;
import org.xmind.core.internal.ElementRegistry;
import org.xmind.core.internal.Meta;
import org.xmind.core.internal.dom.InternalDOMUtils;
import org.xmind.core.internal.dom.MetaDataImpl;
import org.xmind.core.internal.dom.NS;
import org.xmind.core.internal.dom.WorkbookImpl;
import org.xmind.core.util.DOMUtils;

public class MetaImpl
extends Meta {
    private Document implementation;
    private WorkbookImpl ownedWorkbook;
    private ElementRegistry elementRegistry;

    public MetaImpl(Document implementation) {
        this.implementation = implementation;
        this.init();
    }

    protected void setOwnedWorkbook(WorkbookImpl ownedWorkbook) {
        this.ownedWorkbook = ownedWorkbook;
    }

    private void init() {
        Element m = DOMUtils.ensureChildElement(this.implementation, "meta");
        NS.setNS(NS.Meta, m, new NS[0]);
        InternalDOMUtils.addVersion(this.implementation);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof MetaImpl)) {
            return false;
        }
        MetaImpl that = (MetaImpl)obj;
        return that.implementation == this.implementation;
    }

    public int hashCode() {
        return this.implementation.hashCode();
    }

    public String toString() {
        return DOMUtils.toString(this.implementation);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == Node.class || adapter == Document.class) {
            return this.implementation;
        }
        if (adapter == ElementRegistry.class) {
            return this.getElementRegistry();
        }
        return super.getAdapter(adapter);
    }

    public Document getImplementation() {
        return this.implementation;
    }

    protected Element getMetaElement() {
        return this.implementation.getDocumentElement();
    }

    public IWorkbook getOwnedWorkbook() {
        return this.ownedWorkbook;
    }

    private String[] getKeys(String keyPath) {
        return keyPath.split("/");
    }

    private Element findElementByPath(String keyPath, boolean ensure) {
        String[] keys = this.getKeys(keyPath);
        if (keys.length == 0) {
            return null;
        }
        Element e = this.getMetaElement();
        Element c = null;
        int i = 0;
        while (i < keys.length) {
            String key = keys[i];
            if (!"".equals(key)) {
                c = ensure ? DOMUtils.ensureChildElement(e, key) : DOMUtils.getFirstChildElementByTag(e, key);
                if (c == null) {
                    return null;
                }
                e = c;
            }
            ++i;
        }
        return c;
    }

    public String getValue(String keyPath) {
        Element d = this.findElementByPath(keyPath, false);
        return d == null ? null : d.getTextContent();
    }

    public void setValue(String keyPath, String value) {
        if (value == null) {
            Element d = this.findElementByPath(keyPath, false);
            if (d != null && d.getParentNode() != null) {
                d.getParentNode().removeChild(d);
            }
        } else {
            Element d = this.findElementByPath(keyPath, true);
            if (d != null) {
                d.setTextContent(value);
            }
        }
    }

    public void addMetaData(IMetaData data) {
        Element mdEle = ((MetaDataImpl)data).getImplementation();
        this.getMetaElement().appendChild(mdEle);
    }

    public void removeMetaData(IMetaData data) {
        Element mdEle = ((MetaDataImpl)data).getImplementation();
        this.getMetaElement().removeChild(mdEle);
    }

    public IMetaData createMetaData(String key) {
        Element mdEle = this.implementation.createElement(key);
        MetaDataImpl md = new MetaDataImpl(mdEle, this);
        this.getElementRegistry().registerByKey(mdEle, md);
        return md;
    }

    public IMetaData[] getMetaData(String key) {
        ArrayList<MetaDataImpl> list = new ArrayList<MetaDataImpl>();
        Iterator<Element> it = DOMUtils.childElementIterByTag(this.getMetaElement(), key);
        while (it.hasNext()) {
            Element mdEle = it.next();
            list.add(this.getMetaData(mdEle));
        }
        return list.toArray(new IMetaData[list.size()]);
    }

    protected MetaDataImpl getMetaData(Element mdEle) {
        Object md;
        if (this.elementRegistry != null && (md = this.elementRegistry.getElement(mdEle)) != null && md instanceof IMetaData) {
            return (MetaDataImpl)md;
        }
        md = new MetaDataImpl(mdEle, this);
        this.getElementRegistry().registerByKey(mdEle, md);
        return md;
    }

    public ElementRegistry getElementRegistry() {
        if (this.elementRegistry == null) {
            this.elementRegistry = new ElementRegistry();
        }
        return this.elementRegistry;
    }
}

