/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.io.IOException;
import org.xmind.core.IFileEntry;
import org.xmind.core.IWorkbook;
import org.xmind.core.util.HyperlinkUtils;

public class InternalHyperlinkUtils {
    public static void activateHyperlink(IWorkbook workbook, String url) {
        if (workbook != null && HyperlinkUtils.isAttachmentURL(url)) {
            String attPath = HyperlinkUtils.toAttachmentPath(url);
            InternalHyperlinkUtils.increaseFileEntryRef(workbook, attPath);
        }
    }

    public static void increaseFileEntryRef(IWorkbook workbook, String entryPath) {
        IFileEntry e;
        if (workbook != null && entryPath != null && (e = workbook.getManifest().getFileEntry(entryPath)) != null) {
            e.increaseReference();
            if (e.isDirectory()) {
                for (IFileEntry sub : e.getSubEntries()) {
                    sub.increaseReference();
                }
            }
        }
    }

    public static void deactivateHyperlink(IWorkbook workbook, String url) {
        if (workbook != null && HyperlinkUtils.isAttachmentURL(url)) {
            String attPath = HyperlinkUtils.toAttachmentPath(url);
            InternalHyperlinkUtils.decreaseFileEntryRef(workbook, attPath);
        }
    }

    public static void decreaseFileEntryRef(IWorkbook workbook, String entryPath) {
        IFileEntry e;
        if (workbook != null && entryPath != null && (e = workbook.getManifest().getFileEntry(entryPath)) != null) {
            e.decreaseReference();
            if (e.isDirectory()) {
                for (IFileEntry sub : e.getSubEntries()) {
                    sub.decreaseReference();
                }
            }
        }
    }

    public static String importAttachmentURL(String sourceHyperlink, IWorkbook sourceWorkbook, IWorkbook targetWorkbook) throws IOException {
        String sourcePath = HyperlinkUtils.toAttachmentPath(sourceHyperlink);
        String targetPath = InternalHyperlinkUtils.importAttachment(sourcePath, sourceWorkbook, targetWorkbook);
        return HyperlinkUtils.toAttachmentURL(targetPath);
    }

    public static String importAttachment(String sourcePath, IWorkbook sourceWorkbook, IWorkbook targetWorkbook) throws IOException {
        IFileEntry targetEntry;
        IFileEntry sourceEntry = sourceWorkbook.getManifest().getFileEntry(sourcePath);
        if (sourceEntry != null && (targetEntry = targetWorkbook.getManifest().cloneEntryAsAttachment(sourceEntry)) != null) {
            return targetEntry.getPath();
        }
        return sourcePath;
    }
}

