/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.net;

import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeSet;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.internal.net.NetUIMessages;
import org.eclipse.ui.internal.net.NonProxyHostsContentProvider;
import org.eclipse.ui.internal.net.NonProxyHostsLabelProvider;

public class NonProxyHostsComposite
extends Composite {
    private Table table_;
    TableViewer tableViewer_;
    private TreeSet tableValues_;
    private Button add_;
    private Button edit_;
    private Button remove_;

    public NonProxyHostsComposite(Composite parent, int style) {
        super(parent, style);
        this.createWidgets();
    }

    protected void createWidgets() {
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 6;
        layout.verticalSpacing = 6;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        this.setLayout((Layout)layout);
        this.table_ = new Table((Composite)this, 68354);
        GridData data = new GridData(1808);
        this.table_.setLayoutData((Object)data);
        this.table_.setHeaderVisible(false);
        this.table_.setLinesVisible(true);
        TableLayout tableLayout = new TableLayout();
        new TableColumn(this.table_, 0);
        ColumnWeightData colData = new ColumnWeightData(100, 60, false);
        tableLayout.addColumnData((ColumnLayoutData)colData);
        this.table_.setLayout((Layout)tableLayout);
        this.tableViewer_ = new TableViewer(this.table_);
        this.tableViewer_.setContentProvider((IContentProvider)new NonProxyHostsContentProvider());
        this.tableViewer_.setLabelProvider((IBaseLabelProvider)new NonProxyHostsLabelProvider());
        this.tableViewer_.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NonProxyHostsComposite.this.enableButtons();
            }
        });
        this.tableViewer_.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                NonProxyHostsComposite.this.editSelection();
            }
        });
        Composite buttonComp = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 8;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        buttonComp.setLayout((Layout)layout);
        data = new GridData(144);
        buttonComp.setLayoutData((Object)data);
        this.add_ = this.createButton(buttonComp, NetUIMessages.BUTTON_PREFERENCE_ADD);
        this.add_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NonProxyHostsComposite.this.addHost();
            }
        });
        this.edit_ = this.createButton(buttonComp, NetUIMessages.BUTTON_PREFERENCE_EDIT);
        this.edit_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NonProxyHostsComposite.this.editSelection();
            }
        });
        this.edit_.setEnabled(false);
        this.remove_ = this.createButton(buttonComp, NetUIMessages.BUTTON_PREFERENCE_REMOVE);
        this.remove_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NonProxyHostsComposite.this.removeFromList((IStructuredSelection)NonProxyHostsComposite.this.tableViewer_.getSelection());
                NonProxyHostsComposite.this.tableViewer_.refresh();
            }
        });
        this.remove_.setEnabled(false);
    }

    private Button createButton(Composite comp, String label) {
        Button button = new Button(comp, 8);
        button.setText(label);
        GridData data = new GridData(258);
        button.setLayoutData((Object)data);
        return button;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.table_.setEnabled(enabled);
        this.enableButtons();
    }

    public void setList(String[] hosts) {
        this.tableValues_ = new TreeSet<String>(Arrays.asList(hosts));
        this.tableViewer_.setInput((Object)this.tableValues_);
        this.tableViewer_.refresh();
    }

    public String[] getList() {
        return this.tableValues_.toArray(new String[0]);
    }

    String getStringList(Iterator iterator) {
        StringBuffer buffer = new StringBuffer();
        if (iterator.hasNext()) {
            buffer.append((String)iterator.next());
        }
        while (iterator.hasNext()) {
            buffer.append(',');
            buffer.append((String)iterator.next());
        }
        return buffer.toString();
    }

    void removeFromList(IStructuredSelection selection) {
        this.tableValues_.removeAll(selection.toList());
    }

    void updateList(String value) {
        String[] hosts = value.split("\\|| |,");
        this.tableValues_.addAll(Arrays.asList(hosts));
        this.tableValues_.remove("");
        this.tableViewer_.refresh();
    }

    void enableButtons() {
        boolean enabled = this.getEnabled();
        if (enabled) {
            boolean itemsSelected = !this.tableViewer_.getSelection().isEmpty();
            this.add_.setEnabled(true);
            this.edit_.setEnabled(itemsSelected);
            this.remove_.setEnabled(itemsSelected);
        } else {
            this.add_.setEnabled(false);
            this.edit_.setEnabled(false);
            this.remove_.setEnabled(false);
        }
    }

    void editSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer_.getSelection();
        String selectedHosts = this.getStringList(selection.iterator());
        String value = this.promptForHost(selectedHosts);
        if (value != null) {
            this.removeFromList(selection);
            this.updateList(value);
        }
    }

    void addHost() {
        String value = this.promptForHost(null);
        if (value != null) {
            this.updateList(value);
        }
    }

    private String promptForHost(String selectedHosts) {
        InputDialog dialog = new InputDialog(this.getShell(), NetUIMessages.TITLE_PREFERENCE_HOSTS_DIALOG, NetUIMessages.LABEL_PREFERENCE_HOSTS_DIALOG, selectedHosts, null){
            private ControlDecoration decorator;

            protected Control createDialogArea(Composite parent) {
                Control createDialogArea = super.createDialogArea(parent);
                this.decorator = new ControlDecoration((Control)this.getText(), 16512);
                this.decorator.setDescriptionText(NetUIMessages.NonProxyHostsComposite_0);
                this.decorator.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage());
                return createDialogArea;
            }

            public boolean close() {
                this.decorator.dispose();
                return super.close();
            }
        };
        int result = dialog.open();
        String value = result != 1 ? dialog.getValue() : null;
        return value;
    }
}

