/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable.map;

import java.util.AbstractSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.map.AbstractObservableMap;
import org.eclipse.core.databinding.observable.map.ComputedObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;

public abstract class ComputedObservableMap
extends AbstractObservableMap {
    private final IObservableSet keySet;
    private ISetChangeListener setChangeListener = new ISetChangeListener(){

        public void handleSetChange(SetChangeEvent event) {
            HashSet addedKeys = new HashSet(event.diff.getAdditions());
            HashSet removedKeys = new HashSet(event.diff.getRemovals());
            HashMap oldValues = new HashMap();
            HashMap newValues = new HashMap();
            Iterator it = removedKeys.iterator();
            while (it.hasNext()) {
                Object removedKey = it.next();
                Object oldValue = ComputedObservableMap.this.doGet(removedKey);
                ComputedObservableMap.this.unhookListener(removedKey);
                if (oldValue == null) continue;
                oldValues.put(removedKey, oldValue);
            }
            it = addedKeys.iterator();
            while (it.hasNext()) {
                Object addedKey = it.next();
                ComputedObservableMap.this.hookListener(addedKey);
                Object newValue = ComputedObservableMap.this.doGet(addedKey);
                newValues.put(addedKey, newValue);
            }
            ComputedObservableMap.this.fireMapChange(Diffs.createMapDiff(addedKeys, removedKeys, Collections.EMPTY_SET, oldValues, newValues));
        }
    };
    private Set entrySet = new EntrySet();

    public ComputedObservableMap(IObservableSet keySet) {
        super(keySet.getRealm());
        this.keySet = keySet;
        this.keySet.addSetChangeListener(this.setChangeListener);
    }

    protected void init() {
        Iterator it = this.keySet.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            this.hookListener(key);
        }
    }

    protected final void fireSingleChange(Object key, Object oldValue, Object newValue) {
        this.fireMapChange(Diffs.createMapDiffSingleChange(key, oldValue, newValue));
    }

    public Set entrySet() {
        return this.entrySet;
    }

    public Set keySet() {
        return this.keySet;
    }

    public final Object get(Object key) {
        return this.doGet(key);
    }

    public final Object put(Object key, Object value) {
        return this.doPut(key, value);
    }

    protected abstract void unhookListener(Object var1);

    protected abstract void hookListener(Object var1);

    protected abstract Object doGet(Object var1);

    protected abstract Object doPut(Object var1, Object var2);

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        public Iterator iterator() {
            Iterator keyIterator = ComputedObservableMap.this.keySet.iterator();
            return new Iterator(this, keyIterator){
                final /* synthetic */ EntrySet this$1;
                private final /* synthetic */ Iterator val$keyIterator;
                {
                    this.this$1 = entrySet;
                    this.val$keyIterator = iterator;
                }

                public boolean hasNext() {
                    return this.val$keyIterator.hasNext();
                }

                public Object next() {
                    E key = this.val$keyIterator.next();
                    return new Map.Entry(this, key){
                        final /* synthetic */ 2 this$2;
                        private final /* synthetic */ Object val$key;
                        {
                            this.this$2 = var1_1;
                            this.val$key = object;
                        }

                        public Object getKey() {
                            return this.val$key;
                        }

                        public Object getValue() {
                            return EntrySet.access$1(2.access$0(this.this$2)).get(this.getKey());
                        }

                        public Object setValue(Object value) {
                            return EntrySet.access$1(2.access$0(this.this$2)).put(this.getKey(), value);
                        }
                    };
                }

                public void remove() {
                    this.val$keyIterator.remove();
                }

                static /* synthetic */ EntrySet access$0(2 var0) {
                    return var0.this$1;
                }
            };
        }

        public int size() {
            return ComputedObservableMap.this.keySet.size();
        }

        static /* synthetic */ ComputedObservableMap access$1(EntrySet entrySet) {
            return entrySet.ComputedObservableMap.this;
        }
    }
}

