/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.signin.internal.actions;

import net.xmind.signin.IVerifyListener;
import net.xmind.signin.XMindNetEntry;
import net.xmind.signin.internal.Messages;
import net.xmind.signin.internal.actions.UpgradeRunnable;
import net.xmind.signin.internal.actions.XMindNetActionDelegate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class UpgradeActionDelegate
extends XMindNetActionDelegate
implements IWorkbenchWindowActionDelegate,
IActionDelegate2 {
    private static IVerifyListener verifyListener = null;
    private static boolean isUpgrading = false;
    private IWorkbenchWindow window;
    private IAction action;
    private boolean isPro;

    public void dispose() {
        this.window = null;
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
        this.isPro = Platform.getBundle((String)"org.xmind.meggy") != null;
        this.installVerifyListener();
        this.setURL("http://www.xmind.net/pro/buy/");
        this.update();
    }

    private void installVerifyListener() {
        if (this.isPro) {
            return;
        }
        if (verifyListener == null) {
            verifyListener = new IVerifyListener(){

                public void notifyValidity(IStatus validity) {
                    int code = validity.getCode();
                    if (code == 0) {
                        UpgradeActionDelegate.this.doUpgrade(PlatformUI.getWorkbench().getDisplay());
                    } else if (isUpgrading && (code == 4 || code == 8)) {
                        UpgradeActionDelegate.this.gotoBuyPage(PlatformUI.getWorkbench().getDisplay());
                    }
                    isUpgrading = false;
                }
            };
            XMindNetEntry.addVerifyListener(verifyListener);
        }
    }

    public void init(IAction action) {
        this.action = action;
        this.update();
    }

    private void update() {
        if (this.action != null) {
            if (this.isPro) {
                this.action.setText(Messages.Renew_text);
                this.action.setText(Messages.Renew_toolTip);
            } else {
                this.action.setText(Messages.Upgrade_text);
                this.action.setToolTipText(Messages.Upgrade_toolTip);
            }
        }
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void run(IAction action) {
        if (this.window == null) {
            return;
        }
        if (this.isPro) {
            this.renew();
        } else {
            this.upgrade();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    private void upgrade() {
        if (isUpgrading || UpgradeRunnable.isRunning()) {
            return;
        }
        isUpgrading = true;
        if (XMindNetEntry.hasSignedIn()) {
            Job verifyJob = new Job(Messages.Upgrade_jobName){

                protected IStatus run(IProgressMonitor monitor) {
                    while (isUpgrading) {
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException interruptedException) {
                            break;
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            verifyJob.schedule();
            XMindNetEntry.verify();
        } else {
            XMindNetEntry.signIn();
        }
    }

    private void doUpgrade(Display display) {
        if (UpgradeRunnable.isRunning()) {
            return;
        }
        display.asyncExec((Runnable)new UpgradeRunnable());
    }

    private void gotoBuyPage(Display display) {
        display.asyncExec(new Runnable(){

            public void run() {
                UpgradeActionDelegate.super.gotoURL();
            }
        });
    }

    private void renew() {
        this.gotoBuyPage(PlatformUI.getWorkbench().getDisplay());
    }
}

