/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.signin.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import net.xmind.signin.ISignInListener;
import net.xmind.signin.internal.Activator;
import net.xmind.signin.internal.DisplayProvider;
import net.xmind.signin.internal.IDisplayProvider;
import net.xmind.signin.internal.Messages;
import net.xmind.signin.internal.SignInDialog;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class UserInfoManager {
    public static final String USER_ID = "USER_ID";
    public static final String TOKEN = "TOKEN";
    private static final String SIGN_OUT_URL = "http://www.xmind.net/_res/token/%s/%s";
    private static UserInfoManager instance = null;
    private IPreferenceStore prefStore;
    private String userID;
    private String token;
    private List<ISignInListener> listeners;
    private List<ISignInListener> callbacks;
    private Job asyncSignInJob = null;

    private UserInfoManager(IPreferenceStore prefStore) {
        this.prefStore = prefStore;
        this.userID = prefStore.getString(USER_ID);
        if ("".equals(this.userID)) {
            this.userID = null;
        }
        this.token = prefStore.getString(TOKEN);
        if ("".equals(this.token)) {
            this.token = null;
        }
    }

    public Properties signIn() {
        final Properties[] result = new Properties[]{null};
        this.signIn(new ISignInListener(){

            public void postSignOut() {
            }

            public void postSignIn(Properties userInfo) {
                result[0] = userInfo;
            }
        }, true);
        return result[0];
    }

    public void signIn(ISignInListener callback) {
        this.signIn(callback, true);
    }

    public void signIn(ISignInListener callback, boolean block) {
        if (callback == null) {
            return;
        }
        if (this.hasSignedIn()) {
            callback.postSignIn(this.getUserInfo());
            return;
        }
        if (this.callbacks != null && this.callbacks.contains(callback)) {
            return;
        }
        if (this.callbacks == null) {
            this.callbacks = new ArrayList<ISignInListener>();
        }
        this.callbacks.add(new SignInCallback(callback, block));
        Display display = block ? Display.getCurrent() : null;
        this.startAsyncSignInJob();
        if (block) {
            while (this.asyncSignInJob != null) {
                if (display == null) {
                    try {
                        Thread.sleep(1L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                }
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
    }

    private void startAsyncSignInJob() {
        if (this.asyncSignInJob == null) {
            this.asyncSignInJob = this.createAsyncSignInJob();
            this.asyncSignInJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    UserInfoManager.this.asyncSignInJob = null;
                }
            });
            this.asyncSignInJob.schedule();
        }
    }

    private Job createAsyncSignInJob() {
        Job job = new Job("Sign In To XMind.net"){

            protected IStatus run(IProgressMonitor monitor) {
                UserInfoManager.this.doSignInJob();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        return job;
    }

    private void doSignInJob() {
        block6: {
            IDisplayProvider displayProvider = this.getDisplayProvider();
            try {
                try {
                    displayProvider.getDisplay().syncExec(new Runnable(){

                        public void run() {
                            SignInDialog dialog = new SignInDialog(null);
                            int retCode = dialog.open();
                            if (retCode == 0) {
                                UserInfoManager.this.saveUserInfo(dialog.getUserID(), dialog.getToken(), dialog.shouldRemember());
                            } else {
                                UserInfoManager.this.clearUserInfo();
                            }
                        }
                    });
                }
                catch (Throwable e) {
                    Activator.log(e);
                    displayProvider.dispose();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                displayProvider.dispose();
                throw throwable;
            }
            displayProvider.dispose();
        }
        Properties userInfo = this.getUserInfo();
        this.notifyCallbacks(userInfo);
        if (userInfo != null) {
            this.firePostSignIn(userInfo);
        }
    }

    private IDisplayProvider getDisplayProvider() {
        if (PlatformUI.isWorkbenchRunning()) {
            return new DisplayProvider(PlatformUI.getWorkbench().getDisplay());
        }
        Display display = Display.getCurrent();
        if (display != null) {
            return new DisplayProvider(display);
        }
        return new DisplayProvider(display, (display = Display.getDefault()).getThread() == Thread.currentThread());
    }

    private void notifyCallbacks(Properties userInfo) {
        int i = 0;
        while (this.callbacks != null && i < this.callbacks.size()) {
            ISignInListener callback = this.callbacks.get(i);
            if (callback != null) {
                if (userInfo != null) {
                    callback.postSignIn(userInfo);
                } else {
                    callback.postSignOut();
                }
            }
            ++i;
        }
        this.callbacks = null;
    }

    public Properties getUserInfo() {
        if (this.userID == null || this.token == null) {
            return null;
        }
        Properties info = new Properties();
        info.setProperty(USER_ID, this.userID);
        info.setProperty(TOKEN, this.token);
        return info;
    }

    private void saveUserInfo(String userID, String token, boolean remember) {
        if (userID == null || token == null) {
            throw new IllegalArgumentException();
        }
        this.userID = userID;
        this.token = token;
        if (remember) {
            this.prefStore.setValue(USER_ID, userID);
            this.prefStore.setValue(TOKEN, token);
        }
    }

    public boolean hasSignedIn() {
        return this.userID != null && this.token != null;
    }

    public String getUserID() {
        return this.userID;
    }

    public String getToken() {
        return this.token;
    }

    public void signOut() {
        this.signOut(true);
    }

    private void signOut(boolean notifyServer) {
        final String oldUserID = this.userID;
        final String oldToken = this.token;
        this.clearUserInfo();
        if (notifyServer && oldUserID != null && oldToken != null) {
            Job signOutJob = new Job(NLS.bind((String)Messages.SignOut_jobName, (Object)oldUserID)){

                protected IStatus run(IProgressMonitor monitor) {
                    String url = String.format(UserInfoManager.SIGN_OUT_URL, oldUserID, oldToken);
                    PostMethod method = new PostMethod(url);
                    method.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
                    method.setRequestHeader("AuthToken", UserInfoManager.this.token);
                    method.setRequestHeader("accept", "application/json");
                    HttpClient client = new HttpClient();
                    try {
                        client.executeMethod((HttpMethod)method);
                    }
                    catch (Exception e) {
                        Activator.log(e);
                    }
                    return new Status(0, "net.xmind.login", "Sign out finished");
                }
            };
            signOutJob.setSystem(true);
            signOutJob.schedule();
        }
        this.firePostSignOut();
    }

    private void clearUserInfo() {
        this.userID = null;
        this.token = null;
        this.prefStore.setToDefault(USER_ID);
        this.prefStore.setToDefault(TOKEN);
    }

    public static UserInfoManager getDefault() {
        if (instance == null) {
            instance = new UserInfoManager(Activator.getDefault().getPreferenceStore());
        }
        return instance;
    }

    public void addSignInListener(ISignInListener listener) {
        if (this.listeners == null || listener == null) {
            this.listeners = new ArrayList<ISignInListener>();
        }
        this.listeners.add(listener);
    }

    public void removeSignInListener(ISignInListener listener) {
        if (this.listeners == null || listener == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    protected void firePostSignIn(Properties userInfo) {
        if (this.listeners == null) {
            return;
        }
        Object[] objectArray = this.listeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ISignInListener)listener).postSignIn(userInfo);
            ++n2;
        }
    }

    protected void firePostSignOut() {
        if (this.listeners == null) {
            return;
        }
        Object[] objectArray = this.listeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ISignInListener)listener).postSignOut();
            ++n2;
        }
    }

    private static class SignInCallback
    implements ISignInListener {
        private ISignInListener realCallback;
        private Display display;
        private boolean block;

        public SignInCallback(ISignInListener realCallback, boolean block) {
            this.realCallback = realCallback;
            this.block = block;
            this.display = Display.getCurrent();
        }

        public void postSignIn(final Properties userInfo) {
            if (this.display != null) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                            public void run() throws Exception {
                                SignInCallback.this.realCallback.postSignIn(userInfo);
                            }

                            public void handleException(Throwable exception) {
                            }
                        });
                    }
                };
                if (this.block) {
                    this.display.syncExec(runnable);
                } else {
                    this.display.asyncExec(runnable);
                }
            } else {
                this.realCallback.postSignIn(userInfo);
            }
        }

        public void postSignOut() {
            if (this.display != null) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                            public void run() throws Exception {
                                SignInCallback.this.realCallback.postSignOut();
                            }

                            public void handleException(Throwable exception) {
                            }
                        });
                    }
                };
                if (this.block) {
                    this.display.syncExec(runnable);
                } else {
                    this.display.asyncExec(runnable);
                }
            } else {
                this.realCallback.postSignOut();
            }
        }
    }
}

