/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.viewers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.xmind.ui.forms.WidgetFactory;
import org.xmind.ui.viewers.ICategorizedContentProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CategorizedViewer
extends StructuredViewer {
    private List<Object> categories = new ArrayList<Object>();
    private Map<Object, List<Object>> categorizedElements = new HashMap<Object, List<Object>>();
    private List<Composite> sections = new ArrayList<Composite>();
    private ScrolledForm container = null;
    private WidgetFactory factory;
    private int sectionStyle = 322;
    private Listener sectionContentListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.type == 37) {
                CategorizedViewer.this.scroll(event);
            }
        }
    };

    public int getSectionStyle() {
        return this.sectionStyle;
    }

    public void setSectionStyle(int sectionStyle) {
        this.sectionStyle = sectionStyle;
    }

    protected Composite getContainer() {
        return this.container;
    }

    public void createControl(Composite parent, int style) {
        this.container = this.createContainer(parent, style);
        this.hookControl((Control)this.container);
    }

    private ScrolledForm createContainer(Composite parent, int style) {
        if (this.factory == null) {
            this.factory = new WidgetFactory(parent.getDisplay());
        }
        ScrolledForm form = this.factory.createScrolledForm(parent);
        this.configureForm(form);
        this.hookForm(form);
        return form;
    }

    private void configureForm(ScrolledForm form) {
        form.getBody().setLayout(this.createFormLayout());
        form.setMinWidth(1);
    }

    private void hookForm(ScrolledForm form) {
        Listener eventHandler = new Listener(){

            public void handleEvent(Event event) {
                CategorizedViewer.this.relayout();
            }
        };
        form.addListener(11, eventHandler);
    }

    private Layout createFormLayout() {
        RowLayout layout = new RowLayout(512);
        layout.wrap = false;
        layout.fill = true;
        return layout;
    }

    private void relayout() {
        int width = this.getContainer().getClientArea().width;
        for (Composite section : this.sections) {
            this.resetWidth(width, (Control)section);
        }
    }

    private void resetWidth(int width, Control control) {
        Object ld = control.getLayoutData();
        if (ld instanceof GridData) {
            GridData gd = (GridData)ld;
            GridLayout gl = (GridLayout)control.getParent().getLayout();
            gd.widthHint = width - gl.marginWidth - gl.marginLeft - gl.marginRight;
        } else if (ld instanceof RowData) {
            RowData rd = (RowData)ld;
            RowLayout rl = (RowLayout)control.getParent().getLayout();
            rd.width = width - rl.marginWidth - rl.marginLeft - rl.marginRight;
        }
    }

    protected List<Object> getCategories() {
        return this.categories;
    }

    protected List<Object> getElements(Object category) {
        return this.categorizedElements.get(category);
    }

    protected Composite getSection(Object category) {
        return this.sections.get(this.categories.indexOf(category));
    }

    protected Widget doFindInputItem(Object element) {
        return this.getControl();
    }

    protected Widget doFindItem(Object element) {
        if (this.getCategories().contains(element)) {
            return this.getSection(element);
        }
        return this.getControl();
    }

    protected void inputChanged(Object input, Object oldInput) {
        super.inputChanged(input, oldInput);
        HashMap<Object, Boolean> expansionStates = new HashMap<Object, Boolean>();
        for (Object category : this.getCategories()) {
            Composite section = this.getSection(category);
            if (!(section instanceof Section)) continue;
            expansionStates.put(category, ((Section)section).isExpanded());
        }
        this.rebuildMap(this.getSortedChildren(input));
        if (this.getContainer() != null && !this.getContainer().isDisposed()) {
            this.refreshControls();
            for (Object category : this.getCategories()) {
                Composite section;
                Boolean exp = (Boolean)expansionStates.get(category);
                if (exp == null || !((section = this.getSection(category)) instanceof Section)) continue;
                ((Section)section).setExpanded(exp.booleanValue());
            }
        }
    }

    private void rebuildMap(Object[] elements) {
        this.clearMap();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            this.addElement(element);
            ++n2;
        }
        Object[] array = null;
        ViewerFilter[] filters = this.getFilters();
        if (filters != null && filters.length > 0) {
            array = this.categories.toArray();
            ViewerFilter[] viewerFilterArray = filters;
            int n3 = filters.length;
            int n4 = 0;
            while (n4 < n3) {
                ViewerFilter f = viewerFilterArray[n4];
                array = f.filter((Viewer)this, this.getInput(), array);
                ++n4;
            }
        }
        if (this.getSorter() != null) {
            if (array == null) {
                array = this.categories.toArray();
            }
            this.getSorter().sort((Viewer)this, array);
        }
        if (array != null) {
            this.categories = new ArrayList<Object>((Collection)Arrays.asList(array));
        }
    }

    private void clearMap() {
        this.categories.clear();
        this.categorizedElements.clear();
    }

    private void addElement(Object element) {
        Object category = this.getCategory(element);
        if (category == null) {
            return;
        }
        List<Object> list = this.categorizedElements.get(category);
        if (list == null) {
            list = new ArrayList<Object>();
            this.categorizedElements.put(category, list);
            this.categories.add(category);
        }
        list.add(element);
    }

    private Object getCategory(Object element) {
        Object category = null;
        if (this.getContentProvider() instanceof ICategorizedContentProvider) {
            category = ((ICategorizedContentProvider)this.getContentProvider()).getCategory(element);
        }
        return category;
    }

    protected void refreshControls() {
        this.getContainer().setRedraw(false);
        for (Composite section : this.sections) {
            section.dispose();
        }
        this.sections.clear();
        Composite parent = this.container.getBody();
        for (Object category : this.categories) {
            Composite section = this.createSection(parent, category);
            this.hookSection(section);
            this.sections.add(section);
        }
        this.getContainer().setRedraw(true);
    }

    protected void hookSection(Composite section) {
    }

    private void scroll(Event event) {
        if (this.container != null && !this.container.isDisposed()) {
            Point origin = this.container.getOrigin();
            int count = event.count;
            ScrollBar vBar = this.container.getVerticalBar();
            if (vBar != null && !vBar.isDisposed() && vBar.isVisible() && vBar.isEnabled()) {
                int increment = vBar.getIncrement();
                int delta = count * increment;
                origin.y -= delta;
            } else {
                ScrollBar hBar = this.container.getHorizontalBar();
                if (hBar != null && !hBar.isDisposed() && hBar.isVisible() && hBar.isEnabled()) {
                    int increment = hBar.getIncrement();
                    int delta = count * increment;
                    origin.x -= delta;
                }
            }
            this.container.setOrigin(origin);
        }
    }

    private Composite createSection(Composite parent, Object category) {
        Control content;
        Section section = this.factory.createSection(parent, this.getSectionStyle());
        section.setLayoutData(this.getSectionLayoutData());
        this.updateSection(category, (Composite)section);
        Composite client = this.factory.createComposite((Composite)section, 64);
        client.setBackground(parent.getBackground());
        section.setClient((Control)client);
        StackLayout layout = new StackLayout();
        client.setLayout((Layout)layout);
        layout.topControl = content = this.createSectionContent(client, category, this.getElements(category));
        this.hookSectionContent(content);
        return section;
    }

    protected void hookSectionContent(Control content) {
        content.addListener(37, this.sectionContentListener);
    }

    private Object getSectionLayoutData() {
        return new RowData();
    }

    protected String getText(Object element) {
        if (this.getLabelProvider() instanceof ILabelProvider) {
            return ((ILabelProvider)this.getLabelProvider()).getText(element);
        }
        return element == null ? null : element.toString();
    }

    protected Image getImage(Object element) {
        if (this.getLabelProvider() instanceof ILabelProvider) {
            return ((ILabelProvider)this.getLabelProvider()).getImage(element);
        }
        return null;
    }

    protected Color getForeground(Object element) {
        if (this.getLabelProvider() instanceof IColorProvider) {
            return ((IColorProvider)this.getLabelProvider()).getForeground(element);
        }
        return null;
    }

    protected Color getBackground(Object element) {
        if (this.getLabelProvider() instanceof IColorProvider) {
            return ((IColorProvider)this.getLabelProvider()).getBackground(element);
        }
        return null;
    }

    protected Control createSectionContent(Composite parent, Object category, List<Object> elements) {
        Composite content = this.factory.createComposite(parent, 64);
        content.setBackground(parent.getBackground());
        content.setLayout((Layout)new GridLayout(1, true));
        return content;
    }

    protected void doUpdateItem(Widget item, Object element, boolean fullMap) {
        if (this.getCategories().contains(element)) {
            this.updateSection(element, this.getSection(element));
        }
    }

    protected void updateSection(Object category, Composite section) {
        section.setData(category);
        if (section instanceof Section) {
            Color background;
            Color foreground;
            Section s = (Section)section;
            String text = this.getText(category);
            if (text != null) {
                s.setText(text);
            }
            if ((foreground = this.getForeground(category)) != null) {
                s.setTitleBarForeground(foreground);
            }
            if ((background = this.getBackground(category)) != null) {
                s.setTitleBarBackground(background);
            }
        }
    }

    protected void internalRefresh(Object element) {
        if (this.getCategories().contains(element)) {
            this.updateSection(element, this.getSection(element));
        }
    }

    public void reveal(Object element) {
        Object category = this.getCategory(element);
        this.reveal(category, element);
    }

    protected void reveal(Object category, Object element) {
        Composite section = this.getSection(category);
        if (section != null && section instanceof Section) {
            ((Section)section).setExpanded(true);
            Point loc = section.toDisplay(0, 0);
            this.reveal(loc.x, loc.y);
        }
    }

    protected void reveal(int x, int y) {
        Point loc = this.container.toControl(x, y);
        Point origin = this.container.getOrigin();
        origin.x += loc.x;
        origin.y += loc.y;
        this.container.setOrigin(origin);
    }

    public Control getControl() {
        return this.container;
    }

    protected List getSelectionFromWidget() {
        ArrayList list = new ArrayList();
        for (Object category : this.getCategories()) {
            this.fillSelection(category, list);
        }
        return list;
    }

    protected abstract void fillSelection(Object var1, List var2);

    protected void setSelectionToWidget(List l, boolean reveal) {
    }

    protected void setSelectionToWidget(ISelection selection, boolean reveal) {
        for (Object category : this.getCategories()) {
            this.setSelectionToCategory(category, selection, reveal);
        }
    }

    protected abstract void setSelectionToCategory(Object var1, ISelection var2, boolean var3);

    protected void handleDispose(DisposeEvent event) {
        this.sections.clear();
        this.clearMap();
        if (this.factory != null) {
            this.factory.dispose();
            this.factory = null;
        }
        super.handleDispose(event);
    }
}

