/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.richtext;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.xmind.ui.color.ColorPicker;
import org.xmind.ui.color.ColorSelection;
import org.xmind.ui.color.IColorSelection;
import org.xmind.ui.color.PaletteContents;
import org.xmind.ui.internal.ToolkitImages;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.richtext.AlignCenterAction;
import org.xmind.ui.richtext.AlignLeftAction;
import org.xmind.ui.richtext.AlignRightAction;
import org.xmind.ui.richtext.AlignmentGroup;
import org.xmind.ui.richtext.BoldAction;
import org.xmind.ui.richtext.IRichTextAction;
import org.xmind.ui.richtext.IRichTextEditViewer;
import org.xmind.ui.richtext.IRichTextRenderer;
import org.xmind.ui.richtext.IndentAction;
import org.xmind.ui.richtext.ItalicAction;
import org.xmind.ui.richtext.OutdentAction;
import org.xmind.ui.richtext.RichTextActionBarContributor;
import org.xmind.ui.richtext.RichTextMessages;
import org.xmind.ui.richtext.RichTextRenderer;
import org.xmind.ui.richtext.RichTextUtils;
import org.xmind.ui.richtext.StrikeoutAction;
import org.xmind.ui.richtext.UnderlineAction;

public class SimpleRichTextActionBarContributor
extends RichTextActionBarContributor {
    private IRichTextAction boldAction;
    private IRichTextAction italicAction;
    private IRichTextAction underlineAction;
    private IRichTextAction strikeoutAction;
    private IRichTextAction alignLeftAction;
    private IRichTextAction alignCenterAction;
    private IRichTextAction alignRightAction;
    private IRichTextAction indentAction;
    private IRichTextAction outdentAction;
    private AlignmentGroup alignGroup;
    private ColorPicker foregroundPicker;
    private ColorPicker backgroundPicker;

    protected void makeActions(IRichTextEditViewer viewer) {
        this.boldAction = new BoldAction(viewer);
        this.addRichTextAction(this.boldAction);
        this.italicAction = new ItalicAction(viewer);
        this.addRichTextAction(this.italicAction);
        this.underlineAction = new UnderlineAction(viewer);
        this.addRichTextAction(this.underlineAction);
        this.strikeoutAction = new StrikeoutAction(viewer);
        this.addRichTextAction(this.strikeoutAction);
        this.alignLeftAction = new AlignLeftAction(viewer);
        this.addRichTextAction(this.alignLeftAction);
        this.alignCenterAction = new AlignCenterAction(viewer);
        this.addRichTextAction(this.alignCenterAction);
        this.alignRightAction = new AlignRightAction(viewer);
        this.addRichTextAction(this.alignRightAction);
        this.indentAction = new IndentAction(viewer);
        this.addRichTextAction(this.indentAction);
        this.outdentAction = new OutdentAction(viewer);
        this.addRichTextAction(this.outdentAction);
        this.alignGroup = new AlignmentGroup();
        this.alignGroup.add(this.alignLeftAction);
        this.alignGroup.add(this.alignCenterAction);
        this.alignGroup.add(this.alignRightAction);
        int colorChooserStyle = 1;
        this.foregroundPicker = new ColorPicker(colorChooserStyle, PaletteContents.getDefault(), RichTextMessages.ForegroundAction_text, ToolkitImages.get("foreground.gif"));
        this.foregroundPicker.setAutoColor(RichTextUtils.DEFAULT_FOREGROUND.getRGB());
        this.foregroundPicker.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SimpleRichTextActionBarContributor.this.foregroundChanged(event);
            }
        });
        this.backgroundPicker = new ColorPicker(colorChooserStyle, PaletteContents.getDefault(), RichTextMessages.BackgroundAction_text, ToolkitImages.get("background.gif"));
        this.backgroundPicker.setAutoColor(RichTextUtils.DEFAULT_BACKGROUND.getRGB());
        this.backgroundPicker.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SimpleRichTextActionBarContributor.this.backgroundChanged(event);
            }
        });
    }

    private void backgroundChanged(SelectionChangedEvent event) {
        IColorSelection selection = (IColorSelection)event.getSelection();
        Color c = selection.isAutomatic() ? null : ColorUtils.getColor(selection.getColor());
        this.getViewer().getRenderer().setSelectionBackground(c);
    }

    private void foregroundChanged(SelectionChangedEvent event) {
        IColorSelection selection = (IColorSelection)event.getSelection();
        Color c = selection.isAutomatic() ? null : ColorUtils.getColor(selection.getColor());
        this.getViewer().getRenderer().setSelectionForeground(c);
    }

    public void fillMenu(IMenuManager menu) {
        menu.add((IAction)this.boldAction);
        menu.add((IAction)this.italicAction);
        menu.add((IAction)this.underlineAction);
        menu.add((IAction)this.strikeoutAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.alignLeftAction);
        menu.add((IAction)this.alignCenterAction);
        menu.add((IAction)this.alignRightAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.indentAction);
        menu.add((IAction)this.outdentAction);
        menu.add((IContributionItem)new Separator());
        menu.add(this.foregroundPicker.getAction());
        menu.add(this.backgroundPicker.getAction());
    }

    public void fillToolBar(IToolBarManager toolbar) {
        toolbar.add((IAction)this.boldAction);
        toolbar.add((IAction)this.italicAction);
        toolbar.add((IAction)this.underlineAction);
        toolbar.add((IAction)this.strikeoutAction);
        toolbar.add((IContributionItem)new Separator());
        toolbar.add((IContributionItem)this.alignGroup);
        toolbar.add((IContributionItem)new Separator());
        toolbar.add((IAction)this.indentAction);
        toolbar.add((IAction)this.outdentAction);
        toolbar.add((IContributionItem)new Separator());
        toolbar.add((IContributionItem)this.foregroundPicker);
        toolbar.add((IContributionItem)this.backgroundPicker);
    }

    public void selectionChanged(ISelection selection, boolean enabled) {
        super.selectionChanged(selection, enabled);
        this.updateColorChoosers(enabled);
    }

    private void updateColorChoosers(boolean enabled) {
        IRichTextRenderer renderer = this.getViewer().getRenderer();
        StyleRange style = renderer instanceof RichTextRenderer ? ((RichTextRenderer)renderer).getSelectionTextStyle() : null;
        int foregroundType = style == null || style.foreground == null ? 1 : 3;
        this.foregroundPicker.setSelection(new ColorSelection(foregroundType, renderer.getSelectionForeground().getRGB()));
        this.foregroundPicker.getAction().setEnabled(enabled);
        int backgroundType = style == null || style.background == null ? 1 : 3;
        this.backgroundPicker.setSelection(new ColorSelection(backgroundType, renderer.getSelectionBackground().getRGB()));
        this.backgroundPicker.getAction().setEnabled(enabled);
    }

    public void dispose() {
        if (this.foregroundPicker != null) {
            this.foregroundPicker.dispose();
        }
        if (this.backgroundPicker != null) {
            this.backgroundPicker.dispose();
        }
        if (this.alignGroup != null) {
            this.alignGroup.dispose();
        }
        super.dispose();
    }
}

