/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.richtext;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IContextReplacingOperation;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.ObjectUndoContext;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.swt.custom.StyleRange;
import org.xmind.ui.richtext.Hyperlink;
import org.xmind.ui.richtext.IRichDocument;
import org.xmind.ui.richtext.IRichDocumentListener;
import org.xmind.ui.richtext.IRichDocumentUndoListener;
import org.xmind.ui.richtext.IRichDocumentUndoManager;
import org.xmind.ui.richtext.ImagePlaceHolder;
import org.xmind.ui.richtext.LineStyle;
import org.xmind.ui.richtext.RichDocumentUndoEvent;

public class RichDocumentUndoManager
implements IRichDocumentUndoManager {
    private ObjectUndoContext fUndoContext;
    private IRichDocument fDocument;
    private UndoableRichTextChange fCurrent;
    private DocumentListener fDocumentListener;
    private RichDocumentListener fRichDocumentListener;
    private boolean fFoldingIntoCompoundChange = false;
    private IOperationHistory fHistory;
    private IOperationHistoryListener fHistoryListener;
    private UndoableRichTextChange fLastAddedTextEdit = null;
    private long fPreservedRedoModificationStamp = -1L;
    private StringBuffer fPreservedTextBuffer;
    private long fPreservedUndoModificationStamp = -1L;
    private UndoableRichTextChange fPreviousDelete;
    private StringBuffer fTextBuffer;
    private boolean fInserting = false;
    private boolean fOverwriting = false;
    private ListenerList fDocumentUndoListeners;
    private List<Object> fConnected;
    private boolean ignoreDocumentChange = false;

    private void processRichChange(UndoableRichTextChange edit, StyleRange[] oldTextStyles, StyleRange[] newTextStyle, LineStyle[] oldLineStyles, LineStyle[] newLineStyle, ImagePlaceHolder[] oldImages, ImagePlaceHolder[] newImages, Hyperlink[] oldHyperlinks, Hyperlink[] newHyperlinks) {
        if (oldTextStyles != null && edit.oldTextStyles == null) {
            edit.oldTextStyles = oldTextStyles;
        }
        if (newTextStyle != null) {
            edit.newTextStyles = newTextStyle;
        }
        if (oldLineStyles != null && edit.oldLineStyles == null) {
            edit.oldLineStyles = oldLineStyles;
        }
        if (newLineStyle != null) {
            edit.newLineStyles = newLineStyle;
        }
        if (oldImages != null && edit.oldImages == null) {
            edit.oldImages = oldImages;
        }
        if (newImages != null) {
            edit.newImages = newImages;
        }
        if (oldHyperlinks != null && edit.oldHyperlinks == null) {
            edit.oldHyperlinks = oldHyperlinks;
        }
        if (newHyperlinks != null) {
            edit.newHyperlinks = newHyperlinks;
        }
    }

    public RichDocumentUndoManager(IRichDocument document) {
        Assert.isNotNull((Object)document);
        this.fDocument = document;
        this.fHistory = OperationHistoryFactory.getOperationHistory();
        this.fUndoContext = new ObjectUndoContext((Object)this.fDocument);
        this.fConnected = new ArrayList<Object>();
        this.fDocumentUndoListeners = new ListenerList();
    }

    public void addDocumentUndoListener(IRichDocumentUndoListener listener) {
        this.fDocumentUndoListeners.add((Object)listener);
    }

    public void removeDocumentUndoListener(IRichDocumentUndoListener listener) {
        this.fDocumentUndoListeners.remove((Object)listener);
    }

    public IUndoContext getUndoContext() {
        return this.fUndoContext;
    }

    public void commit() {
        if (this.fLastAddedTextEdit != this.fCurrent) {
            this.fCurrent.pretendCommit();
            if (this.fCurrent.isValid()) {
                this.addToOperationHistory(this.fCurrent);
            }
        }
        this.fCurrent.commit();
    }

    public void reset() {
        if (this.isConnected()) {
            this.shutdown();
            this.initialize();
        }
    }

    public boolean redoable() {
        return OperationHistoryFactory.getOperationHistory().canRedo((IUndoContext)this.fUndoContext);
    }

    public boolean undoable() {
        return OperationHistoryFactory.getOperationHistory().canUndo((IUndoContext)this.fUndoContext);
    }

    public void redo() throws ExecutionException {
        if (this.isConnected() && this.redoable()) {
            OperationHistoryFactory.getOperationHistory().redo(this.getUndoContext(), null, null);
        }
    }

    public void undo() throws ExecutionException {
        if (this.undoable()) {
            OperationHistoryFactory.getOperationHistory().undo((IUndoContext)this.fUndoContext, null, null);
        }
    }

    public void connect(Object client) {
        if (!this.isConnected()) {
            this.initialize();
        }
        if (!this.fConnected.contains(client)) {
            this.fConnected.add(client);
        }
    }

    public void disconnect(Object client) {
        this.fConnected.remove(client);
        if (!this.isConnected()) {
            this.shutdown();
        }
    }

    public void beginCompoundChange() {
        if (this.isConnected()) {
            this.fFoldingIntoCompoundChange = true;
            this.commit();
        }
    }

    public void endCompoundChange() {
        if (this.isConnected()) {
            this.fFoldingIntoCompoundChange = false;
            this.commit();
        }
    }

    public void setMaximalUndoLevel(int undoLimit) {
        this.fHistory.setLimit((IUndoContext)this.fUndoContext, undoLimit);
    }

    void fireDocumentUndo(int offset, String text, String preservedText, Object source, int eventType, boolean isCompound) {
        if (offset < 0) {
            return;
        }
        eventType = isCompound ? eventType | 0x10 : eventType;
        RichDocumentUndoEvent event = new RichDocumentUndoEvent(this.fDocument, offset, text, preservedText, eventType, source);
        Object[] listeners = this.fDocumentUndoListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IRichDocumentUndoListener)listeners[i]).documentUndoNotification(event);
            ++i;
        }
    }

    private void addListeners() {
        this.fHistoryListener = new HistoryListener();
        this.fHistory.addOperationHistoryListener(this.fHistoryListener);
        if (this.fDocumentListener == null && this.fDocument != null) {
            this.fDocumentListener = new DocumentListener();
            this.fDocument.addDocumentListener(this.fDocumentListener);
        }
        if (this.fRichDocumentListener == null && this.fDocument != null) {
            this.fRichDocumentListener = new RichDocumentListener();
            this.fDocument.addRichDocumentListener(this.fRichDocumentListener);
        }
    }

    private void removeListeners() {
        if (this.fRichDocumentListener != null && this.fDocument != null) {
            this.fDocument.removeRichDocumentListener(this.fRichDocumentListener);
            this.fRichDocumentListener = null;
        }
        if (this.fDocumentListener != null && this.fDocument != null) {
            this.fDocument.removeDocumentListener(this.fDocumentListener);
            this.fDocumentListener = null;
        }
        this.fHistory.removeOperationHistoryListener(this.fHistoryListener);
        this.fHistoryListener = null;
    }

    private void addToOperationHistory(UndoableRichTextChange edit) {
        if (!this.fFoldingIntoCompoundChange || edit instanceof UndoableCompoundRichTextChange) {
            this.fHistory.add((IUndoableOperation)edit);
            this.fLastAddedTextEdit = edit;
        }
    }

    private void disposeUndoHistory() {
        this.fHistory.dispose((IUndoContext)this.fUndoContext, true, true, true);
    }

    private void initializeUndoHistory() {
        if (this.fHistory != null && this.fUndoContext != null) {
            this.fHistory.dispose((IUndoContext)this.fUndoContext, true, true, false);
        }
    }

    private boolean isWhitespaceText(String text) {
        if (text == null || text.length() == 0) {
            return false;
        }
        String[] delimiters = this.fDocument.getLegalLineDelimiters();
        int index = TextUtilities.startsWith((String[])delimiters, (String)text);
        if (index > -1) {
            int length = text.length();
            int i = delimiters[index].length();
            while (i < length) {
                char c = text.charAt(i);
                if (c != ' ' && c != '\t') {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private void processChange(int modelStart, int modelEnd, String insertedText, String replacedText, long beforeChangeModificationStamp, long afterChangeModificationStamp) {
        if (insertedText == null) {
            insertedText = "";
        }
        if (replacedText == null) {
            replacedText = "";
        }
        int length = insertedText.length();
        if (this.fCurrent.fUndoModificationStamp == -1L) {
            this.fCurrent.fUndoModificationStamp = beforeChangeModificationStamp;
        }
        if (modelEnd < modelStart) {
            int tmp = modelEnd;
            modelEnd = modelStart;
            modelStart = tmp;
        }
        if (modelStart == modelEnd) {
            if (length == 1 || this.isWhitespaceText(insertedText)) {
                if (!this.fInserting || modelStart != this.fCurrent.fStart + this.fTextBuffer.length()) {
                    this.fCurrent.fRedoModificationStamp = beforeChangeModificationStamp;
                    if (this.fCurrent.attemptCommit()) {
                        this.fCurrent.fUndoModificationStamp = beforeChangeModificationStamp;
                    }
                    this.fInserting = true;
                }
                if (this.fCurrent.fStart < 0) {
                    this.fCurrent.fStart = this.fCurrent.fEnd = modelStart;
                }
                if (length > 0) {
                    this.fTextBuffer.append(insertedText);
                }
            } else if (length > 0) {
                this.fCurrent.fRedoModificationStamp = beforeChangeModificationStamp;
                if (this.fCurrent.attemptCommit()) {
                    this.fCurrent.fUndoModificationStamp = beforeChangeModificationStamp;
                }
                this.fCurrent.fStart = this.fCurrent.fEnd = modelStart;
                this.fTextBuffer.append(insertedText);
            }
        } else if (length == 0) {
            length = replacedText.length();
            String[] delimiters = this.fDocument.getLegalLineDelimiters();
            if (length == 1 || TextUtilities.equals((String[])delimiters, (String)replacedText) > -1) {
                if (this.fPreviousDelete.fStart == modelStart && this.fPreviousDelete.fEnd == modelEnd) {
                    if (this.fCurrent.fStart == modelEnd && this.fCurrent.fEnd == modelStart) {
                        this.fCurrent.fStart = modelStart;
                        this.fCurrent.fEnd = modelEnd;
                    }
                    this.fPreservedTextBuffer.append(replacedText);
                    ++this.fCurrent.fEnd;
                } else if (this.fPreviousDelete.fStart == modelEnd) {
                    this.fPreservedTextBuffer.insert(0, replacedText);
                    this.fCurrent.fStart = modelStart;
                } else {
                    this.fCurrent.fRedoModificationStamp = beforeChangeModificationStamp;
                    if (this.fCurrent.attemptCommit()) {
                        this.fCurrent.fUndoModificationStamp = beforeChangeModificationStamp;
                    }
                    this.fPreservedTextBuffer.append(replacedText);
                    this.fCurrent.fStart = modelStart;
                    this.fCurrent.fEnd = modelEnd;
                }
                this.fPreviousDelete.set(modelStart, modelEnd);
            } else if (length > 0) {
                this.fCurrent.fRedoModificationStamp = beforeChangeModificationStamp;
                if (this.fCurrent.attemptCommit()) {
                    this.fCurrent.fUndoModificationStamp = beforeChangeModificationStamp;
                }
                this.fCurrent.fStart = modelStart;
                this.fCurrent.fEnd = modelEnd;
                this.fPreservedTextBuffer.append(replacedText);
            }
        } else {
            if (length == 1) {
                length = replacedText.length();
                String[] delimiters = this.fDocument.getLegalLineDelimiters();
                if (length == 1 || TextUtilities.equals((String[])delimiters, (String)replacedText) > -1) {
                    if (!this.fOverwriting || modelStart != this.fCurrent.fStart + this.fTextBuffer.length()) {
                        this.fCurrent.fRedoModificationStamp = beforeChangeModificationStamp;
                        if (this.fCurrent.attemptCommit()) {
                            this.fCurrent.fUndoModificationStamp = beforeChangeModificationStamp;
                        }
                        this.fOverwriting = true;
                    }
                    if (this.fCurrent.fStart < 0) {
                        this.fCurrent.fStart = modelStart;
                    }
                    this.fCurrent.fEnd = modelEnd;
                    this.fTextBuffer.append(insertedText);
                    this.fPreservedTextBuffer.append(replacedText);
                    this.fCurrent.fRedoModificationStamp = afterChangeModificationStamp;
                    return;
                }
            }
            this.fCurrent.fRedoModificationStamp = beforeChangeModificationStamp;
            if (this.fCurrent.attemptCommit()) {
                this.fCurrent.fUndoModificationStamp = beforeChangeModificationStamp;
            }
            this.fCurrent.fStart = modelStart;
            this.fCurrent.fEnd = modelEnd;
            this.fTextBuffer.append(insertedText);
            this.fPreservedTextBuffer.append(replacedText);
        }
        this.fCurrent.fRedoModificationStamp = afterChangeModificationStamp;
    }

    private void initialize() {
        this.initializeUndoHistory();
        this.fCurrent = new UndoableRichTextChange(this);
        this.fPreviousDelete = new UndoableRichTextChange(this);
        this.fTextBuffer = new StringBuffer();
        this.fPreservedTextBuffer = new StringBuffer();
        this.addListeners();
    }

    private void resetProcessChangeState() {
        this.fInserting = false;
        this.fOverwriting = false;
        this.fPreviousDelete.reinitialize();
    }

    private void shutdown() {
        this.removeListeners();
        this.fCurrent = null;
        this.fPreviousDelete = null;
        this.fTextBuffer = null;
        this.fPreservedTextBuffer = null;
        this.disposeUndoHistory();
    }

    boolean isConnected() {
        if (this.fConnected == null) {
            return false;
        }
        return !this.fConnected.isEmpty();
    }

    public void transferUndoHistory(IRichDocumentUndoManager manager) {
        IUndoContext oldUndoContext = manager.getUndoContext();
        IUndoableOperation[] operations = OperationHistoryFactory.getOperationHistory().getUndoHistory(oldUndoContext);
        int i = 0;
        while (i < operations.length) {
            IUndoableOperation op = operations[i];
            if (op instanceof IContextReplacingOperation) {
                ((IContextReplacingOperation)op).replaceContext(oldUndoContext, this.getUndoContext());
            } else {
                op.addContext(this.getUndoContext());
                op.removeContext(oldUndoContext);
            }
            if (op instanceof UndoableRichTextChange) {
                ((UndoableRichTextChange)op).fDocumentUndoManager = this;
            }
            ++i;
        }
        IUndoableOperation op = OperationHistoryFactory.getOperationHistory().getUndoOperation(this.getUndoContext());
        UndoableRichTextChange cmd = new UndoableRichTextChange(this);
        cmd.fEnd = 0;
        cmd.fStart = 0;
        cmd.fPreservedText = "";
        cmd.fText = "";
        if (this.fDocument instanceof IDocumentExtension4) {
            cmd.fRedoModificationStamp = ((IDocumentExtension4)this.fDocument).getModificationStamp();
            if (op instanceof UndoableRichTextChange) {
                cmd.fUndoModificationStamp = ((UndoableRichTextChange)op).fRedoModificationStamp;
            }
        }
        this.addToOperationHistory(cmd);
    }

    private class DocumentListener
    implements IDocumentListener {
        private String fReplacedText;

        private DocumentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
            if (RichDocumentUndoManager.this.ignoreDocumentChange) {
                return;
            }
            try {
                this.fReplacedText = event.getDocument().get(event.getOffset(), event.getLength());
                RichDocumentUndoManager.this.fPreservedUndoModificationStamp = event.getModificationStamp();
            }
            catch (BadLocationException badLocationException) {
                this.fReplacedText = null;
            }
        }

        public void documentChanged(DocumentEvent event) {
            if (RichDocumentUndoManager.this.ignoreDocumentChange) {
                return;
            }
            RichDocumentUndoManager.this.fPreservedRedoModificationStamp = event.getModificationStamp();
            IUndoableOperation op = RichDocumentUndoManager.this.fHistory.getUndoOperation((IUndoContext)RichDocumentUndoManager.this.fUndoContext);
            boolean wasValid = false;
            if (op != null) {
                wasValid = op.canUndo();
            }
            RichDocumentUndoManager.this.processChange(event.getOffset(), event.getOffset() + event.getLength(), event.getText(), this.fReplacedText, RichDocumentUndoManager.this.fPreservedUndoModificationStamp, RichDocumentUndoManager.this.fPreservedRedoModificationStamp);
            RichDocumentUndoManager.this.fCurrent.pretendCommit();
            if (op == RichDocumentUndoManager.this.fCurrent) {
                if (wasValid != RichDocumentUndoManager.this.fCurrent.isValid()) {
                    RichDocumentUndoManager.this.fHistory.operationChanged(op);
                }
            } else if (RichDocumentUndoManager.this.fCurrent != RichDocumentUndoManager.this.fLastAddedTextEdit && RichDocumentUndoManager.this.fCurrent.isValid()) {
                RichDocumentUndoManager.this.addToOperationHistory(RichDocumentUndoManager.this.fCurrent);
            }
        }
    }

    private class HistoryListener
    implements IOperationHistoryListener {
        private IUndoableOperation fOperation;

        private HistoryListener() {
        }

        public void historyNotification(OperationHistoryEvent event) {
            int type = event.getEventType();
            switch (type) {
                case 2: 
                case 3: {
                    if (!event.getOperation().hasContext((IUndoContext)RichDocumentUndoManager.this.fUndoContext)) break;
                    if (event.getOperation() instanceof UndoableRichTextChange) {
                        RichDocumentUndoManager.this.ignoreDocumentChange = true;
                        if (type == 3 && RichDocumentUndoManager.this.fFoldingIntoCompoundChange) {
                            RichDocumentUndoManager.this.endCompoundChange();
                        }
                    } else {
                        RichDocumentUndoManager.this.commit();
                        RichDocumentUndoManager.this.fLastAddedTextEdit = null;
                    }
                    this.fOperation = event.getOperation();
                    break;
                }
                case 7: 
                case 9: 
                case 10: {
                    if (event.getOperation() != this.fOperation) break;
                    RichDocumentUndoManager.this.ignoreDocumentChange = false;
                    this.fOperation = null;
                }
            }
        }
    }

    private class RichDocumentListener
    implements IRichDocumentListener {
        private RichDocumentListener() {
        }

        public void imageChanged(IRichDocument document, ImagePlaceHolder[] oldImages, ImagePlaceHolder[] newImages) {
            this.handleRichDocumentEvent(null, null, null, null, oldImages, newImages, null, null);
        }

        public void lineStyleChanged(IRichDocument document, LineStyle[] oldLineStyles, LineStyle[] newLineStyles) {
            this.handleRichDocumentEvent(null, null, oldLineStyles, newLineStyles, null, null, null, null);
        }

        public void textStyleChanged(IRichDocument document, StyleRange[] oldTextStyles, StyleRange[] newTextStyles) {
            this.handleRichDocumentEvent(oldTextStyles, newTextStyles, null, null, null, null, null, null);
        }

        public void hyperlinkChanged(IRichDocument document, Hyperlink[] oldHyperlinks, Hyperlink[] newHyperlinks) {
            this.handleRichDocumentEvent(null, null, null, null, null, null, oldHyperlinks, newHyperlinks);
        }

        private void handleRichDocumentEvent(StyleRange[] oldStyles, StyleRange[] newStyles, LineStyle[] oldLineStyles, LineStyle[] newLineStyle, ImagePlaceHolder[] oldImages, ImagePlaceHolder[] newImages, Hyperlink[] oldHyperlinks, Hyperlink[] newHyperlinks) {
            if (RichDocumentUndoManager.this.ignoreDocumentChange) {
                return;
            }
            IUndoableOperation op = RichDocumentUndoManager.this.fHistory.getUndoOperation((IUndoContext)RichDocumentUndoManager.this.fUndoContext);
            boolean wasValid = false;
            if (op != null) {
                wasValid = op.canUndo();
            }
            RichDocumentUndoManager.this.processRichChange(RichDocumentUndoManager.this.fCurrent, oldStyles, newStyles, oldLineStyles, newLineStyle, oldImages, newImages, oldHyperlinks, newHyperlinks);
            if (op == RichDocumentUndoManager.this.fCurrent) {
                if (wasValid != RichDocumentUndoManager.this.fCurrent.isValid()) {
                    RichDocumentUndoManager.this.fHistory.operationChanged(op);
                }
            } else if (RichDocumentUndoManager.this.fCurrent != RichDocumentUndoManager.this.fLastAddedTextEdit && RichDocumentUndoManager.this.fCurrent.isValid()) {
                RichDocumentUndoManager.this.addToOperationHistory(RichDocumentUndoManager.this.fCurrent);
            }
        }
    }

    private static class UndoableCompoundRichTextChange
    extends UndoableRichTextChange {
        private List<UndoableRichTextChange> fChanges = new ArrayList<UndoableRichTextChange>();

        UndoableCompoundRichTextChange(RichDocumentUndoManager manager) {
            super(manager);
        }

        protected void add(UndoableRichTextChange change) {
            this.fChanges.add(change);
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable uiInfo) {
            int size = this.fChanges.size();
            if (size > 0) {
                UndoableRichTextChange c = this.fChanges.get(0);
                this.fDocumentUndoManager.fireDocumentUndo(c.fStart, c.fPreservedText, c.fText, uiInfo, 1, true);
                int i = size - 1;
                while (i >= 0) {
                    c = this.fChanges.get(i);
                    c.undoTextChange();
                    --i;
                }
                this.fDocumentUndoManager.resetProcessChangeState();
                this.fDocumentUndoManager.fireDocumentUndo(c.fStart, c.fPreservedText, c.fText, uiInfo, 4, true);
            }
            this.undoRichTextChange();
            return Status.OK_STATUS;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable uiInfo) {
            int size = this.fChanges.size();
            if (size > 0) {
                UndoableRichTextChange c = this.fChanges.get(size - 1);
                this.fDocumentUndoManager.fireDocumentUndo(c.fStart, c.fText, c.fPreservedText, uiInfo, 2, true);
                int i = 0;
                while (i <= size - 1) {
                    c = this.fChanges.get(i);
                    c.redoTextChange();
                    ++i;
                }
                this.fDocumentUndoManager.resetProcessChangeState();
                this.fDocumentUndoManager.fireDocumentUndo(c.fStart, c.fText, c.fPreservedText, uiInfo, 8, true);
            }
            this.redoRichTextChange();
            return Status.OK_STATUS;
        }

        protected void updateTextChange() {
            super.updateTextChange();
            UndoableRichTextChange c = new UndoableRichTextChange(this.fDocumentUndoManager);
            c.fStart = this.fStart;
            c.fEnd = this.fEnd;
            c.fText = this.fText;
            c.fPreservedText = this.fPreservedText;
            c.fUndoModificationStamp = this.fUndoModificationStamp;
            c.fRedoModificationStamp = this.fRedoModificationStamp;
            this.add(c);
            this.reinitializeTextChange();
        }

        protected UndoableRichTextChange createCurrent() {
            if (!this.fDocumentUndoManager.fFoldingIntoCompoundChange) {
                return new UndoableRichTextChange(this.fDocumentUndoManager);
            }
            this.reinitialize();
            return this;
        }

        protected void commit() {
            if (this.fStart > -1) {
                this.updateTextChange();
            }
            this.fDocumentUndoManager.fCurrent = this.createCurrent();
            this.fDocumentUndoManager.resetProcessChangeState();
        }

        protected boolean isValid() {
            return this.fStart > -1 || this.fChanges.size() > 0 || this.oldImages != null && this.newImages != null || this.oldLineStyles != null && this.newLineStyles != null || this.oldTextStyles != null && this.newTextStyles != null || this.oldHyperlinks != null && this.newHyperlinks != null;
        }

        protected long getUndoModificationStamp() {
            if (this.fStart > -1) {
                return super.getUndoModificationStamp();
            }
            if (this.fChanges.size() > 0) {
                return this.fChanges.get(0).getUndoModificationStamp();
            }
            return this.fUndoModificationStamp;
        }

        protected long getRedoModificationStamp() {
            if (this.fStart > -1) {
                return super.getRedoModificationStamp();
            }
            if (this.fChanges.size() > 0) {
                return this.fChanges.get(this.fChanges.size() - 1).getRedoModificationStamp();
            }
            return this.fRedoModificationStamp;
        }
    }

    private static class UndoableRichTextChange
    extends AbstractOperation {
        protected int fStart = -1;
        protected int fEnd = -1;
        protected String fText;
        protected String fPreservedText;
        protected long fUndoModificationStamp = -1L;
        protected long fRedoModificationStamp = -1L;
        protected RichDocumentUndoManager fDocumentUndoManager;
        protected StyleRange[] oldTextStyles;
        protected StyleRange[] newTextStyles;
        protected LineStyle[] oldLineStyles;
        protected LineStyle[] newLineStyles;
        protected ImagePlaceHolder[] oldImages;
        protected ImagePlaceHolder[] newImages;
        protected Hyperlink[] oldHyperlinks;
        protected Hyperlink[] newHyperlinks;

        UndoableRichTextChange(RichDocumentUndoManager manager) {
            super("");
            this.fDocumentUndoManager = manager;
            this.addContext(manager.getUndoContext());
        }

        protected void reinitialize() {
            this.reinitializeTextChange();
            this.oldTextStyles = null;
            this.newTextStyles = null;
            this.oldLineStyles = null;
            this.newLineStyles = null;
            this.oldImages = null;
            this.newImages = null;
            this.oldHyperlinks = null;
            this.newHyperlinks = null;
        }

        protected void reinitializeTextChange() {
            this.fEnd = -1;
            this.fStart = -1;
            this.fPreservedText = null;
            this.fText = null;
            this.fUndoModificationStamp = -1L;
            this.fRedoModificationStamp = -1L;
        }

        protected void set(int start, int end) {
            this.fStart = start;
            this.fEnd = end;
            this.fText = null;
            this.fPreservedText = null;
        }

        public void dispose() {
            this.reinitialize();
        }

        protected void undoTextChange() {
            if (this.fStart < 0 || this.fEnd < 0) {
                return;
            }
            try {
                if (this.fDocumentUndoManager.fDocument instanceof IDocumentExtension4) {
                    ((IDocumentExtension4)this.fDocumentUndoManager.fDocument).replace(this.fStart, this.fText.length(), this.fPreservedText, this.fUndoModificationStamp);
                } else {
                    this.fDocumentUndoManager.fDocument.replace(this.fStart, this.fText.length(), this.fPreservedText);
                }
            }
            catch (BadLocationException badLocationException) {}
        }

        protected void undoRichTextChange() {
            if (this.oldTextStyles != null) {
                this.fDocumentUndoManager.fDocument.setTextStyles(this.oldTextStyles);
            }
            if (this.oldLineStyles != null) {
                this.fDocumentUndoManager.fDocument.setLineStyles(this.oldLineStyles);
            }
            if (this.oldImages != null) {
                this.fDocumentUndoManager.fDocument.setImages(this.oldImages);
            }
            if (this.oldHyperlinks != null) {
                this.fDocumentUndoManager.fDocument.setHyperlinks(this.oldHyperlinks);
            }
        }

        public boolean canUndo() {
            if (this.isValid()) {
                if (this.fStart >= 0 && this.fEnd >= 0 && this.fText != null && this.fDocumentUndoManager.fDocument instanceof IDocumentExtension4) {
                    boolean canUndo;
                    long docStamp = ((IDocumentExtension4)this.fDocumentUndoManager.fDocument).getModificationStamp();
                    boolean bl = canUndo = docStamp == -1L || docStamp == this.getRedoModificationStamp();
                    if (!canUndo && this == this.fDocumentUndoManager.fHistory.getUndoOperation((IUndoContext)this.fDocumentUndoManager.fUndoContext) && this != this.fDocumentUndoManager.fCurrent && !this.fDocumentUndoManager.fCurrent.isValid() && ((RichDocumentUndoManager)this.fDocumentUndoManager).fCurrent.fUndoModificationStamp != -1L) {
                        boolean bl2 = canUndo = ((RichDocumentUndoManager)this.fDocumentUndoManager).fCurrent.fRedoModificationStamp == docStamp;
                    }
                    if (!canUndo && this == this.fDocumentUndoManager.fHistory.getUndoOperation((IUndoContext)this.fDocumentUndoManager.fUndoContext) && this instanceof UndoableCompoundRichTextChange && this == this.fDocumentUndoManager.fCurrent && this.fStart == -1 && ((RichDocumentUndoManager)this.fDocumentUndoManager).fCurrent.fRedoModificationStamp != -1L) {
                        boolean bl3 = ((RichDocumentUndoManager)this.fDocumentUndoManager).fCurrent.fRedoModificationStamp == docStamp;
                    }
                }
                return true;
            }
            return false;
        }

        public boolean canRedo() {
            if (this.isValid()) {
                if (this.fStart >= 0 && this.fEnd >= 0 && this.fText != null && this.fDocumentUndoManager.fDocument instanceof IDocumentExtension4) {
                    long docStamp = ((IDocumentExtension4)this.fDocumentUndoManager.fDocument).getModificationStamp();
                    return docStamp == -1L || docStamp == this.getUndoModificationStamp();
                }
                return true;
            }
            return false;
        }

        public boolean canExecute() {
            return this.fDocumentUndoManager.isConnected();
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable uiInfo) {
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable uiInfo) {
            if (this.isValid()) {
                this.fDocumentUndoManager.fireDocumentUndo(this.fStart, this.fPreservedText, this.fText, uiInfo, 1, false);
                this.undoTextChange();
                this.undoRichTextChange();
                this.fDocumentUndoManager.resetProcessChangeState();
                this.fDocumentUndoManager.fireDocumentUndo(this.fStart, this.fPreservedText, this.fText, uiInfo, 4, false);
                return Status.OK_STATUS;
            }
            return IOperationHistory.OPERATION_INVALID_STATUS;
        }

        protected void redoTextChange() {
            if (this.fStart < 0 || this.fEnd < 0) {
                return;
            }
            try {
                if (this.fDocumentUndoManager.fDocument instanceof IDocumentExtension4) {
                    ((IDocumentExtension4)this.fDocumentUndoManager.fDocument).replace(this.fStart, this.fEnd - this.fStart, this.fText, this.fRedoModificationStamp);
                } else {
                    this.fDocumentUndoManager.fDocument.replace(this.fStart, this.fEnd - this.fStart, this.fText);
                }
            }
            catch (BadLocationException badLocationException) {}
        }

        protected void redoRichTextChange() {
            if (this.newTextStyles != null) {
                this.fDocumentUndoManager.fDocument.setTextStyles(this.newTextStyles);
            }
            if (this.newLineStyles != null) {
                this.fDocumentUndoManager.fDocument.setLineStyles(this.newLineStyles);
            }
            if (this.newImages != null) {
                this.fDocumentUndoManager.fDocument.setImages(this.newImages);
            }
            if (this.newHyperlinks != null) {
                this.fDocumentUndoManager.fDocument.setHyperlinks(this.newHyperlinks);
            }
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable uiInfo) {
            if (this.isValid()) {
                this.redoTextChange();
                this.redoRichTextChange();
                this.fDocumentUndoManager.resetProcessChangeState();
                this.fDocumentUndoManager.fireDocumentUndo(this.fStart, this.fText, this.fPreservedText, uiInfo, 8, false);
                return Status.OK_STATUS;
            }
            return IOperationHistory.OPERATION_INVALID_STATUS;
        }

        protected void updateTextChange() {
            this.fText = this.fDocumentUndoManager.fTextBuffer.toString();
            this.fDocumentUndoManager.fTextBuffer.setLength(0);
            this.fPreservedText = this.fDocumentUndoManager.fPreservedTextBuffer.toString();
            this.fDocumentUndoManager.fPreservedTextBuffer.setLength(0);
        }

        protected UndoableRichTextChange createCurrent() {
            if (this.fDocumentUndoManager.fFoldingIntoCompoundChange) {
                return new UndoableCompoundRichTextChange(this.fDocumentUndoManager);
            }
            return new UndoableRichTextChange(this.fDocumentUndoManager);
        }

        protected void commit() {
            if (!this.isValid()) {
                if (this.fDocumentUndoManager.fFoldingIntoCompoundChange) {
                    this.fDocumentUndoManager.fCurrent = this.createCurrent();
                } else {
                    this.reinitialize();
                }
            } else {
                this.updateTextChange();
                this.fDocumentUndoManager.fCurrent = this.createCurrent();
            }
            this.fDocumentUndoManager.resetProcessChangeState();
        }

        protected void pretendCommit() {
            if (this.fStart > -1) {
                this.fText = this.fDocumentUndoManager.fTextBuffer.toString();
                this.fPreservedText = this.fDocumentUndoManager.fPreservedTextBuffer.toString();
            }
        }

        protected boolean attemptCommit() {
            this.pretendCommit();
            if (this.isValid()) {
                this.fDocumentUndoManager.commit();
                return true;
            }
            return false;
        }

        protected boolean isValid() {
            return this.fStart > -1 && this.fEnd > -1 && this.fText != null || this.oldImages != null && this.newImages != null || this.oldLineStyles != null && this.newLineStyles != null || this.oldTextStyles != null && this.newTextStyles != null || this.oldHyperlinks != null && this.newHyperlinks != null;
        }

        public String toString() {
            String delimiter = ", ";
            StringBuffer text = new StringBuffer(super.toString());
            text.append("\n");
            text.append(((Object)((Object)this)).getClass().getName());
            text.append(" undo modification stamp: ");
            text.append(this.fUndoModificationStamp);
            text.append(" redo modification stamp: ");
            text.append(this.fRedoModificationStamp);
            text.append(" start: ");
            text.append(this.fStart);
            text.append(delimiter);
            text.append("end: ");
            text.append(this.fEnd);
            text.append(delimiter);
            text.append("text: '");
            text.append(this.fText);
            text.append('\'');
            text.append(delimiter);
            text.append("preservedText: '");
            text.append(this.fPreservedText);
            text.append('\'');
            return text.toString();
        }

        protected long getUndoModificationStamp() {
            return this.fUndoModificationStamp;
        }

        protected long getRedoModificationStamp() {
            return this.fRedoModificationStamp;
        }
    }
}

