/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.resources;

import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.xmind.ui.resources.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontUtils {
    private static List<String> availableFontNames = null;
    private static List<IFontNameListCallback> callbacks = null;

    private FontUtils() {
    }

    public static List<String> getAvailableFontNames() {
        if (availableFontNames == null) {
            availableFontNames = FontUtils.findAvailableFontNames();
        }
        return availableFontNames;
    }

    private static ArrayList<String> findAvailableFontNames() {
        String[] names = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        ArrayList<String> list = new ArrayList<String>(names.length);
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            FontData[] fontList = display.getFontList(name, true);
            if (fontList != null && fontList.length > 0) {
                list.add(name);
            }
            ++n2;
        }
        list.trimToSize();
        return list;
    }

    public static void fetchAvailableFontNames(final Display display, final IFontNameListCallback callback) {
        if (callback == null) {
            return;
        }
        if (availableFontNames != null) {
            callback.setAvailableFontNames(availableFontNames);
            return;
        }
        if (display == null || display.isDisposed()) {
            return;
        }
        if (callbacks != null) {
            if (callbacks.contains(callback)) {
                return;
            }
            callbacks.add(callback);
            return;
        }
        callbacks = new ArrayList<IFontNameListCallback>();
        callbacks.add(callback);
        Job fetch = new Job(Messages.FetchFontList_jobName){

            protected IStatus run(IProgressMonitor monitor) {
                FontUtils.fetchAvailableFontNames(display, callback, monitor);
                return new Status(0, "org.xmind.ui.toolkit", "Font Name Fetched");
            }
        };
        fetch.schedule();
    }

    private static void fetchAvailableFontNames(final Display display, final IFontNameListCallback callback, final IProgressMonitor progress) {
        if (display.isDisposed()) {
            progress.done();
            return;
        }
        if (availableFontNames != null) {
            progress.done();
            display.asyncExec(new Runnable(){

                public void run() {
                    callback.setAvailableFontNames(availableFontNames);
                }
            });
            return;
        }
        new Runnable(){

            public void run() {
                progress.beginTask(null, 10);
                progress.subTask(Messages.FetchFontNames);
                String[] names = this.getAllFontNames(progress);
                if (names.length == 0) {
                    availableFontNames = Collections.emptyList();
                    this.notifyCallbacks();
                    return;
                }
                progress.worked(1);
                progress.subTask(Messages.FilterFontList);
                this.filterFontList((IProgressMonitor)new SubProgressMonitor(progress, 90), names);
            }

            private String[] getAllFontNames(IProgressMonitor progress2) {
                final String[][] nameList = new String[1][];
                Thread th = new Thread(new Runnable(){

                    public void run() {
                        nameList[0] = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
                    }
                }, "Get Available Font Family Names From AWT-GraphicsEnvironment");
                th.setDaemon(true);
                th.start();
                while (nameList[0] == null) {
                    if (progress2.isCanceled()) {
                        nameList[0] = new String[0];
                        break;
                    }
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {
                        nameList[0] = new String[0];
                        break;
                    }
                }
                return nameList[0];
            }

            private void filterFontList(IProgressMonitor monitor, String[] names) {
                monitor.beginTask(null, names.length);
                final ArrayList list = new ArrayList(names.length);
                Iterator<String> it = Arrays.asList(names).iterator();
                while (it.hasNext()) {
                    if (display.isDisposed()) {
                        progress.done();
                        return;
                    }
                    if (availableFontNames != null) {
                        this.notifyCallbacks();
                        return;
                    }
                    final String name = it.next();
                    progress.subTask(name);
                    display.syncExec(new Runnable(){

                        public void run() {
                            FontData[] fontList = display.getFontList(name, true);
                            if (fontList != null && fontList.length > 0) {
                                list.add(name);
                            }
                        }
                    });
                    Thread.yield();
                    progress.worked(1);
                }
                list.trimToSize();
                availableFontNames = list;
                this.notifyCallbacks();
            }

            private synchronized void notifyCallbacks() {
                progress.done();
                if (callbacks == null) {
                    return;
                }
                int i = 0;
                while (i < callbacks.size()) {
                    final IFontNameListCallback callback = (IFontNameListCallback)callbacks.get(i);
                    if (callback != null) {
                        display.asyncExec(new Runnable(){

                            public void run() {
                                callback.setAvailableFontNames(availableFontNames);
                            }
                        });
                    }
                    ++i;
                }
                callbacks = null;
            }
        }.run();
    }

    public static Font getFont(String key, FontData[] fontData) {
        if (key == null && (key = FontUtils.toString(fontData)) == null) {
            return null;
        }
        FontRegistry reg = JFaceResources.getFontRegistry();
        if (!reg.hasValueFor(key) && !FontUtils.isDefaultKey(key)) {
            if (fontData == null && (fontData = FontUtils.toFontData(key)) == null) {
                return null;
            }
            reg.put(key, fontData);
        }
        return reg.get(key);
    }

    public static Font getBold(String key, FontData[] fontData) {
        if (key == null && (key = FontUtils.toString(fontData)) == null) {
            return null;
        }
        FontRegistry reg = JFaceResources.getFontRegistry();
        if (!reg.hasValueFor(key) && !FontUtils.isDefaultKey(key)) {
            if (fontData == null && (fontData = FontUtils.toFontData(key)) == null) {
                return null;
            }
            reg.put(key, fontData);
        }
        return reg.getBold(key);
    }

    public static Font getItalic(String key, FontData[] fontData) {
        if (key == null && (key = FontUtils.toString(fontData)) == null) {
            return null;
        }
        FontRegistry reg = JFaceResources.getFontRegistry();
        if (!reg.hasValueFor(key) && !FontUtils.isDefaultKey(key)) {
            if (fontData == null && (fontData = FontUtils.toFontData(key)) == null) {
                return null;
            }
            reg.put(key, fontData);
        }
        return reg.getItalic(key);
    }

    public static FontData[] toFontData(String string) {
        String[] eles;
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).startsWith("(") && string.endsWith(")") && (eles = string.substring(1, string.length() - 1).split(",")).length > 0) {
            String name = eles[0].trim();
            if ("".equals(name)) {
                name = JFaceResources.getFontRegistry().getFontData("org.eclipse.jface.defaultfont")[0].getName();
            }
            int size = -1;
            if (eles.length > 1) {
                try {
                    size = Integer.parseInt(eles[1].trim());
                }
                catch (Exception exception) {}
            }
            if (size < 0) {
                size = JFaceResources.getFontRegistry().getFontData("org.eclipse.jface.defaultfont")[0].getHeight();
            }
            int style = -1;
            if (eles.length > 2) {
                style = 0;
                String styles = eles[2].trim().toLowerCase();
                if (!"".equals(styles)) {
                    if (styles.indexOf(98) >= 0) {
                        style |= 1;
                    }
                    if (styles.indexOf(105) >= 0) {
                        style |= 2;
                    }
                }
            }
            if (style < 0) {
                style = JFaceResources.getFontRegistry().getFontData("org.eclipse.jface.defaultfont")[0].getStyle();
            }
            FontData[] fontData = new FontData[]{new FontData(name, size, style)};
            return fontData;
        }
        return null;
    }

    public static String toString(FontData[] fontData) {
        if (fontData == null || fontData.length == 0) {
            return null;
        }
        return FontUtils.toString(fontData[0]);
    }

    public static String toString(FontData fontData) {
        int style = fontData.getStyle();
        return FontUtils.toString(fontData.getName(), fontData.getHeight(), (style & 1) != 0, (style & 2) != 0);
    }

    public static String toString(String name, int height, boolean bold, boolean italic) {
        StringBuilder sb = new StringBuilder(10);
        sb.append("(");
        sb.append(name);
        sb.append(",");
        sb.append(height);
        if (bold || italic) {
            sb.append(",");
            if (bold) {
                sb.append("b");
            }
            if (italic) {
                sb.append("i");
            }
        }
        sb.append(")");
        return sb.toString();
    }

    public static Font getFont(String name, int size, boolean bold, boolean italic) {
        int style = 0;
        if (bold) {
            style |= 1;
        }
        if (italic) {
            style |= 2;
        }
        FontData fd = new FontData(name, size, style);
        String key = FontUtils.toString(name, size, bold, italic);
        return FontUtils.getFont(key, new FontData[]{fd});
    }

    public static Font getFont(FontData fontData) {
        return FontUtils.getFont(null, new FontData[]{fontData});
    }

    public static Font getFont(String key) {
        return FontUtils.getFont(key, null);
    }

    public static Font getFont(FontData[] fontData) {
        return FontUtils.getFont(null, fontData);
    }

    public static FontData[] newName(FontData[] fontData, String name) {
        if (name == null || fontData == null) {
            return fontData;
        }
        FontData[] newFontData = new FontData[fontData.length];
        int i = 0;
        while (i < fontData.length) {
            FontData old = fontData[i];
            newFontData[i] = new FontData(name, old.getHeight(), old.getStyle());
            ++i;
        }
        return newFontData;
    }

    public static FontData[] newHeight(FontData[] fontData, int height) {
        if (height < 0 || fontData == null) {
            return fontData;
        }
        FontData[] newFontData = new FontData[fontData.length];
        int i = 0;
        while (i < fontData.length) {
            FontData old = fontData[i];
            newFontData[i] = new FontData(old.getName(), height, old.getStyle());
            ++i;
        }
        return newFontData;
    }

    public static FontData[] relativeHeight(FontData[] fontData, int deltaHeight) {
        if (deltaHeight == 0 || fontData == null) {
            return fontData;
        }
        FontData[] newFontData = new FontData[fontData.length];
        int i = 0;
        while (i < fontData.length) {
            FontData old = fontData[i];
            newFontData[i] = new FontData(old.getName(), old.getHeight() + deltaHeight, old.getStyle());
            ++i;
        }
        return newFontData;
    }

    public static FontData[] style(FontData[] fontData, Boolean bold, Boolean italic) {
        FontData[] newFontData = new FontData[fontData.length];
        int i = 0;
        while (i < fontData.length) {
            FontData old = fontData[i];
            int newStyle = old.getStyle();
            if (bold != null) {
                newStyle = bold.booleanValue() ? (newStyle |= 1) : (newStyle &= 0xFFFFFFFE);
            }
            if (italic != null) {
                newStyle = italic.booleanValue() ? (newStyle |= 2) : (newStyle &= 0xFFFFFFFD);
            }
            newFontData[i] = new FontData(old.getName(), old.getHeight(), newStyle);
            ++i;
        }
        return newFontData;
    }

    public static FontData[] bold(FontData[] fontData, boolean bold) {
        return FontUtils.style(fontData, bold, null);
    }

    public static FontData[] italic(FontData[] fontData, boolean italic) {
        return FontUtils.style(fontData, null, italic);
    }

    public static Font getNewName(Font font, String name) {
        if (font == null || name == null) {
            return font;
        }
        return FontUtils.getNewName(FontUtils.toString(font.getFontData()), name);
    }

    public static Font getNewHeight(Font font, int height) {
        if (font == null || height < 0) {
            return font;
        }
        return FontUtils.getNewHeight(FontUtils.toString(font.getFontData()), height);
    }

    public static Font getRelativeHeight(Font font, int deltaHeight) {
        if (font == null || deltaHeight == 0) {
            return font;
        }
        return FontUtils.getRelativeHeight(FontUtils.toString(font.getFontData()), deltaHeight);
    }

    public static Font getNewName(String key, String name) {
        FontData[] fontData;
        if (key == null || name == null) {
            return null;
        }
        String newKey = name == null ? key : String.valueOf(key) + "@name=" + name;
        FontRegistry reg = JFaceResources.getFontRegistry();
        if (reg.hasValueFor(newKey)) {
            return reg.get(newKey);
        }
        if (!reg.hasValueFor(key) && (fontData = FontUtils.toFontData(key)) != null) {
            reg.put(key, fontData);
        }
        if (reg.hasValueFor(key) || FontUtils.isDefaultKey(key)) {
            if (name == null) {
                return reg.get(key);
            }
            fontData = reg.getFontData(key);
            return FontUtils.getFont(newKey, FontUtils.newName(fontData, name));
        }
        return null;
    }

    public static Font getNewHeight(String key, int height) {
        FontData[] fontData;
        if (key == null) {
            return null;
        }
        String newKey = height < 0 ? key : String.valueOf(key) + "@height=" + height;
        FontRegistry reg = JFaceResources.getFontRegistry();
        if (reg.hasValueFor(newKey)) {
            return reg.get(newKey);
        }
        if (!reg.hasValueFor(key) && (fontData = FontUtils.toFontData(key)) != null) {
            reg.put(key, fontData);
        }
        if (reg.hasValueFor(key) || FontUtils.isDefaultKey(key)) {
            if (height < 0) {
                return reg.get(key);
            }
            fontData = reg.getFontData(key);
            return FontUtils.getFont(newKey, FontUtils.newHeight(fontData, height));
        }
        return null;
    }

    public static Font getRelativeHeight(String key, int deltaHeight) {
        FontData[] fontData;
        if (key == null) {
            return null;
        }
        String newKey = deltaHeight == 0 ? key : String.valueOf(key) + "@height+=" + deltaHeight;
        FontRegistry reg = JFaceResources.getFontRegistry();
        if (reg.hasValueFor(newKey)) {
            return reg.get(newKey);
        }
        if (!reg.hasValueFor(key) && (fontData = FontUtils.toFontData(key)) != null) {
            reg.put(key, fontData);
        }
        if (reg.hasValueFor(key) || FontUtils.isDefaultKey(key)) {
            if (deltaHeight == 0) {
                return reg.get(key);
            }
            fontData = reg.getFontData(key);
            return FontUtils.getFont(newKey, FontUtils.relativeHeight(fontData, deltaHeight));
        }
        return null;
    }

    private static boolean isDefaultKey(String key) {
        return "org.eclipse.jface.defaultfont".equals(key) || "org.eclipse.jface.dialogfont".equals(key) || "org.eclipse.jface.headerfont".equals(key) || "org.eclipse.jface.textfont".equals(key) || "org.eclipse.jface.bannerfont".equals(key);
    }

    public static Font getBold(FontData[] fontData) {
        return FontUtils.getBold(null, fontData);
    }

    public static Font getBold(Font font) {
        if (font == null) {
            return font;
        }
        return FontUtils.getBold(font.getFontData());
    }

    public static Font getBold(String key) {
        return FontUtils.getBold(key, null);
    }

    public static Font getBold(String key, int newHeight) {
        FontData[] fontData;
        if (key == null) {
            return null;
        }
        String newKey = newHeight < 0 ? key : String.valueOf(key) + "@bold,height=" + newHeight;
        FontRegistry reg = JFaceResources.getFontRegistry();
        if (reg.hasValueFor(newKey)) {
            return reg.get(newKey);
        }
        if (!reg.hasValueFor(key) && (fontData = FontUtils.toFontData(key)) != null) {
            reg.put(key, fontData);
        }
        if (reg.hasValueFor(key) || FontUtils.isDefaultKey(key)) {
            if (newHeight < 0) {
                return reg.get(key);
            }
            fontData = reg.getFontData(key);
            return FontUtils.getFont(newKey, FontUtils.bold(FontUtils.newHeight(fontData, newHeight), true));
        }
        return null;
    }

    public static Font getBoldRelative(String key, int relativeHeight) {
        FontData[] fontData;
        if (key == null) {
            return null;
        }
        String newKey = relativeHeight < 0 ? key : String.valueOf(key) + "@bold,height+=" + relativeHeight;
        FontRegistry reg = JFaceResources.getFontRegistry();
        if (reg.hasValueFor(newKey)) {
            return reg.get(newKey);
        }
        if (!reg.hasValueFor(key) && (fontData = FontUtils.toFontData(key)) != null) {
            reg.put(key, fontData);
        }
        if (reg.hasValueFor(key) || FontUtils.isDefaultKey(key)) {
            if (relativeHeight < 0) {
                return reg.get(key);
            }
            fontData = reg.getFontData(key);
            return FontUtils.getFont(newKey, FontUtils.bold(FontUtils.relativeHeight(fontData, relativeHeight), true));
        }
        return null;
    }

    public static Font getNewStyle(String key, int newStyle) {
        FontData[] fontData;
        if (key == null) {
            return null;
        }
        String newKey = newStyle < 0 ? key : String.valueOf(key) + "@style=" + newStyle;
        FontRegistry reg = JFaceResources.getFontRegistry();
        if (reg.hasValueFor(newKey)) {
            return reg.get(newKey);
        }
        if (!reg.hasValueFor(key) && (fontData = FontUtils.toFontData(key)) != null) {
            reg.put(key, fontData);
        }
        if (reg.hasValueFor(key) || FontUtils.isDefaultKey(key)) {
            if (newStyle < 0) {
                return reg.get(key);
            }
            fontData = reg.getFontData(key);
            return FontUtils.getFont(newKey, FontUtils.style(fontData, (newStyle & 1) != 0, (newStyle & 2) != 0));
        }
        return null;
    }

    public static Font getStyled(Font font, int newStyle) {
        if (font == null) {
            return null;
        }
        return FontUtils.getNewStyle(FontUtils.toString(font.getFontData()), newStyle);
    }

    public static Font getItalic(FontData[] fontData) {
        return FontUtils.getItalic(null, fontData);
    }

    public static Font getItalic(Font font) {
        if (font == null) {
            return font;
        }
        return FontUtils.getItalic(font.getFontData());
    }

    public static Font getItalic(String key) {
        return FontUtils.getItalic(key, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IFontNameListCallback {
        public void setAvailableFontNames(List<String> var1);
    }
}

