/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.io;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.xmind.ui.io.Messages;
import org.xmind.ui.io.MonitoredInputStream;
import org.xmind.ui.io.MonitoredOutputStream;
import org.xmind.ui.io.StreamInterruptedException;

public class DownloadJob
extends Job {
    public static final int SUCCESS = 0;
    public static final int FAILED = 4;
    public static final int CANCELED = 2;
    private String pluginId;
    private String sourceURL;
    private String targetPath;
    private OutputStream targetStream;

    public DownloadJob(String jobName, String sourceURL, String targetPath) {
        this(jobName, sourceURL, targetPath, "org.xmind.ui.toolkit");
    }

    public DownloadJob(String jobName, String sourceURL, String targetPath, String pluginId) {
        super(jobName);
        Assert.isNotNull((Object)sourceURL);
        Assert.isNotNull((Object)targetPath);
        this.sourceURL = sourceURL;
        this.targetPath = targetPath;
        this.pluginId = pluginId;
    }

    public DownloadJob(String jobName, String sourceURL, OutputStream targetStream) {
        this(jobName, sourceURL, targetStream, "org.xmind.ui.toolkit");
    }

    public DownloadJob(String jobName, String sourceURL, OutputStream targetStream, String pluginId) {
        super(jobName);
        Assert.isNotNull((Object)sourceURL);
        Assert.isNotNull((Object)targetStream);
        this.sourceURL = sourceURL;
        this.targetStream = targetStream;
        this.pluginId = pluginId;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public String getSourceURL() {
        return this.sourceURL;
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    protected IStatus run(IProgressMonitor monitor) {
        SubProgressMonitor monitor2;
        OutputStream os;
        InputStream is;
        int length;
        URLConnection connection;
        URL url;
        monitor.beginTask(null, 100);
        try {
            url = new URL(this.sourceURL);
        }
        catch (MalformedURLException e) {
            return this.errorStatus(e);
        }
        monitor.subTask(NLS.bind((String)Messages.ConnectingSource, (Object)this.getSourceURL()));
        try {
            connection = url.openConnection();
            length = connection.getContentLength();
        }
        catch (IOException e) {
            return this.errorStatus(e);
        }
        try {
            is = connection.getInputStream();
        }
        catch (IOException e) {
            return this.errorStatus(e);
        }
        monitor.subTask(NLS.bind((String)Messages.InitializingTarget, (Object)this.getTargetPath()));
        if (this.targetStream != null) {
            os = this.targetStream;
        } else {
            try {
                os = new FileOutputStream(this.targetPath);
            }
            catch (FileNotFoundException e) {
                DownloadJob.safeClose(is);
                return this.errorStatus(e);
            }
        }
        is = new MonitoredInputStream(is, monitor);
        os = new MonitoredOutputStream(os, monitor);
        monitor.subTask(Messages.TransferingData);
        SubProgressMonitor subProgressMonitor = monitor2 = length < 0 ? null : new SubProgressMonitor(monitor, 100);
        if (monitor2 != null) {
            monitor2.beginTask(null, Math.max(1, length / 1024));
        }
        String total = length < 0 ? null : String.format("%.1fK", (double)length / 1024.0);
        byte[] buffer = new byte[1024];
        int downloaded = 0;
        int worked = 0;
        try {
            try {
                int num;
                while ((num = is.read(buffer)) > 0) {
                    os.write(buffer, 0, num);
                    String taskName = total == null ? String.format("(%.1fK)", (double)downloaded / 1024.0) : String.format("(%.1fK/%s)", (double)(downloaded += num) / 1024.0, total);
                    monitor.subTask(String.valueOf(Messages.TransferingData) + " " + taskName);
                    if (monitor2 != null) {
                        monitor2.worked(1);
                        continue;
                    }
                    if (worked >= 99) continue;
                    ++worked;
                    monitor.worked(1);
                }
            }
            catch (IOException e) {
                if (e instanceof StreamInterruptedException) {
                    Status status = new Status(2, this.pluginId, 2, NLS.bind((String)Messages.DownloadCanceled, (Object)this.getSourceURL(), (Object)this.getTargetPath()), null);
                    DownloadJob.safeClose(is);
                    DownloadJob.safeClose(os);
                    return status;
                }
                IStatus iStatus = this.errorStatus(e);
                DownloadJob.safeClose(is);
                DownloadJob.safeClose(os);
                return iStatus;
            }
        }
        finally {
            DownloadJob.safeClose(is);
            DownloadJob.safeClose(os);
        }
        monitor.done();
        return new Status(0, this.pluginId, 0, NLS.bind((String)Messages.DownloadFinished, (Object)this.getSourceURL(), (Object)this.getTargetPath()), null);
    }

    private static void safeClose(InputStream is) {
        try {
            is.close();
        }
        catch (IOException iOException) {}
    }

    private static void safeClose(OutputStream os) {
        try {
            os.close();
        }
        catch (IOException iOException) {}
    }

    private IStatus errorStatus(Throwable e) {
        return new Status(4, this.pluginId, 4, NLS.bind((String)Messages.DownloadFailed, (Object)this.getSourceURL(), (Object)this.getTargetPath()), e);
    }
}

