/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import com.sun.management.VMOption;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import sun.management.LazyCompositeData;
import sun.management.MappedMXBeanType;
import sun.management.Util;

public class VMOptionCompositeData
extends LazyCompositeData {
    private final VMOption option;
    private static final CompositeType vmOptionCompositeType;
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private static final String WRITEABLE = "writeable";
    private static final String ORIGIN = "origin";
    private static final String[] vmOptionItemNames;

    private VMOptionCompositeData(VMOption vMOption) {
        this.option = vMOption;
    }

    public VMOption getVMOption() {
        return this.option;
    }

    public static CompositeData toCompositeData(VMOption vMOption) {
        VMOptionCompositeData vMOptionCompositeData = new VMOptionCompositeData(vMOption);
        return vMOptionCompositeData.getCompositeData();
    }

    protected CompositeData getCompositeData() {
        Object[] objectArray = new Object[]{this.option.getName(), this.option.getValue(), new Boolean(this.option.isWriteable()), this.option.getOrigin().toString()};
        try {
            return new CompositeDataSupport(vmOptionCompositeType, vmOptionItemNames, objectArray);
        }
        catch (OpenDataException openDataException) {
            throw Util.newInternalError(openDataException);
        }
    }

    static CompositeType getVMOptionCompositeType() {
        return vmOptionCompositeType;
    }

    public static String getName(CompositeData compositeData) {
        return VMOptionCompositeData.getString(compositeData, NAME);
    }

    public static String getValue(CompositeData compositeData) {
        return VMOptionCompositeData.getString(compositeData, VALUE);
    }

    public static VMOption.Origin getOrigin(CompositeData compositeData) {
        String string = VMOptionCompositeData.getString(compositeData, ORIGIN);
        return Enum.valueOf(VMOption.Origin.class, string);
    }

    public static boolean isWriteable(CompositeData compositeData) {
        return VMOptionCompositeData.getBoolean(compositeData, WRITEABLE);
    }

    public static void validateCompositeData(CompositeData compositeData) {
        if (compositeData == null) {
            throw new NullPointerException("Null CompositeData");
        }
        if (!VMOptionCompositeData.isTypeMatched(vmOptionCompositeType, compositeData.getCompositeType())) {
            throw new IllegalArgumentException("Unexpected composite type for VMOption");
        }
    }

    static {
        try {
            vmOptionCompositeType = (CompositeType)MappedMXBeanType.toOpenType(VMOption.class);
        }
        catch (OpenDataException openDataException) {
            throw Util.newInternalError(openDataException);
        }
        vmOptionItemNames = new String[]{NAME, VALUE, WRITEABLE, ORIGIN};
    }
}

