/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.d3d;

import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.image.ColorModel;
import sun.awt.Win32GraphicsConfig;
import sun.awt.image.SunVolatileImage;
import sun.awt.image.SurfaceManager;
import sun.awt.image.VolatileSurfaceManager;
import sun.awt.windows.WComponentPeer;
import sun.java2d.InvalidPipeException;
import sun.java2d.SurfaceData;
import sun.java2d.d3d.D3DGraphicsConfig;
import sun.java2d.d3d.D3DGraphicsDevice;
import sun.java2d.d3d.D3DScreenUpdateManager;
import sun.java2d.d3d.D3DSurfaceData;
import sun.java2d.windows.GDIWindowSurfaceData;

public class D3DVolatileSurfaceManager
extends VolatileSurfaceManager {
    private boolean accelerationEnabled;
    private int restoreCountdown;

    public D3DVolatileSurfaceManager(SunVolatileImage sunVolatileImage, Object object) {
        super(sunVolatileImage, object);
        int n = sunVolatileImage.getTransparency();
        D3DGraphicsDevice d3DGraphicsDevice = (D3DGraphicsDevice)sunVolatileImage.getGraphicsConfig().getDevice();
        this.accelerationEnabled = n == 1 || n == 3 && (d3DGraphicsDevice.isCapPresent(2) || d3DGraphicsDevice.isCapPresent(4));
    }

    protected boolean isAccelerationEnabled() {
        return this.accelerationEnabled;
    }

    public void setAccelerationEnabled(boolean bl) {
        this.accelerationEnabled = bl;
    }

    protected SurfaceData initAcceleratedSurface() {
        D3DSurfaceData d3DSurfaceData;
        Component component = this.vImg.getComponent();
        WComponentPeer wComponentPeer = component != null ? (WComponentPeer)component.getPeer() : null;
        try {
            boolean bl = false;
            if (this.context instanceof Boolean) {
                bl = (Boolean)this.context;
            }
            if (bl) {
                d3DSurfaceData = D3DSurfaceData.createData(wComponentPeer, this.vImg);
            } else {
                D3DGraphicsConfig d3DGraphicsConfig = (D3DGraphicsConfig)this.vImg.getGraphicsConfig();
                ColorModel colorModel = d3DGraphicsConfig.getColorModel(this.vImg.getTransparency());
                int n = this.vImg.getForcedAccelSurfaceType();
                if (n == 0) {
                    n = 5;
                }
                d3DSurfaceData = D3DSurfaceData.createData(d3DGraphicsConfig, this.vImg.getWidth(), this.vImg.getHeight(), colorModel, this.vImg, n);
            }
        }
        catch (NullPointerException nullPointerException) {
            d3DSurfaceData = null;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            d3DSurfaceData = null;
        }
        catch (InvalidPipeException invalidPipeException) {
            d3DSurfaceData = null;
        }
        return d3DSurfaceData;
    }

    protected boolean isConfigValid(GraphicsConfiguration graphicsConfiguration) {
        return graphicsConfiguration == null || graphicsConfiguration == this.vImg.getGraphicsConfig();
    }

    private synchronized void setRestoreCountdown(int n) {
        this.restoreCountdown = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void restoreAcceleratedSurface() {
        Object object = this;
        synchronized (object) {
            if (this.restoreCountdown > 0) {
                --this.restoreCountdown;
                throw new InvalidPipeException("Will attempt to restore surface  in " + this.restoreCountdown);
            }
        }
        object = this.initAcceleratedSurface();
        if (object == null) {
            throw new InvalidPipeException("could not restore surface");
        }
        this.sdAccel = object;
    }

    public SurfaceData restoreContents() {
        this.acceleratedSurfaceLost();
        return super.restoreContents();
    }

    static void handleVItoScreenOp(SurfaceData surfaceData, SurfaceData surfaceData2) {
        D3DVolatileSurfaceManager d3DVolatileSurfaceManager;
        D3DSurfaceData d3DSurfaceData;
        SurfaceManager surfaceManager;
        if (surfaceData instanceof D3DSurfaceData && surfaceData2 instanceof GDIWindowSurfaceData && (surfaceManager = SurfaceManager.getManager((Image)(d3DSurfaceData = (D3DSurfaceData)surfaceData).getDestination())) instanceof D3DVolatileSurfaceManager && (d3DVolatileSurfaceManager = (D3DVolatileSurfaceManager)surfaceManager) != null) {
            d3DSurfaceData.setSurfaceLost(true);
            GDIWindowSurfaceData gDIWindowSurfaceData = (GDIWindowSurfaceData)surfaceData2;
            WComponentPeer wComponentPeer = gDIWindowSurfaceData.getPeer();
            if (D3DScreenUpdateManager.canUseD3DOnScreen(wComponentPeer, (Win32GraphicsConfig)wComponentPeer.getGraphicsConfiguration(), wComponentPeer.getBackBuffersNum())) {
                d3DVolatileSurfaceManager.setRestoreCountdown(10);
            } else {
                d3DVolatileSurfaceManager.setAccelerationEnabled(false);
            }
        }
    }

    public void initContents() {
        if (this.vImg.getForcedAccelSurfaceType() != 3) {
            super.initContents();
        }
    }
}

