/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.transport.http.client;

import com.sun.istack.internal.NotNull;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.pipe.Codec;
import com.sun.xml.internal.ws.api.pipe.ContentType;
import com.sun.xml.internal.ws.api.pipe.NextAction;
import com.sun.xml.internal.ws.api.pipe.TubeCloner;
import com.sun.xml.internal.ws.api.pipe.helper.AbstractTubeImpl;
import com.sun.xml.internal.ws.transport.http.client.HttpClientTransport;
import com.sun.xml.internal.ws.transport.http.client.HttpResponseProperties;
import com.sun.xml.internal.ws.util.ByteArrayBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpTransportPipe
extends AbstractTubeImpl {
    private final Codec codec;
    public static boolean dump;

    public HttpTransportPipe(Codec codec) {
        this.codec = codec;
    }

    private HttpTransportPipe(HttpTransportPipe httpTransportPipe, TubeCloner tubeCloner) {
        this(httpTransportPipe.codec.copy());
        tubeCloner.add(httpTransportPipe, this);
    }

    @Override
    public NextAction processException(@NotNull Throwable throwable) {
        throw new IllegalStateException("HttpTransportPipe's processException shouldn't be called.");
    }

    @Override
    public NextAction processRequest(@NotNull Packet packet) {
        return this.doReturnWith(this.process(packet));
    }

    @Override
    public NextAction processResponse(@NotNull Packet packet) {
        throw new IllegalStateException("HttpTransportPipe's processResponse shouldn't be called.");
    }

    @Override
    public Packet process(Packet packet) {
        try {
            Object object;
            Object object2;
            HashMap<String, List<String>> hashMap = (HashMap<String, List<String>>)packet.invocationProperties.get("javax.xml.ws.http.request.headers");
            if (hashMap == null) {
                hashMap = new HashMap<String, List<String>>();
            }
            HttpClientTransport httpClientTransport = new HttpClientTransport(packet, hashMap);
            packet.addSatellite(new HttpResponseProperties(httpClientTransport));
            ContentType contentType = this.codec.getStaticContentType(packet);
            if (contentType == null) {
                object2 = new ByteArrayBuffer();
                contentType = this.codec.encode(packet, (OutputStream)object2);
                hashMap.put("Content-Length", Collections.singletonList(Integer.toString(((ByteArrayBuffer)object2).size())));
                hashMap.put("Content-Type", Collections.singletonList(contentType.getContentType()));
                if (contentType.getAcceptHeader() != null) {
                    hashMap.put("Accept", Collections.singletonList(contentType.getAcceptHeader()));
                }
                this.writeSOAPAction(hashMap, contentType.getSOAPActionHeader(), packet);
                if (dump) {
                    this.dump((ByteArrayBuffer)object2, "HTTP request", hashMap);
                }
                ((ByteArrayBuffer)object2).writeTo(httpClientTransport.getOutput());
            } else {
                hashMap.put("Content-Type", Collections.singletonList(contentType.getContentType()));
                if (contentType.getAcceptHeader() != null) {
                    hashMap.put("Accept", Collections.singletonList(contentType.getAcceptHeader()));
                }
                this.writeSOAPAction(hashMap, contentType.getSOAPActionHeader(), packet);
                if (dump) {
                    object2 = new ByteArrayBuffer();
                    this.codec.encode(packet, (OutputStream)object2);
                    this.dump((ByteArrayBuffer)object2, "HTTP request", hashMap);
                    object = httpClientTransport.getOutput();
                    if (object != null) {
                        ((ByteArrayBuffer)object2).writeTo((OutputStream)object);
                    }
                } else {
                    object2 = httpClientTransport.getOutput();
                    if (object2 != null) {
                        this.codec.encode(packet, (OutputStream)object2);
                    }
                }
            }
            httpClientTransport.closeOutput();
            httpClientTransport.checkResponseCode();
            if (httpClientTransport.statusCode == 202) {
                return packet.createClientResponse(null);
            }
            object2 = httpClientTransport.getContentType();
            if (object2 == null) {
                throw new WebServiceException("No Content-type in the header!");
            }
            object = packet.createClientResponse(null);
            ((Packet)object).wasTransportSecure = httpClientTransport.isSecure();
            InputStream inputStream = httpClientTransport.getInput();
            if (dump) {
                ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer();
                byteArrayBuffer.write(inputStream);
                this.dump(byteArrayBuffer, "HTTP response " + httpClientTransport.statusCode, httpClientTransport.getHeaders());
                inputStream = byteArrayBuffer.newInputStream();
            }
            this.codec.decode(inputStream, (String)object2, (Packet)object);
            return object;
        }
        catch (WebServiceException webServiceException) {
            throw webServiceException;
        }
        catch (Exception exception) {
            throw new WebServiceException(exception);
        }
    }

    private void writeSOAPAction(Map<String, List<String>> map, String string, Packet packet) {
        if (string != null) {
            map.put("SOAPAction", Collections.singletonList(string));
        } else {
            map.put("SOAPAction", Collections.singletonList("\"\""));
        }
    }

    @Override
    public void preDestroy() {
    }

    @Override
    public HttpTransportPipe copy(TubeCloner tubeCloner) {
        return new HttpTransportPipe(this, tubeCloner);
    }

    private void dump(ByteArrayBuffer byteArrayBuffer, String string, Map<String, List<String>> map) throws IOException {
        System.out.println("---[" + string + "]---");
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            if (entry.getValue().isEmpty()) {
                System.out.println(entry.getValue());
                continue;
            }
            for (String string2 : entry.getValue()) {
                System.out.println(entry.getKey() + ": " + string2);
            }
        }
        byteArrayBuffer.writeTo(System.out);
        System.out.println("--------------------");
    }

    static {
        boolean bl;
        try {
            bl = Boolean.getBoolean(HttpTransportPipe.class.getName() + ".dump");
        }
        catch (Throwable throwable) {
            bl = false;
        }
        dump = bl;
    }
}

